/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.MapMethodTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SingleArgToMapTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SingleArgumentMethodTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependencyModelImpl
extends DependencyModelImpl
implements ModuleDependencyModel {
    @NonNls
    public static final String PROJECT = "project";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String CONFIGURATION = "configuration";
    @NotNull
    private GradleDslMethodCall myDslElement;

    @Nullable
    static ModuleDependencyModel create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall, @NotNull DependencyModelImpl.Maintainer maintainer) {
        if (PROJECT.equals(methodCall.getMethodName())) {
            return new ModuleDependencyModelImpl(configurationName, methodCall, maintainer);
        }
        return null;
    }

    @NotNull
    static ModuleDependencyModel createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull String path, @Nullable String config) {
        GradleNameElement name = GradleNameElement.create(configurationName);
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)parent, name, PROJECT);
        GradleDslExpressionMap mapArguments = new GradleDslExpressionMap(methodCall, name);
        mapArguments.setNewLiteral(PATH, path);
        if (config != null) {
            mapArguments.setNewLiteral(CONFIGURATION, config);
        }
        methodCall.addNewArgument(mapArguments);
        parent.setNewElement(methodCall);
        return new ModuleDependencyModelImpl(configurationName, methodCall, DependenciesModelImpl.Maintainers.SINGLE_ITEM_MAINTAINER);
    }

    private ModuleDependencyModelImpl(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
        super(configurationName, maintainer);
        this.myDslElement = dslElement;
    }

    @Override
    @NotNull
    protected GradleDslMethodCall getDslElement() {
        return this.myDslElement;
    }

    @Override
    void setDslElement(@NotNull GradleDslElement dslElement) {
        this.myDslElement = (GradleDslMethodCall)dslElement;
    }

    @Override
    @NotNull
    public String name() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.path().forceString());
        int segmentCount = pathSegments.size();
        return segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
    }

    @Override
    public void setName(@NotNull String name) {
        String newPath;
        ResolvedPropertyModel path = this.path();
        List segments = Splitter.on((String)":").splitToList((CharSequence)path.forceString());
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + name.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, name);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        path.setValue(newPath);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel path() {
        return GradlePropertyModelBuilder.create(this.myDslElement).asMethod(true).addTransform(new MapMethodTransform(PROJECT, PATH)).addTransform(new SingleArgumentMethodTransform(PROJECT)).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel configuration() {
        return GradlePropertyModelBuilder.create(this.myDslElement).asMethod(true).addTransform(new SingleArgToMapTransform(PATH, CONFIGURATION)).addTransform(new MapMethodTransform(PROJECT, CONFIGURATION)).buildResolved();
    }
}

