/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PasswordPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.SigningConfigPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.model.java.LanguageLevelPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertyModelBuilder {
    @Nullable
    private final GradlePropertiesDslElement myHolder;
    @NotNull
    private final String myName;
    @Nullable
    private final GradleDslElement myElement;
    @NotNull
    private PropertyType myType = PropertyType.REGULAR;
    private boolean myIsMethod = false;
    @NotNull
    private List<PropertyTransform> myTransforms = new ArrayList<PropertyTransform>();

    @NotNull
    public static GradlePropertyModelBuilder create(@NotNull GradlePropertiesDslElement holder, @NotNull String name) {
        return new GradlePropertyModelBuilder(holder, name);
    }

    @NotNull
    public static GradlePropertyModelBuilder create(@NotNull GradleDslElement element) {
        return new GradlePropertyModelBuilder(element);
    }

    private GradlePropertyModelBuilder(@NotNull GradlePropertiesDslElement holder, @NotNull String name) {
        this.myHolder = holder;
        this.myName = name;
        this.myElement = null;
    }

    private GradlePropertyModelBuilder(@NotNull GradleDslElement element) {
        this.myHolder = null;
        this.myName = element.getName();
        this.myElement = element;
        this.myIsMethod = !this.myElement.shouldUseAssignment();
    }

    public GradlePropertyModelBuilder asMethod(boolean bool) {
        this.myIsMethod = bool;
        return this;
    }

    public GradlePropertyModelBuilder withType(@NotNull PropertyType type) {
        this.myType = type;
        return this;
    }

    public GradlePropertyModelBuilder addTransform(@NotNull PropertyTransform transform2) {
        this.myTransforms.add(0, transform2);
        return this;
    }

    @Nullable
    private GradleDslElement getElement() {
        if (this.myElement != null) {
            return this.myElement;
        }
        assert (this.myHolder != null);
        return this.myHolder.getPropertyElement(this.myName);
    }

    @NotNull
    private GradleDslElement getParentElement() {
        if (this.myHolder != null) {
            return this.myHolder;
        }
        assert (this.myElement != null && this.myElement.getParent() != null);
        return this.myElement.getParent();
    }

    public GradlePropertyModelImpl build() {
        GradleDslElement currentElement = this.getElement();
        GradlePropertyModelImpl model2 = currentElement == null ? new GradlePropertyModelImpl(this.getParentElement(), this.myType, this.myName) : new GradlePropertyModelImpl(currentElement);
        return this.setUpModel(model2);
    }

    public SigningConfigPropertyModelImpl buildSigningConfig() {
        return new SigningConfigPropertyModelImpl(this.build());
    }

    public PasswordPropertyModelImpl buildPassword() {
        GradleDslElement currentElement = this.getElement();
        PasswordPropertyModelImpl model2 = currentElement == null ? new PasswordPropertyModelImpl(this.getParentElement(), this.myType, this.myName) : new PasswordPropertyModelImpl(currentElement);
        return this.setUpModel(model2);
    }

    public ResolvedPropertyModelImpl buildResolved() {
        return this.build().resolve();
    }

    public LanguageLevelPropertyModelImpl buildLanguage() {
        return new LanguageLevelPropertyModelImpl(this.build());
    }

    @NotNull
    private <T extends GradlePropertyModelImpl> T setUpModel(@NotNull T model2) {
        if (this.myIsMethod) {
            model2.markAsMethodCall();
        }
        for (PropertyTransform t : this.myTransforms) {
            model2.addTransform(t);
        }
        return model2;
    }
}

