/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.util.TypeReference;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslUnknownElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertyModelImpl
implements GradlePropertyModel {
    @Nullable
    protected GradleDslElement myElement;
    @NotNull
    private GradleDslElement myPropertyHolder;
    private boolean myIsMethodCall;
    @NotNull
    private List<PropertyTransform> myTransforms = new ArrayList<PropertyTransform>();
    @NotNull
    private final PropertyType myPropertyType;
    @NotNull
    protected String myName;

    public GradlePropertyModelImpl(@NotNull GradleDslElement element) {
        this.myElement = element;
        this.myTransforms.add(PropertyUtil.DEFAULT_TRANSFORM);
        GradleDslElement parent = element.getParent();
        assert (parent instanceof GradlePropertiesDslElement || parent instanceof GradleDslMethodCall) : "Property found to be invalid, this should never happen!";
        this.myPropertyHolder = parent;
        this.myPropertyType = this.myElement.getElementType();
        this.myName = this.myElement.getName();
        this.myIsMethodCall = false;
    }

    public GradlePropertyModelImpl(@NotNull GradleDslElement element, @NotNull PropertyType type, @NotNull String name) {
        this.myPropertyHolder = element;
        this.myPropertyType = type;
        this.myName = name;
        this.myTransforms.add(PropertyUtil.DEFAULT_TRANSFORM);
        this.myIsMethodCall = false;
    }

    public void markAsMethodCall() {
        this.myIsMethodCall = true;
    }

    public void addTransform(@NotNull PropertyTransform transform2) {
        this.myTransforms.add(0, transform2);
    }

    @Override
    @NotNull
    public GradlePropertyModel.ValueType getValueType() {
        return GradlePropertyModelImpl.extractAndGetValueType(this.getElement());
    }

    @Override
    @NotNull
    public PropertyType getPropertyType() {
        GradleDslElement element = this.getElement();
        return element == null ? this.myPropertyType : element.getElementType();
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull TypeReference<T> typeReference) {
        return this.extractValue(typeReference, true);
    }

    @Override
    public <T> T getRawValue(@NotNull TypeReference<T> typeReference) {
        return this.extractValue(typeReference, false);
    }

    @Nullable
    private static GradleDslElement maybeGetInnerReferenceModel(@NotNull GradleDslElement element) {
        GradleDslLiteral reference2;
        GradleReferenceInjection injection;
        GradleDslExpression expression;
        GradleDslExpressionList list;
        if (GradlePropertyModelImpl.extractAndGetValueType(element) == GradlePropertyModel.ValueType.LIST && element instanceof GradleDslExpressionList && (list = (GradleDslExpressionList)element).getExpressions().size() == 1 && (expression = list.getElementAt(0)) instanceof GradleDslLiteral && ((GradleDslLiteral)expression).isReference() && (injection = (reference2 = (GradleDslLiteral)expression).getReferenceInjection()) != null) {
            return injection.getToBeInjected();
        }
        return null;
    }

    @NotNull
    private Map<String, GradlePropertyModel> getMap(boolean resolved) {
        GradleDslExpressionMap map2;
        GradleDslElement element = this.getElement();
        if (element == null) {
            return ImmutableMap.of();
        }
        GradleDslElement innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element);
        if (resolved && innerElement instanceof GradleDslExpressionMap) {
            map2 = (GradleDslExpressionMap)innerElement;
        } else {
            assert (element instanceof GradleDslExpressionMap);
            map2 = (GradleDslExpressionMap)element;
        }
        return map2.getPropertyElements(GradleDslExpression.class).stream().collect(Collectors.toMap(e -> e.getName(), e -> new GradlePropertyModelImpl((GradleDslElement)e), (u, v) -> v, LinkedHashMap::new));
    }

    @NotNull
    private List<GradlePropertyModel> getList(boolean resolved) {
        GradleDslElement innerElement;
        GradleDslElement element = this.getElement();
        if (element == null) {
            return ImmutableList.of();
        }
        assert (element instanceof GradleDslExpressionList);
        GradleDslExpressionList list = (GradleDslExpressionList)element;
        if (resolved && (innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element)) instanceof GradleDslExpressionList) {
            list = (GradleDslExpressionList)innerElement;
        }
        return list.getExpressions().stream().map(e -> new GradlePropertyModelImpl((GradleDslElement)e)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public String getName() {
        GradleDslExpressionList list;
        int index;
        GradleDslElement element = this.getElement();
        if (element != null && element.getParent() instanceof GradleDslExpressionList && (index = (list = (GradleDslExpressionList)element.getParent()).findIndexOf(element)) != -1) {
            return String.valueOf(index);
        }
        return element == null ? this.myName : element.getName();
    }

    @Override
    @NotNull
    public List<GradlePropertyModel> getDependencies() {
        return new ArrayList<GradlePropertyModel>(this.dependencies());
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        GradleDslElement element = this.getElement();
        if (element != null && element.getParent() instanceof GradleDslExpressionList) {
            GradleDslExpressionList list = (GradleDslExpressionList)element.getParent();
            return element.getParent().getQualifiedName() + "[" + String.valueOf(list.findIndexOf(element)) + "]";
        }
        return element == null ? this.myPropertyHolder.getQualifiedName() + "." + this.getName() : element.getQualifiedName();
    }

    @Override
    @NotNull
    public VirtualFile getGradleFile() {
        return this.myPropertyHolder.getDslFile().getFile();
    }

    @Override
    public void setValue(@NotNull Object value2) {
        GradleDslExpression newElement = this.getTransform().bind(this.myPropertyHolder, this.myElement, value2, this.myName);
        this.bindToNewElement(newElement);
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyMap() {
        this.makeEmptyMap();
        return this;
    }

    @Override
    @NotNull
    public GradlePropertyModel getMapValue(@NotNull String key) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.MAP && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add map value to type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToMap before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyMap();
        }
        GradleDslElement element = this.getTransform().transform(this.myElement);
        assert (element instanceof GradleDslExpressionMap);
        GradleDslExpressionMap map2 = (GradleDslExpressionMap)element;
        GradleDslElement arg = map2.getPropertyElement(key);
        return arg == null ? new GradlePropertyModelImpl(element, PropertyType.DERIVED, key) : new GradlePropertyModelImpl(arg);
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyList() {
        this.makeEmptyList();
        return this;
    }

    @Override
    @NotNull
    public GradlePropertyModel addListValue() {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add list value to type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToList before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        GradleDslElement element = this.getTransform().transform(this.myElement);
        assert (element instanceof GradleDslExpressionList);
        return this.addListValueAt(((GradleDslExpressionList)element).getExpressions().size());
    }

    @Override
    @NotNull
    public GradlePropertyModel addListValueAt(int index) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add list value to type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToList before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        GradleDslElement element = this.getTransform().transform(this.myElement);
        assert (element instanceof GradleDslExpressionList);
        GradleDslLiteral literal = new GradleDslLiteral(element, GradleNameElement.fake(this.myName));
        literal.setValue("");
        GradleDslExpressionList list = (GradleDslExpressionList)element;
        list.addNewExpression(literal, index);
        return new GradlePropertyModelImpl(literal);
    }

    @Override
    @Nullable
    public GradlePropertyModel getListValue(@NotNull Object value2) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't get list value on type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToList before trying to get values");
        }
        List list = (List)this.getValue(LIST_TYPE);
        if (list == null) {
            return null;
        }
        return list.stream().filter(e -> {
            Object v = e.getValue(OBJECT_TYPE);
            return v != null && v.equals(value2);
        }).findFirst().orElse(null);
    }

    @Override
    public void delete() {
        GradleDslElement element = this.getElement();
        if (element == null || this.myElement == null) {
            return;
        }
        this.myElement = this.getTransform().delete(this.myPropertyHolder, this.myElement, element);
    }

    @Override
    @NotNull
    public ResolvedPropertyModelImpl resolve() {
        return new ResolvedPropertyModelImpl(this);
    }

    @Override
    @NotNull
    public GradlePropertyModel getUnresolvedModel() {
        return this;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        GradleDslElement element = this.getElement();
        if (element == null) {
            return null;
        }
        return element.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement getExpressionPsiElement() {
        return this.getExpressionPsiElement(false);
    }

    @Override
    @Nullable
    public PsiElement getFullExpressionPsiElement() {
        return this.getExpressionPsiElement(true);
    }

    @Nullable
    private PsiElement getExpressionPsiElement(boolean fullExpression) {
        GradleDslElement element;
        GradleDslElement gradleDslElement = element = fullExpression ? this.myElement : this.getElement();
        if (element instanceof GradleDslExpression) {
            return ((GradleDslExpression)element).getExpression();
        }
        return element == null ? null : element.getPsiElement();
    }

    @Override
    public void rename(@NotNull String name) {
        if (this.myElement == null) {
            this.myName = name;
            return;
        }
        GradleDslElement element = this.getElement();
        if (element == null) {
            return;
        }
        GradleDslElement parent = element.getParent();
        if (parent instanceof GradleDslExpressionList || parent instanceof GradleDslMethodCall) {
            throw new UnsupportedOperationException("Can't rename list values!");
        }
        element.rename(name);
        this.myName = this.myElement.getName();
    }

    @Override
    public boolean isModified() {
        GradleDslElement element = this.myElement;
        if (element != null) {
            if (element instanceof FakeElement) {
                return PropertyUtil.isFakeElementModified((FakeElement)element);
            }
            GradleDslElement originalElement = PropertyUtil.findOriginalElement(this.myPropertyHolder, element);
            return originalElement == null || PropertyUtil.isElementModified(originalElement, element);
        }
        GradlePropertiesDslElement holder = this.myPropertyHolder instanceof GradleDslMethodCall ? ((GradleDslMethodCall)this.myPropertyHolder).getArgumentsElement() : (GradlePropertiesDslElement)this.myPropertyHolder;
        return holder.getOriginalElementForNameAndType(this.myName, this.myPropertyType) != null;
    }

    @Override
    public String toString() {
        return (String)this.getValue(STRING_TYPE);
    }

    @Override
    @NotNull
    public String forceString() {
        String s = this.toString();
        assert (s != null);
        return s;
    }

    @Override
    @Nullable
    public Integer toInt() {
        return (Integer)this.getValue(INTEGER_TYPE);
    }

    @Override
    @Nullable
    public BigDecimal toBigDecimal() {
        return (BigDecimal)this.getValue(BIG_DECIMAL_TYPE);
    }

    @Override
    @Nullable
    public Boolean toBoolean() {
        return (Boolean)this.getValue(BOOLEAN_TYPE);
    }

    @Override
    @Nullable
    public List<GradlePropertyModel> toList() {
        return (List)this.getValue(LIST_TYPE);
    }

    @Override
    @Nullable
    public Map<String, GradlePropertyModel> toMap() {
        return (Map)this.getValue(MAP_TYPE);
    }

    private static GradlePropertyModel.ValueType extractAndGetValueType(@Nullable GradleDslElement element) {
        if (element == null) {
            return GradlePropertyModel.ValueType.NONE;
        }
        if (element instanceof GradleDslExpressionMap) {
            return GradlePropertyModel.ValueType.MAP;
        }
        if (element instanceof GradleDslExpressionList) {
            return GradlePropertyModel.ValueType.LIST;
        }
        if (element instanceof GradleDslSimpleExpression && ((GradleDslSimpleExpression)element).isReference()) {
            return GradlePropertyModel.ValueType.REFERENCE;
        }
        if (element instanceof GradleDslMethodCall && (element.shouldUseAssignment() || element.getElementType() == PropertyType.DERIVED) || element instanceof GradleDslUnknownElement) {
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        if (element instanceof GradleDslSimpleExpression) {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)element;
            Object value2 = expression.getValue();
            if (value2 instanceof Boolean) {
                return GradlePropertyModel.ValueType.BOOLEAN;
            }
            if (value2 instanceof Integer) {
                return GradlePropertyModel.ValueType.INTEGER;
            }
            if (value2 instanceof String) {
                return GradlePropertyModel.ValueType.STRING;
            }
            if (value2 instanceof BigDecimal) {
                return GradlePropertyModel.ValueType.BIG_DECIMAL;
            }
            if (value2 == null) {
                return GradlePropertyModel.ValueType.NONE;
            }
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        return GradlePropertyModel.ValueType.UNKNOWN;
    }

    @Nullable
    private <T> T extractValue(@NotNull TypeReference<T> typeReference, boolean resolved) {
        Object value2;
        GradleDslElement element = this.getElement();
        if (element == null) {
            return null;
        }
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType == GradlePropertyModel.ValueType.MAP) {
            value2 = this.getMap(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.LIST) {
            value2 = this.getList(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.REFERENCE) {
            GradleDslSimpleExpression ref = (GradleDslSimpleExpression)element;
            String refText = ref.getReferenceText();
            value2 = typeReference.getType() == Object.class || typeReference.getType() == ReferenceTo.class ? (refText == null ? null : typeReference.castTo(new ReferenceTo(refText))) : (refText == null ? null : typeReference.castTo(refText));
        } else if (valueType == GradlePropertyModel.ValueType.UNKNOWN) {
            if (!(element instanceof GradleDslBlockElement)) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = element instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)element).getCurrentElement() : element.getPsiElement();
                if (psiElement == null) {
                    return null;
                }
                value2 = GradleDslElementImpl.getPsiText(psiElement);
            } else {
                value2 = element.getFullName();
            }
        } else {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)element;
            Object object = value2 = resolved ? expression.getValue() : expression.getUnresolvedValue();
        }
        if (value2 == null) {
            return null;
        }
        T result2 = typeReference.castTo(value2);
        if (result2 == null && typeReference.getType().equals(String.class)) {
            result2 = typeReference.castTo(value2.toString());
        }
        return result2;
    }

    private void makeEmptyMap() {
        this.bindToNewElement(this.getTransform().bindMap(this.myPropertyHolder, this.myElement, this.myName, this.myIsMethodCall));
    }

    private void makeEmptyList() {
        this.bindToNewElement(this.getTransform().bindList(this.myPropertyHolder, this.myElement, this.myName, this.myIsMethodCall));
    }

    private void bindToNewElement(@NotNull GradleDslExpression newElement) {
        if (newElement == this.myElement) {
            return;
        }
        if (this.myElement != null && this.myElement.getElementType() == PropertyType.FAKE) {
            throw new UnsupportedOperationException("Can't bind from a fake element!");
        }
        GradleDslElement element = this.getTransform().replace(this.myPropertyHolder, this.myElement, newElement, this.myName);
        element.setElementType(this.myPropertyType);
        element.setUseAssignment(!this.myIsMethodCall);
        element.setModified();
        this.myElement = element;
    }

    @Nullable
    GradleDslElement getElement() {
        return this.getTransform().transform(this.myElement);
    }

    @NotNull
    protected PropertyTransform getTransform() {
        for (PropertyTransform transform2 : this.myTransforms) {
            if (!transform2.test(this.myElement)) continue;
            return transform2;
        }
        throw new IllegalStateException("No transforms found for this property model!");
    }

    @NotNull
    List<GradlePropertyModelImpl> dependencies() {
        GradleDslElement element = this.getElement();
        if (element == null) {
            return Collections.emptyList();
        }
        return element.getResolvedVariables().stream().map(injection -> {
            GradleDslElement injected = injection.getToBeInjected();
            return injected != null ? new GradlePropertyModelImpl(injected) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

