/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.MultiTypePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiTypePropertyModelImpl<T extends Enum<T>>
extends GradlePropertyModelImpl
implements MultiTypePropertyModel<T> {
    @NotNull
    private Map<T, PropertyTransform> myTransforms;
    @NotNull
    private T myType;

    public MultiTypePropertyModelImpl(@NotNull T defaultType, @NotNull GradleDslElement element, @NotNull Map<T, PropertyTransform> transformMap) {
        super(element);
        this.myTransforms = new LinkedHashMap<T, PropertyTransform>(transformMap);
        this.myType = defaultType;
        this.setUpTransforms();
    }

    public MultiTypePropertyModelImpl(@NotNull T defaultType, @NotNull GradleDslElement holder, @NotNull PropertyType propertyType, @NotNull String name, @NotNull Map<T, PropertyTransform> transformMap) {
        super(holder, propertyType, name);
        this.myTransforms = new LinkedHashMap<T, PropertyTransform>(transformMap);
        this.myType = defaultType;
        this.setUpTransforms();
    }

    private void setUpTransforms() {
        if (this.myElement == null) {
            return;
        }
        for (Map.Entry<T, PropertyTransform> e : this.myTransforms.entrySet()) {
            if (!e.getValue().test(this.myElement)) continue;
            this.myType = (Enum)e.getKey();
            break;
        }
    }

    @Override
    @NotNull
    protected PropertyTransform getTransform() {
        PropertyTransform pt = this.myTransforms.get(this.myType);
        if (pt != null) {
            return pt;
        }
        return super.getTransform();
    }

    @Override
    @NotNull
    public T getType() {
        return this.myType;
    }

    @Override
    public void setValue(@NotNull T type, @NotNull Object value2) {
        this.setTypeAndValue(type, value2);
    }

    @Override
    public void setType(@NotNull T type) {
        this.setTypeAndValue(type, null);
    }

    protected void setTypeAndValue(@NotNull T type, @Nullable Object value2) {
        Object newValue = value2;
        if (newValue == null) {
            GradlePropertyModel.ValueType oldValueType = this.getValueType();
            if (oldValueType == GradlePropertyModel.ValueType.MAP || oldValueType == GradlePropertyModel.ValueType.LIST) {
                throw new UnsupportedOperationException("Can't convert " + (Object)((Object)oldValueType) + " property to new type " + type);
            }
            GradleDslElement element = this.getElement();
            assert (element instanceof GradleDslSimpleExpression);
            newValue = ((GradleDslSimpleExpression)element).getRawValue();
        }
        this.myType = type;
        if (newValue != null) {
            super.setValue(newValue);
        }
    }
}

