/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.DefaultTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryClosureTransform
extends DefaultTransform {
    @NotNull
    private GradleDslElement myParent;
    @NotNull
    private String myElementName;
    @NotNull
    private String myDefaultValue;

    public RepositoryClosureTransform(@NotNull GradleDslElement parent, @NotNull String elementName, @NotNull String defaultValue) {
        this.myParent = parent;
        this.myElementName = elementName;
        this.myDefaultValue = defaultValue;
    }

    @Override
    public boolean test(@Nullable GradleDslElement e) {
        return e != null;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        assert (e != null);
        GradleDslElement element = null;
        if (e.getClosureElement() != null) {
            element = e.getClosureElement().getElement(this.myElementName);
        } else if (PropertyUtil.isPropertiesElementOrMap(e)) {
            element = ((GradlePropertiesDslElement)e).getElement(this.myElementName);
        }
        if (element != null) {
            return element;
        }
        return new GradleDslGlobalValue(this.myParent, this.myDefaultValue, this.myElementName);
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name) {
        GradleDslElement transformedElement = this.transform(oldElement);
        if (transformedElement instanceof GradleDslGlobalValue) {
            return super.bind(holder, null, value2, this.myElementName);
        }
        return super.bind(holder, transformedElement, value2, this.myElementName);
    }

    @Override
    @NotNull
    public GradleDslElement replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name) {
        GradleDslElement existingElement;
        GradlePropertiesDslElement parent;
        assert (oldElement != null);
        if (PropertyUtil.isPropertiesElementOrMap(oldElement)) {
            parent = (GradlePropertiesDslElement)oldElement;
            existingElement = parent.getElement(this.myElementName);
        } else if (oldElement.getClosureElement() == null) {
            parent = new GradleDslClosure(holder, null, GradleNameElement.empty());
            oldElement.setNewClosureElement((GradleDslClosure)parent);
            existingElement = null;
        } else {
            parent = oldElement.getClosureElement();
            existingElement = parent.getElement(this.myElementName);
        }
        super.replace(parent, existingElement, newElement, this.myElementName);
        return oldElement;
    }
}

