/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.pixelprobe.util.Strings;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleArgumentMethodTransform
extends PropertyTransform {
    @NotNull
    private final Set<String> myRecognizedNames = new HashSet();
    @NotNull
    private final String myWriteBackName;

    public SingleArgumentMethodTransform(@NotNull String methodName) {
        this.myRecognizedNames.add(methodName);
        this.myWriteBackName = methodName;
    }

    public SingleArgumentMethodTransform(@NotNull String methodName, String ... methodNames) {
        this.myRecognizedNames.addAll(Arrays.asList(methodNames));
        this.myRecognizedNames.add(methodName);
        this.myWriteBackName = methodName;
    }

    public SingleArgumentMethodTransform(@NotNull String methodName, @NotNull GradleDslElement object) {
        this.myWriteBackName = methodName;
        ArrayList splitName = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)object.getQualifiedName()));
        splitName.add(methodName);
        for (int i2 = 0; i2 < splitName.size(); ++i2) {
            this.myRecognizedNames.add(Strings.join(splitName.subList(i2, splitName.size()), (String)"."));
        }
    }

    @Override
    public boolean test(@Nullable GradleDslElement e) {
        if (e == null) {
            return true;
        }
        if (e instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)e;
            return this.myRecognizedNames.contains(methodCall.getMethodName()) && !methodCall.getArguments().isEmpty();
        }
        return false;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        GradleDslMethodCall methodCall = (GradleDslMethodCall)e;
        return methodCall.getArguments().get(0);
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name) {
        return PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.empty());
    }

    @Override
    @NotNull
    public GradleDslExpression replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name) {
        GradleDslMethodCall methodCall;
        if (oldElement instanceof GradleDslMethodCall && this.myRecognizedNames.contains((methodCall = (GradleDslMethodCall)oldElement).getMethodName())) {
            GradleDslElement baseElement = this.transform(oldElement);
            PropertyUtil.replaceElement(methodCall, baseElement, newElement);
            return methodCall;
        }
        GradleNameElement nameElement = GradleNameElement.create(name);
        methodCall = new GradleDslMethodCall(holder, nameElement, this.myWriteBackName);
        methodCall.addNewArgument(newElement);
        PropertyUtil.replaceElement(holder, oldElement, methodCall);
        return methodCall;
    }

    @Override
    @Nullable
    public GradleDslElement delete(@NotNull GradleDslElement holder, @NotNull GradleDslElement oldElement, @NotNull GradleDslElement transformedElement) {
        PropertyUtil.removeElement(oldElement);
        return null;
    }
}

