/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.GoogleDefaultRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesModelImpl
extends GradleDslBlockModel
implements RepositoriesModel {
    public RepositoriesModelImpl(@NotNull RepositoriesDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public List<RepositoryModel> repositories() {
        ArrayList result2 = Lists.newArrayList();
        for (GradleDslElement element : this.myDslElement.getAllPropertyElements()) {
            if (element instanceof GradleDslMethodCall) {
                String methodName = ((GradleDslMethodCall)element).getMethodName();
                if ("mavenCentral".equals(methodName)) {
                    result2.add(new MavenCentralRepositoryModel(this.myDslElement, element));
                    continue;
                }
                if ("jcenter".equals(methodName)) {
                    result2.add(new JCenterDefaultRepositoryModel(this.myDslElement, element));
                    continue;
                }
                if (!"google".equals(methodName)) continue;
                result2.add(new GoogleDefaultRepositoryModelImpl(this.myDslElement, element));
                continue;
            }
            if (element instanceof MavenRepositoryDslElement) {
                if ("maven".equals(element.getName())) {
                    result2.add(new MavenRepositoryModelImpl(this.myDslElement, (MavenRepositoryDslElement)element));
                    continue;
                }
                if (!"jcenter".equals(element.getName())) continue;
                result2.add(new JCenterRepositoryModel(this.myDslElement, (MavenRepositoryDslElement)element));
                continue;
            }
            if (element instanceof FlatDirRepositoryDslElement) {
                result2.add(new FlatDirRepositoryModel(this.myDslElement, (FlatDirRepositoryDslElement)element));
                continue;
            }
            if (!(element instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element.getName())) {
                result2.add(new MavenCentralRepositoryModel(this.myDslElement, element));
                continue;
            }
            if (!"flatDir".equals(element.getName())) continue;
            result2.add(new FlatDirRepositoryModel(this.myDslElement, (GradlePropertiesDslElement)element));
        }
        return result2;
    }

    @Override
    public void addRepositoryByMethodName(@NotNull String methodName) {
        if (this.containsMethodCall(methodName)) {
            return;
        }
        this.myDslElement.setNewElement(new GradleDslMethodCall((GradleDslElement)this.myDslElement, GradleNameElement.empty(), methodName));
    }

    @Override
    public void addFlatDirRepository(@NotNull String dirName) {
        List<FlatDirRepositoryDslElement> flatDirElements = this.myDslElement.getPropertyElements(FlatDirRepositoryDslElement.class);
        if (!flatDirElements.isEmpty()) {
            new FlatDirRepositoryModel(this.myDslElement, flatDirElements.get(0)).dirs().addListValue().setValue(dirName);
        } else {
            FlatDirRepositoryDslElement gradleDslElement = new FlatDirRepositoryDslElement(this.myDslElement);
            this.myDslElement.setNewElement(gradleDslElement);
            new FlatDirRepositoryModel(this.myDslElement, gradleDslElement).dirs().addListValue().setValue(dirName);
        }
    }

    @Override
    public boolean containsMethodCall(@NotNull String methodName) {
        List<GradleDslMethodCall> elements = this.myDslElement.getPropertyElements(GradleDslMethodCall.class);
        for (GradleDslMethodCall element : elements) {
            if (!methodName.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMavenRepositoryByUrl(@NotNull String url, @NotNull String name) {
        if (this.containsMavenRepositoryByUrl(url)) {
            return;
        }
        GradleNameElement nameElement = GradleNameElement.create("maven");
        MavenRepositoryDslElement newElement = new MavenRepositoryDslElement(this.myDslElement, nameElement);
        newElement.setNewLiteral("url", url);
        newElement.setNewLiteral("name", name);
        this.myDslElement.setNewElement(newElement);
    }

    @Override
    public boolean containsMavenRepositoryByUrl(@NotNull String repositoryUrl) {
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            String urlElement = element.getLiteral("url", String.class);
            if (!repositoryUrl.equals(urlElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGoogleMavenRepository() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        if (this.containsMethodCall("google")) {
            return true;
        }
        return this.containsMavenRepositoryByUrl("https://maven.google.com/");
    }

    @Override
    public void addGoogleMavenRepository(@NotNull Project project) {
        if (GradleVersions.getInstance().isGradle4OrNewer(project)) {
            this.addRepositoryByMethodName("google");
        } else {
            this.addMavenRepositoryByUrl("https://maven.google.com/", "Google");
        }
    }

    @Override
    public void addGoogleMavenRepository(@NotNull GradleVersion gradleVersion2) {
        if (gradleVersion2.compareIgnoringQualifiers("4.0") >= 0) {
            this.addRepositoryByMethodName("google");
        } else {
            this.addMavenRepositoryByUrl("https://maven.google.com/", "Google");
        }
    }
}

