/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.DependencyManager;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFileCache;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildModelContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslFileCache myFileCache;
    @NotNull
    private final Map<GradleDslFile, ClassToInstanceMap<BuildModelNotification>> myNotifications = new HashMap<GradleDslFile, ClassToInstanceMap<BuildModelNotification>>();
    @NotNull
    private final DependencyManager myDependencyManager;
    @Nullable
    private GradleDslFile myRootProjectFile;

    public void setRootProjectFile(@NotNull GradleDslFile rootProjectFile) {
        this.myRootProjectFile = rootProjectFile;
    }

    @Nullable
    public GradleDslFile getRootProjectFile() {
        return this.myRootProjectFile;
    }

    @NotNull
    public static BuildModelContext create(@NotNull Project project) {
        return new BuildModelContext(project);
    }

    private BuildModelContext(@NotNull Project project) {
        this.myProject = project;
        this.myFileCache = new GradleDslFileCache(project);
        this.myDependencyManager = DependencyManager.create();
        this.myRootProjectFile = null;
    }

    @NotNull
    public DependencyManager getDependencyManager() {
        return this.myDependencyManager;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications(@NotNull GradleDslFile file) {
        return new ArrayList<BuildModelNotification>(this.myNotifications.getOrDefault(file, (ClassToInstanceMap<BuildModelNotification>)MutableClassToInstanceMap.create()).values());
    }

    @NotNull
    public <T extends BuildModelNotification> T getNotificationForType(@NotNull GradleDslFile file, @NotNull NotificationTypeReference<T> type) {
        ClassToInstanceMap notificationMap = this.myNotifications.computeIfAbsent(file, f -> MutableClassToInstanceMap.create());
        if (notificationMap.containsKey(type.getClazz())) {
            return (T)((BuildModelNotification)notificationMap.getInstance(type.getClazz()));
        }
        BuildModelNotification notification = (BuildModelNotification)type.getConstructor().produce();
        notificationMap.putInstance(type.getClazz(), (Object)notification);
        return (T)notification;
    }

    public void reset() {
        this.myFileCache.clearAllFiles();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name, boolean isApplied) {
        return this.myFileCache.getOrCreateBuildFile(file, name, this, isApplied);
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, boolean isApplied) {
        return this.getOrCreateBuildFile(file, file.getName(), isApplied);
    }

    @Nullable
    public GradleSettingsFile getSettingsFile(@NotNull Project project) {
        return this.myFileCache.getSettingsFile(project);
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile) {
        return this.myFileCache.getOrCreateSettingsFile(settingsFile, this);
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName) {
        return this.myFileCache.getOrCreatePropertiesFile(file, moduleName, this);
    }

    public void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        this.myFileCache.putBuildFile(name, buildFile);
    }

    @NotNull
    public List<GradleDslFile> getAllRequestedFiles() {
        return this.myFileCache.getAllFiles();
    }
}

