/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DependencyManager {
    @NotNull
    private final List<GradleReferenceInjection> myUnresolvedReferences = new ArrayList<GradleReferenceInjection>();

    public static DependencyManager create() {
        return new DependencyManager();
    }

    private DependencyManager() {
    }

    public void registerUnresolvedReference(@NotNull GradleReferenceInjection injection) {
        assert (!injection.isResolved());
        this.myUnresolvedReferences.add(injection);
    }

    public void unregisterUnresolvedReference(@NotNull GradleReferenceInjection injection) {
        assert (!injection.isResolved());
        this.myUnresolvedReferences.remove(injection);
    }

    public void resolveWith(@NotNull GradleDslElement element) {
        this.resolveAll();
    }

    public void resolveAll() {
        Iterator<GradleReferenceInjection> it = this.myUnresolvedReferences.iterator();
        while (it.hasNext()) {
            GradleReferenceInjection injection = it.next();
            GradleDslElement newElement = injection.getOriginElement().resolveReference(injection.getName(), true);
            if (newElement == null) continue;
            injection.resolveWith(newElement);
            newElement.registerDependent(injection);
            it.remove();
        }
    }
}

