/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.apply;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyDslElement
extends GradlePropertiesDslElement {
    @NonNls
    public static final String APPLY_BLOCK_NAME = "apply";
    @NonNls
    private static final String FROM = "from";
    @NotNull
    private final List<GradleDslFile> myAppliedDslFiles = new ArrayList<GradleDslFile>();

    public ApplyDslElement(@NotNull GradleDslElement parent) {
        super(parent, null, GradleNameElement.create(APPLY_BLOCK_NAME));
        parent.getDslFile().registerApplyElement(this);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element) {
        File realFile;
        VirtualFile file;
        String fileName;
        GradleDslSimpleExpression from = ApplyDslElement.extractFrom(element);
        if (from != null && (fileName = ApplyDslElement.attemptToExtractFileName(from)) != null && (file = (realFile = new File(fileName)).exists() && realFile.isAbsolute() ? LocalFileSystem.getInstance().findFileByIoFile(realFile) : VirtualFileManager.getInstance().findFileByUrl(this.getDslFile().getFile().getParent() + "/" + fileName)) != null) {
            GradleBuildFile dslFile = this.getDslFile().getContext().getOrCreateBuildFile(file, true);
            this.myAppliedDslFiles.add(dslFile);
            if (this.myParent instanceof GradlePropertiesDslElement) {
                ((GradlePropertiesDslElement)this.myParent).addAppliedModelProperties(dslFile);
            }
        }
        super.addParsedElement(element);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myParent == null ? null : this.myParent.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myParent == null ? null : this.myParent.create();
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
    }

    @NotNull
    public List<GradleDslFile> getAppliedDslFiles() {
        return this.myAppliedDslFiles;
    }

    @Nullable
    private static String attemptToExtractFileName(@NotNull GradleDslSimpleExpression element) {
        return element.getValue(String.class);
    }

    @Nullable
    private static GradleDslSimpleExpression extractFrom(@NotNull GradleDslElement element) {
        if (element instanceof GradleDslExpressionMap) {
            return ((GradleDslExpressionMap)element).getPropertyElement(FROM, GradleDslSimpleExpression.class);
        }
        return null;
    }
}

