/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.ModificationAware;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslElementImpl
implements GradleDslElement,
ModificationAware {
    @NotNull
    protected GradleNameElement myName;
    @Nullable
    protected GradleDslElement myParent;
    @NotNull
    protected List<GradlePropertiesDslElement> myHolders = new ArrayList<GradlePropertiesDslElement>();
    @NotNull
    private final GradleDslFile myDslFile;
    @Nullable
    private PsiElement myPsiElement;
    @Nullable
    private GradleDslClosure myClosureElement;
    @Nullable
    private GradleDslClosure myUnsavedClosure;
    private long myLastCommittedModificationCount;
    private long myModificationCount;
    protected boolean myUseAssignment;
    @NotNull
    private PropertyType myElementType;
    @NotNull
    protected final List<GradleReferenceInjection> myDependencies = new ArrayList<GradleReferenceInjection>();
    @NotNull
    protected final List<GradleReferenceInjection> myDependents = new ArrayList<GradleReferenceInjection>();

    protected GradleDslElementImpl(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        assert (parent != null || this instanceof GradleDslFile);
        this.myParent = parent;
        this.myPsiElement = psiElement;
        this.myName = name;
        this.myDslFile = parent == null ? (GradleDslFile)this : parent.getDslFile();
        this.myUseAssignment = false;
        this.myElementType = PropertyType.DERIVED;
    }

    @Override
    public void setParsedClosureElement(@NotNull GradleDslClosure closureElement) {
        this.myClosureElement = closureElement;
    }

    @Override
    public void setNewClosureElement(@Nullable GradleDslClosure closureElement) {
        this.myUnsavedClosure = closureElement;
        this.setModified();
    }

    @Override
    @Nullable
    public GradleDslClosure getUnsavedClosure() {
        return this.myUnsavedClosure;
    }

    @Override
    @Nullable
    public GradleDslClosure getClosureElement() {
        return this.myUnsavedClosure == null ? this.myClosureElement : this.myUnsavedClosure;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName.name();
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.myParent == null || this.myParent instanceof GradleDslFile) {
            return this.getName();
        }
        String ourName = this.getName();
        return this.myParent.getQualifiedName() + (ourName.isEmpty() ? "" : "." + this.getName());
    }

    @Override
    @NotNull
    public String getFullName() {
        return this.myName.fullName();
    }

    @Override
    @NotNull
    public GradleNameElement getNameElement() {
        return this.myName;
    }

    @Override
    public void rename(@NotNull String newName2) {
        this.myName.rename(newName2);
        this.setModified();
        if (!(this instanceof GradleDslSimpleExpression)) {
            return;
        }
        List<GradleReferenceInjection> dependents = this.getDependents();
        this.unregisterAllDependants();
        this.reorder();
        dependents.forEach(e -> e.getOriginElement().resolve());
        this.getDslFile().getContext().getDependencyManager().resolveWith(this);
    }

    @Override
    @Nullable
    public GradleDslElement getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(@NotNull GradleDslElement parent) {
        this.myParent = parent;
    }

    @Override
    @NotNull
    public List<GradlePropertiesDslElement> getHolders() {
        return this.myHolders;
    }

    @Override
    public void addHolder(@NotNull GradlePropertiesDslElement holder) {
        this.myHolders.add(holder);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @Override
    public boolean shouldUseAssignment() {
        return this.myUseAssignment;
    }

    @Override
    public void setUseAssignment(boolean useAssignment) {
        this.myUseAssignment = useAssignment;
    }

    @Override
    @NotNull
    public PropertyType getElementType() {
        return this.myElementType;
    }

    @Override
    public void setElementType(@NotNull PropertyType propertyType) {
        this.myElementType = propertyType;
    }

    @Override
    @NotNull
    public GradleDslFile getDslFile() {
        return this.myDslFile;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (GradleDslElement child : this.getChildren()) {
            resultBuilder.addAll(child.getResolvedVariables());
        }
        return resultBuilder.build();
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element) {
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement getAnchor() {
        return this.myParent == null ? null : this.myParent.requestAnchor(this);
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myDslFile.getWriter().createDslElement(this);
    }

    @Override
    @Nullable
    public PsiElement move() {
        return this.myDslFile.getWriter().moveDslElement(this);
    }

    @Override
    public void delete() {
        for (GradleDslElement element : this.getChildren()) {
            element.delete();
        }
        this.getDslFile().getWriter().deleteDslElement(this);
    }

    @Override
    public void setModified() {
        this.modify();
        if (this.myParent != null) {
            this.myParent.setModified();
        }
    }

    @Override
    public boolean isModified() {
        return this.getLastCommittedModificationCount() != this.getModificationCount();
    }

    @Override
    public boolean isBlockElement() {
        return false;
    }

    @Override
    public boolean isInsignificantIfEmpty() {
        return true;
    }

    @Override
    @NotNull
    public abstract Collection<GradleDslElement> getChildren();

    @Override
    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.commit();
    }

    protected abstract void apply();

    @Override
    public final void resetState() {
        this.reset();
        this.commit();
    }

    protected abstract void reset();

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getInScopeElements() {
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        if (PropertyUtil.isNonExpressionPropertiesElement(this)) {
            GradlePropertiesDslElement thisElement = (GradlePropertiesDslElement)this;
            results.putAll(thisElement.getVariableElements());
        }
        GradleDslElement currentElement = this;
        while (currentElement != null && currentElement.getParent() != null) {
            if (!PropertyUtil.isNonExpressionPropertiesElement(currentElement = currentElement.getParent())) continue;
            GradlePropertiesDslElement element = (GradlePropertiesDslElement)currentElement;
            results.putAll(element.getVariableElements());
        }
        if (currentElement instanceof GradleDslFile) {
            for (GradleDslFile file = (GradleDslFile)currentElement; file != null; file = file.getParentModuleDslFile()) {
                ExtDslElement buildScriptExt;
                BuildScriptDslElement buildScriptElement;
                ExtDslElement ext = file.getPropertyElement("ext", ExtDslElement.class);
                if (ext != null) {
                    results.putAll(ext.getPropertyElements());
                }
                if ((buildScriptElement = file.getPropertyElement("buildscript", BuildScriptDslElement.class)) == null || (buildScriptExt = buildScriptElement.getPropertyElement("ext", ExtDslElement.class)) == null) continue;
                results.putAll(buildScriptExt.getPropertyElements());
            }
        }
        return results;
    }

    @Override
    @NotNull
    public <T extends BuildModelNotification> T notification(@NotNull NotificationTypeReference<T> type) {
        return this.getDslFile().getContext().getNotificationForType(this.myDslFile, type);
    }

    @Override
    public void registerDependent(@NotNull GradleReferenceInjection injection) {
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        this.myDependents.add(injection);
    }

    @Override
    public void unregisterDependent(@NotNull GradleReferenceInjection injection) {
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        assert (this.myDependents.contains(injection));
        this.myDependents.remove(injection);
    }

    @Override
    public void unregisterAllDependants() {
        this.myDependents.forEach(e -> {
            e.resolveWith(null);
            this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e);
        });
        this.myDependents.clear();
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependents() {
        return new ArrayList<GradleReferenceInjection>(this.myDependents);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return new ArrayList<GradleReferenceInjection>(this.myDependencies);
    }

    @Override
    public void updateDependenciesOnAddElement(@NotNull GradleDslElement newElement) {
        newElement.resolve();
        newElement.getDslFile().getContext().getDependencyManager().resolveWith(newElement);
    }

    @Override
    public void updateDependenciesOnReplaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        List<GradleReferenceInjection> injections = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        injections.forEach(e -> e.resolveWith(newElement));
        injections.forEach(newElement::registerDependent);
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void updateDependenciesOnRemoveElement(@NotNull GradleDslElement oldElement) {
        List<GradleReferenceInjection> dependents = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        dependents.forEach(e -> e.getOriginElement().resolve());
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void resolve() {
    }

    protected void reorder() {
        if (this.myParent instanceof ExtDslElement) {
            ((ExtDslElement)this.myParent).reorderAndMaybeGetNewIndex(this);
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount;
    }

    public long getLastCommittedModificationCount() {
        return this.myLastCommittedModificationCount;
    }

    @Override
    public void modify() {
        ++this.myModificationCount;
        this.myDependents.forEach(e -> e.getOriginElement().modify());
    }

    public void commit() {
        this.myLastCommittedModificationCount = this.myModificationCount;
    }

    @Nullable
    public static String getPsiText(@NotNull PsiElement psiElement) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> psiElement.getText());
    }
}

