/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslExpressionList
extends GradlePropertiesDslElement
implements GradleDslExpression {
    private final boolean myAppendToArgumentListWithOneElement;
    private boolean myShouldBeDeleted;
    private boolean myIsLiteralList;

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull GradleNameElement name, boolean isLiteralList) {
        super(parent, null, name);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, boolean isLiteralList, @NotNull GradleNameElement name) {
        super(parent, psiElement, name);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull GradleNameElement name, boolean appendToArgumentListWithOneElement) {
        super(parent, psiElement, name);
        this.myAppendToArgumentListWithOneElement = appendToArgumentListWithOneElement;
        this.myIsLiteralList = false;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        super.addParsedElement(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression) {
        this.setNewElement(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression, int index) {
        this.addNewElementAt(index, expression);
    }

    public void removeElement(@NotNull GradleDslElement element) {
        super.removeProperty(element);
    }

    public GradleDslExpression getElementAt(int index) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index < 0 || index > expressions.size()) {
            return null;
        }
        return expressions.get(index);
    }

    public int findIndexOf(@NotNull GradleDslElement element) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        for (int i2 = 0; i2 < expressions.size(); ++i2) {
            if (!expressions.get(i2).equals(element)) continue;
            return i2;
        }
        return -1;
    }

    void addNewLiteral(@NotNull Object value2) {
        GradleDslLiteral literal = new GradleDslLiteral(this, this.myName);
        literal.setValue(value2);
        this.addNewExpression(literal);
    }

    void removeExpression(@NotNull Object value2) {
        for (GradleDslSimpleExpression expression : this.getSimpleExpressions()) {
            if (!value2.equals(expression.getValue())) continue;
            super.removeProperty(expression);
            this.updateDependenciesOnRemoveElement(expression);
            return;
        }
    }

    void replaceExpression(@NotNull Object oldValue, @NotNull Object newValue) {
        for (GradleDslSimpleExpression expression : this.getSimpleExpressions()) {
            if (!oldValue.equals(expression.getValue())) continue;
            expression.setValue(newValue);
            return;
        }
    }

    public void replaceExpression(@NotNull GradleDslExpression oldExpression, @NotNull GradleDslExpression newExpression) {
        super.replaceElement(oldExpression, newExpression);
    }

    @NotNull
    public List<GradleDslExpression> getExpressions() {
        return this.getPropertyElements(GradleDslExpression.class);
    }

    @NotNull
    public List<GradleDslSimpleExpression> getSimpleExpressions() {
        return this.getExpressions().stream().filter(e -> e instanceof GradleDslSimpleExpression).map(e -> (GradleDslSimpleExpression)e).collect(Collectors.toList());
    }

    @NotNull
    public <T> List<T> getLiterals(@NotNull Class<T> clazz) {
        return this.getSimpleExpressions().stream().map(e -> e.getValue(clazz)).filter(e -> e != null).collect(Collectors.toList());
    }

    public boolean isLiteralList() {
        return this.myIsLiteralList;
    }

    public boolean isAppendToArgumentListWithOneElement() {
        return this.myAppendToArgumentListWithOneElement;
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslExpressionList(this);
    }

    @Override
    public void delete() {
        this.myShouldBeDeleted = true;
        super.delete();
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslExpressionList(this);
        super.apply();
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.getPsiElement();
    }

    public boolean shouldBeDeleted() {
        return !this.isLiteralList() || this.myShouldBeDeleted;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        return this.getDependencies().stream().filter(e -> e.isResolved()).collect(Collectors.toList());
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element) {
        assert (element instanceof GradleDslExpression);
        super.setParsedElement(element);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element) {
        assert (element instanceof GradleDslExpression);
        super.addParsedElement(element);
    }

    @Override
    protected void addParsedResettingElement(@NotNull GradleDslElement element, @NotNull String propertyToReset) {
        assert (element instanceof GradleDslExpression);
        super.addParsedResettingElement(element, propertyToReset);
    }

    @Override
    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element) {
        assert (element instanceof GradleDslExpression);
        super.addToParsedExpressionList(property2, element);
    }

    @Override
    @NotNull
    public GradleDslElement setNewElement(@NotNull GradleDslElement newElement) {
        assert (newElement instanceof GradleDslExpression);
        return super.setNewElement(newElement);
    }

    @Override
    public void addNewElementAt(int index, @NotNull GradleDslElement newElement) {
        assert (newElement instanceof GradleDslExpression);
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index > expressions.size()) {
            throw new IndexOutOfBoundsException(index + " is out of bounds for size " + expressions.size());
        }
        super.addNewElementAt(index, newElement);
    }

    @Override
    @NotNull
    public GradleDslElement replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        assert (newElement instanceof GradleDslExpression && oldElement instanceof GradleDslExpression);
        return super.replaceElement(oldElement, newElement);
    }

    @Override
    @NotNull
    public GradleDslExpressionList copy() {
        GradleDslExpressionList listClone = new GradleDslExpressionList(this.myParent, GradleNameElement.copy(this.myName), false);
        for (GradleDslElement element : this.getCurrentElements()) {
            GradleDslExpression sourceExpression = (GradleDslExpression)element;
            GradleDslExpression copiedExpression = sourceExpression.copy();
            listClone.setNewElement(copiedExpression);
        }
        return listClone;
    }
}

