/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslLiteral
extends GradleDslSettableExpression {
    public GradleDslLiteral(@NotNull GradleDslElement parent, @NotNull GradleNameElement name) {
        super(parent, null, name, null);
        this.myIsReference = false;
    }

    public GradleDslLiteral(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull GradleNameElement name, @NotNull PsiElement literal, boolean isReference) {
        super(parent, psiElement, name, literal);
        this.myIsReference = isReference;
    }

    @Override
    @Nullable
    public Object produceValue() {
        PsiElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().extractValue(this, element, true));
    }

    @Override
    @Nullable
    public Object produceUnresolvedValue() {
        PsiElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().extractValue(this, element, false));
    }

    @Override
    public void setValue(@NotNull Object value2) {
        this.checkForValidValue(value2);
        PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement psiElement = this.getDslFile().getParser().convertToPsiElement(value2);
            this.getDslFile().getParser().setUpForNewValue(this, psiElement);
            return psiElement;
        });
        this.setUnsavedValue(element);
        this.valueChanged();
    }

    @Override
    @Nullable
    public Object produceRawValue() {
        PsiElement currentElement = this.getCurrentElement();
        if (currentElement == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            boolean shouldInterpolate = this.getDslFile().getParser().shouldInterpolate(this);
            Object val = this.getDslFile().getParser().extractValue(this, currentElement, false);
            if (val instanceof String && shouldInterpolate) {
                return GradlePropertyModel.iStr((String)val);
            }
            return val;
        });
    }

    @Override
    @NotNull
    public GradleDslLiteral copy() {
        assert (this.myParent != null);
        GradleDslLiteral literal = new GradleDslLiteral(this.myParent, GradleNameElement.copy(this.myName));
        Object v = this.getRawValue();
        if (v != null) {
            literal.setValue(this.isReference() ? new ReferenceTo((String)v) : v);
        }
        return literal;
    }

    public String toString() {
        Object value2 = this.getValue();
        return value2 != null ? value2.toString() : super.toString();
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslLiteral(this);
    }

    @Override
    public void delete() {
        this.getDslFile().getWriter().deleteDslLiteral(this);
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslLiteral(this);
    }

    @Nullable
    public GradleReferenceInjection getReferenceInjection() {
        return this.myDependencies.isEmpty() ? null : (GradleReferenceInjection)this.myDependencies.get(0);
    }

    @Override
    @Nullable
    public String getReferenceText() {
        if (!this.myIsReference) {
            return null;
        }
        PsiElement element = this.getCurrentElement();
        return element != null ? GradleDslLiteral.getPsiText(element) : null;
    }

    @Override
    public void reset() {
        super.reset();
        ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().setUpForNewValue(this, this.getCurrentElement()));
    }
}

