/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.model.CachedValue;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslSimpleExpression
extends GradleDslElementImpl
implements GradleDslExpression {
    @NotNull
    private static final String SINGLE_QUOTES = "'";
    @NotNull
    private static final String DOUBLE_QUOTES = "\"";
    protected boolean myIsReference;
    @Nullable
    private PsiElement myUnsavedConfigBlock;
    @Nullable
    protected PsiElement myExpression;
    @Nullable
    protected ThreeState myHasCycle;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myResolvedCachedValue;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myUnresolvedCachedValue;
    @NotNull
    private final CachedValue<GradleDslSimpleExpression> myRawCachedValue;

    protected GradleDslSimpleExpression(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name, @Nullable PsiElement expression) {
        super(parent, psiElement, name);
        this.myExpression = expression;
        this.myHasCycle = ThreeState.UNSURE;
        this.resolve();
        this.myResolvedCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceValue);
        this.myUnresolvedCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceUnresolvedValue);
        this.myRawCachedValue = new CachedValue<GradleDslSimpleExpression>(this, GradleDslSimpleExpression::produceRawValue);
    }

    @Nullable
    public PsiElement getUnsavedConfigBlock() {
        return this.myUnsavedConfigBlock;
    }

    public void setUnsavedConfigBlock(@Nullable PsiElement configBlock) {
        this.myUnsavedConfigBlock = configBlock;
    }

    public void setConfigBlock(@NotNull PsiElement block) {
        Preconditions.checkState((this.getPsiElement() == null ? 1 : 0) != 0, (Object)"Can't add configuration block to an existing DSL literal.");
        this.myUnsavedConfigBlock = block;
        this.setModified();
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.myExpression;
    }

    public void setExpression(@NotNull PsiElement expression) {
        this.myExpression = expression;
    }

    @Nullable
    public final Object getValue() {
        return this.myResolvedCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceValue();

    @Nullable
    public final Object getUnresolvedValue() {
        return this.myUnresolvedCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceUnresolvedValue();

    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        Object value2 = this.getValue();
        if (value2 != null && clazz.isAssignableFrom(value2.getClass())) {
            return clazz.cast(value2);
        }
        return null;
    }

    @Nullable
    public <T> T getUnresolvedValue(@NotNull Class<T> clazz) {
        Object value2 = this.getUnresolvedValue();
        if (value2 != null && clazz.isAssignableFrom(value2.getClass())) {
            return clazz.cast(value2);
        }
        return null;
    }

    public abstract void setValue(@NotNull Object var1);

    @Nullable
    public final Object getRawValue() {
        return this.myRawCachedValue.getValue();
    }

    @Nullable
    protected abstract Object produceRawValue();

    @Override
    @NotNull
    public abstract GradleDslSimpleExpression copy();

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        return this.myDependencies.stream().filter(e -> e.isResolved()).collect(Collectors.toList());
    }

    public boolean isReference() {
        return this.myIsReference;
    }

    public void setReference(boolean isReference) {
        this.myIsReference = isReference;
    }

    @Nullable
    public String getReferenceText() {
        return null;
    }

    @Override
    protected void reset() {
        this.myRawCachedValue.clear();
        this.myUnresolvedCachedValue.clear();
        this.myResolvedCachedValue.clear();
    }

    @Nullable
    public GradleDslElement resolveReference(@NotNull String referenceText, boolean resolveWithOrder) {
        String fullTextReference;
        GradleDslElement resolvedElement;
        GradleDslFile dslFile;
        int index;
        GradleDslElementImpl searchStartElement = this;
        List<String> referenceTextSegments = Splitter.on((char)'.').trimResults().omitEmptyStrings().splitToList((CharSequence)referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index = 0; index < segmentCount && (dslFile = GradleDslSimpleExpression.resolveProjectReference(searchStartElement, (String)referenceTextSegments.get(index))) != null; ++index) {
            searchStartElement = dslFile;
        }
        if (index >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            referenceTextSegments = referenceTextSegments.subList(index, segmentCount);
            resolvedElement = GradleDslSimpleExpression.resolveReferenceInSameModule(searchStartElement, referenceTextSegments, resolveWithOrder);
        }
        GradleDslFile dslFile2 = searchStartElement.getDslFile();
        if (resolvedElement == null) {
            resolvedElement = GradleDslSimpleExpression.resolveReferenceInParentModules(dslFile2, referenceTextSegments);
        }
        if ("rootDir".equals(fullTextReference = String.join((CharSequence)".", referenceTextSegments))) {
            return new GradleDslGlobalValue(dslFile2, Projects.getBaseDirPath((Project)dslFile2.getProject()).getPath());
        }
        if ("projectDir".equals(fullTextReference)) {
            return new GradleDslGlobalValue(dslFile2, dslFile2.getDirectoryPath().getPath());
        }
        return resolvedElement;
    }

    @Nullable
    private static GradleDslFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if ("project".equals(projectReference)) {
            return dslFile;
        }
        if ("parent".equals(projectReference)) {
            return dslFile.getParentModuleDslFile();
        }
        if ("rootProject".equals(projectReference)) {
            for (dslFile = startElement.getDslFile(); dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir())); dslFile = dslFile.getParentModuleDslFile()) {
            }
            return dslFile;
        }
        String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
        if (standardProjectKey != null) {
            String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
            VirtualFile settingFile = dslFile.tryToFindSettingsFile();
            if (settingFile == null) {
                return null;
            }
            GradleSettingsFile file = dslFile.getContext().getOrCreateSettingsFile(settingFile);
            GradleSettingsModelImpl model2 = new GradleSettingsModelImpl(file);
            File moduleDirectory = model2.moduleDirectory(modulePath);
            if (moduleDirectory == null) {
                return null;
            }
            while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                dslFile = dslFile.getParentModuleDslFile();
            }
            if (dslFile == null) {
                return null;
            }
            return GradleDslSimpleExpression.findDslFile(dslFile, moduleDirectory);
        }
        return null;
    }

    @NotNull
    private static String stripQuotes(@NotNull String index) {
        if (index.startsWith(SINGLE_QUOTES) && index.endsWith(SINGLE_QUOTES) || index.startsWith(DOUBLE_QUOTES) && index.endsWith(DOUBLE_QUOTES)) {
            return index.substring(1, index.length() - 1);
        }
        return index;
    }

    @Nullable
    private static GradleDslElement extractElementFromProperties(@NotNull GradlePropertiesDslElement properties, @NotNull String name, boolean sameScope, @Nullable GradleDslElement childElement, boolean includeSelf) {
        Matcher indexMatcher = GradleNameElement.INDEX_PATTERN.matcher(name);
        if (!indexMatcher.find()) {
            return sameScope ? properties.getElementBefore(childElement, name, includeSelf) : properties.getPropertyElementBefore(childElement, name, includeSelf);
        }
        if (indexMatcher.groupCount() != 2) {
            return null;
        }
        String elementName = indexMatcher.group(0);
        if (elementName == null) {
            return null;
        }
        GradleDslElement element = sameScope ? properties.getElementBefore(childElement, elementName, includeSelf) : properties.getPropertyElementBefore(childElement, elementName, includeSelf);
        ArrayDeque<String> indexParts = new ArrayDeque<String>();
        while (indexMatcher.find()) {
            if (indexMatcher.groupCount() != 2) {
                return null;
            }
            indexParts.add(indexMatcher.group(1));
        }
        while (!indexParts.isEmpty()) {
            String index = (String)indexParts.pop();
            if (element == null) {
                return null;
            }
            if (element instanceof GradleDslExpressionList) {
                int offset;
                try {
                    offset = Integer.parseInt(index);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                GradleDslExpressionList list = (GradleDslExpressionList)element;
                if (list.getExpressions().size() <= offset) {
                    return null;
                }
                element = list.getExpressions().get(offset);
                continue;
            }
            if (element instanceof GradleDslExpressionMap) {
                GradleDslExpressionMap map2 = (GradleDslExpressionMap)element;
                index = GradleDslSimpleExpression.stripQuotes(index);
                element = map2.getPropertyElement(index);
                continue;
            }
            if (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference()) {
                element = PropertyUtil.followElement((GradleDslLiteral)element);
                indexParts.push(index);
                continue;
            }
            return null;
        }
        return element;
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnPropertiesElement(@NotNull GradlePropertiesDslElement properties, @NotNull List<String> nameParts, @NotNull List<GradleDslElement> trace) {
        int traceIndex = trace.size() - 1;
        for (int i2 = 0; i2 < nameParts.size() - 1; ++i2) {
            GradleDslElement element = GradleDslSimpleExpression.extractElementFromProperties(properties, nameParts.get(i2), i2 == 0, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
            if (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference()) {
                element = PropertyUtil.followElement((GradleDslLiteral)element);
            }
            if (!PropertyUtil.isPropertiesElementOrMap(element)) {
                return null;
            }
            properties = (GradlePropertiesDslElement)element;
        }
        return GradleDslSimpleExpression.extractElementFromProperties(properties, nameParts.get(nameParts.size() - 1), nameParts.size() == 1, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnElement(@NotNull GradleDslElement element, @NotNull List<String> nameParts, boolean resolveWithOrder, boolean checkExt, int ignoreParentNumber) {
        Stack<GradleDslElement> elementTrace = new Stack<GradleDslElement>();
        if (resolveWithOrder) {
            elementTrace.push(element);
        }
        while (ignoreParentNumber-- > 0 && element != null && !(element instanceof GradleDslFile)) {
            element = element.getParent();
        }
        while (element != null) {
            GradleDslElement lastElement;
            GradleDslElement gradleDslElement = lastElement = elementTrace.isEmpty() ? null : (GradleDslElement)elementTrace.peek();
            if (PropertyUtil.isPropertiesElementOrMap(element)) {
                GradleDslElement bsElement;
                GradleDslElement bsDslElement;
                GradleDslElement extPropertyElement;
                GradleDslElement extElement;
                GradleDslElement propertyElement = GradleDslSimpleExpression.resolveReferenceOnPropertiesElement((GradlePropertiesDslElement)element, nameParts, elementTrace);
                if (propertyElement != null) {
                    return propertyElement;
                }
                if (!(lastElement instanceof ExtDslElement) && checkExt && (extElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(lastElement, "ext", false)) instanceof ExtDslElement && (extPropertyElement = GradleDslSimpleExpression.resolveReferenceOnPropertiesElement((ExtDslElement)extElement, nameParts, elementTrace)) != null) {
                    return extPropertyElement;
                }
                if (!(lastElement instanceof BuildScriptDslElement) && (bsDslElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(element, "buildscript", false)) instanceof BuildScriptDslElement && (bsElement = GradleDslSimpleExpression.resolveReferenceOnElement(bsDslElement, nameParts, true, false, -1)) != null) {
                    return bsElement;
                }
            }
            if (resolveWithOrder) {
                elementTrace.push(element);
            }
            if (element instanceof BuildScriptDslElement) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(@NotNull GradleDslElement startElement, @NotNull List<String> referenceText, boolean resolveWithOrder) {
        GradleDslFile parentModuleDslFile;
        GradleDslElement bsElement;
        GradleDslElement element = GradleDslSimpleExpression.resolveReferenceOnElement(startElement, referenceText, resolveWithOrder, true, startElement.getNameElement().fullNameParts().size());
        if (element != null) {
            return element;
        }
        String text = String.join((CharSequence)".", referenceText);
        GradleDslFile dslFile = startElement.getDslFile();
        GradleDslElement propertyElement = GradleDslSimpleExpression.resolveReferenceInPropertiesFile(dslFile, text);
        if (propertyElement != null) {
            return propertyElement;
        }
        BuildScriptDslElement bsDslElement = dslFile.getPropertyElement("buildscript", BuildScriptDslElement.class);
        if (bsDslElement != null && (bsElement = GradleDslSimpleExpression.resolveReferenceOnElement(bsDslElement, referenceText, false, true, -1)) != null) {
            return bsElement;
        }
        if (dslFile.getParentModuleDslFile() == null) {
            return null;
        }
        GradleDslFile rootProjectDslFile = dslFile;
        while ((parentModuleDslFile = rootProjectDslFile.getParentModuleDslFile()) != null) {
            rootProjectDslFile = parentModuleDslFile;
        }
        return GradleDslSimpleExpression.resolveReferenceInPropertiesFile(rootProjectDslFile, text);
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleDslFile dslFile, @NotNull List<String> referenceText) {
        for (GradleDslFile parentDslFile = dslFile.getParentModuleDslFile(); parentDslFile != null; parentDslFile = parentDslFile.getParentModuleDslFile()) {
            GradleDslElement bsElement;
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentDslFile.getPropertyElement("ext", ExtDslElement.class);
            if (extDslElement != null && (extPropertyElement = GradleDslSimpleExpression.resolveReferenceOnPropertiesElement(extDslElement, referenceText, new Stack<GradleDslElement>())) != null) {
                return extPropertyElement;
            }
            BuildScriptDslElement bsDslElement = parentDslFile.getPropertyElement("buildscript", BuildScriptDslElement.class);
            if (bsDslElement != null && (bsElement = GradleDslSimpleExpression.resolveReferenceOnElement(bsDslElement, referenceText, false, true, -1)) != null) {
                return bsElement;
            }
            if (parentDslFile.getParentModuleDslFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslSimpleExpression.resolveReferenceInPropertiesFile(parentDslFile, String.join((CharSequence)".", referenceText));
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleDslFile buildDslFile, @NotNull String referenceText) {
        GradleDslFile propertiesDslFile = buildDslFile.getSiblingDslFile();
        return propertiesDslFile != null ? propertiesDslFile.getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslSimpleExpression.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }

    protected void valueChanged() {
        this.myHasCycle = ThreeState.UNSURE;
        this.setModified();
    }

    public boolean hasCycle() {
        if (this.myHasCycle != ThreeState.UNSURE) {
            return this.myHasCycle == ThreeState.YES;
        }
        return GradleDslSimpleExpression.hasCycle(this, new HashSet<GradleDslSimpleExpression>(), new HashSet<GradleDslSimpleExpression>());
    }

    private static boolean hasCycle(@NotNull GradleDslSimpleExpression element, @NotNull Set<GradleDslSimpleExpression> seen, @NotNull Set<GradleDslSimpleExpression> cycleFree) {
        if (element.myHasCycle != ThreeState.UNSURE) {
            return element.myHasCycle == ThreeState.YES;
        }
        boolean hasCycle = GradleDslSimpleExpression.checkCycle(element, seen, cycleFree);
        element.myHasCycle = hasCycle ? ThreeState.YES : ThreeState.NO;
        return hasCycle;
    }

    private static boolean checkCycle(@NotNull GradleDslSimpleExpression element, @NotNull Set<GradleDslSimpleExpression> seen, @NotNull Set<GradleDslSimpleExpression> cycleFree) {
        if (cycleFree.contains(element) || element.getExpression() == null) {
            return false;
        }
        if (seen.contains(element)) {
            return true;
        }
        seen.add(element);
        List<GradleReferenceInjection> injections = element.getResolvedVariables();
        for (GradleReferenceInjection injection : injections) {
            boolean hasCycle;
            if (injection.getToBeInjectedExpression() == null || !(hasCycle = GradleDslSimpleExpression.hasCycle(injection.getToBeInjectedExpression(), seen, cycleFree))) continue;
            seen.remove(element);
            return true;
        }
        seen.remove(element);
        cycleFree.add(element);
        return false;
    }

    @Override
    public void resolve() {
        this.setupDependencies(this.myExpression);
    }

    @NotNull
    protected List<GradleReferenceInjection> fetchDependencies(@Nullable PsiElement element) {
        if (element == null) {
            return ImmutableList.of();
        }
        return (List)ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().getInjections(this, element));
    }

    protected void setupDependencies(@Nullable PsiElement element) {
        this.myDependencies.stream().filter(e -> e.getToBeInjected() != null).forEach(e -> e.getToBeInjected().unregisterDependent((GradleReferenceInjection)e));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() == null).forEach(e -> this.getDslFile().getContext().getDependencyManager().unregisterUnresolvedReference((GradleReferenceInjection)e));
        this.myDependencies.clear();
        this.myDependencies.addAll(this.fetchDependencies(element));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() != null).forEach(e -> e.getToBeInjected().registerDependent((GradleReferenceInjection)e));
        this.myDependencies.stream().filter(e -> e.getToBeInjected() == null).forEach(e -> this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e));
    }
}

