/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNameElement {
    @NotNull
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @NotNull
    private final Pattern SPACES = Pattern.compile("\\s+");
    @Nullable
    private PsiElement myNameElement;
    @Nullable
    private String mySavedName;
    @Nullable
    private String myUnsavedName;
    @Nullable
    private String myFakeName;
    @Nullable
    private String myName = null;

    @NotNull
    public static GradleNameElement from(@NotNull PsiElement element) {
        return new GradleNameElement(element);
    }

    @NotNull
    public static GradleNameElement empty() {
        return new GradleNameElement((PsiElement)null);
    }

    @NotNull
    public static GradleNameElement create(@NotNull String name) {
        return new GradleNameElement(name, false);
    }

    @NotNull
    public static GradleNameElement fake(@NotNull String name) {
        return new GradleNameElement(name, true);
    }

    @NotNull
    public static GradleNameElement copy(@NotNull GradleNameElement element) {
        return new GradleNameElement(element);
    }

    private GradleNameElement(@Nullable PsiElement element) {
        this.setUpFrom(element);
    }

    private GradleNameElement(@NotNull String name, boolean isFake) {
        if (isFake) {
            this.myFakeName = name;
        } else {
            this.myUnsavedName = name;
        }
    }

    private GradleNameElement(@NotNull GradleNameElement element) {
        this.mySavedName = element.mySavedName;
        this.myUnsavedName = element.myUnsavedName;
        this.myFakeName = element.myFakeName;
    }

    public void commitNameChange(@Nullable PsiElement nameElement) {
        this.setUpFrom(nameElement);
    }

    @NotNull
    public String fullName() {
        List<String> parts = this.qualifyingParts();
        parts.add(this.name());
        return GradleNameElement.createNameFromParts(parts);
    }

    @NotNull
    public List<String> fullNameParts() {
        return Splitter.on((String)".").splitToList((CharSequence)this.fullName());
    }

    public static String createNameFromParts(@NotNull List<String> parts) {
        return String.join((CharSequence)".", parts);
    }

    @NotNull
    public List<String> qualifyingParts() {
        String name = this.findName();
        if (name == null) {
            return Lists.newArrayList();
        }
        List nameSegments = Splitter.on((char)'.').splitToList((CharSequence)name);
        return nameSegments.subList(0, nameSegments.size() - 1).stream().map(GradleNameElement::convertNameToKey).collect(Collectors.toList());
    }

    public boolean isQualified() {
        String name = this.findName();
        if (name == null) {
            return false;
        }
        return name.contains(".");
    }

    @NotNull
    public String name() {
        String name = this.findName();
        if (name == null) {
            return "";
        }
        int lastDotIndex = name.lastIndexOf(46) + 1;
        return GradleNameElement.convertNameToKey(name.substring(lastDotIndex));
    }

    @Nullable
    public PsiElement getNamedPsiElement() {
        return this.myNameElement;
    }

    @Nullable
    public String getUnsavedName() {
        return this.myUnsavedName;
    }

    public void rename(@NotNull String newName2) {
        if (!this.isFake()) {
            this.myUnsavedName = newName2;
        } else {
            this.myFakeName = newName2;
        }
        this.myName = null;
    }

    public boolean isEmpty() {
        String name = this.findName();
        return name == null || name.isEmpty();
    }

    public boolean isFake() {
        return this.myNameElement == null && this.myFakeName != null;
    }

    @NotNull
    public String toString() {
        return this.fullName();
    }

    public boolean containsPropertyReference(@NotNull String propertyReference) {
        String indexName;
        String name = this.name();
        if (propertyReference.equals(name)) {
            return true;
        }
        Matcher matcher = INDEX_PATTERN.matcher(propertyReference);
        if (matcher.find() && matcher.groupCount() > 0 && (indexName = matcher.group(0)).equals(name)) {
            return true;
        }
        List<String> parts = Arrays.asList(propertyReference.split("\\."));
        if (!parts.isEmpty() && parts.get(0).equals(name)) {
            return true;
        }
        return parts.size() > 1 && parts.get(0).equals("ext") && parts.get(1).equals(name);
    }

    @Nullable
    private String findName() {
        if (this.myName != null) {
            return this.myName;
        }
        String name = null;
        if (this.myUnsavedName != null) {
            name = this.myUnsavedName;
        } else if (this.mySavedName != null) {
            name = this.mySavedName;
        }
        if (name == null && this.myFakeName != null) {
            name = this.myFakeName;
        }
        if (name != null) {
            name = this.SPACES.matcher(name).replaceAll("");
        }
        this.myName = name;
        return name;
    }

    @NotNull
    public static String convertNameToKey(@NotNull String str) {
        return StringUtil.unquoteString((String)str);
    }

    private void setUpFrom(@Nullable PsiElement element) {
        this.myNameElement = element;
        if (this.myNameElement instanceof PsiNamedElement) {
            this.mySavedName = ((PsiNamedElement)this.myNameElement).getName();
        } else if (this.myNameElement != null) {
            this.mySavedName = this.myNameElement.getText();
        }
        this.myName = null;
    }
}

