/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ElementSort;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradlePropertiesDslElement
extends GradleDslElementImpl {
    @NotNull
    private static final Predicate<ElementList.ElementItem> VARIABLE_FILTER = e -> ((ElementList.ElementItem)e).myElement.getElementType() == PropertyType.VARIABLE;
    @NotNull
    private static final Predicate<ElementList.ElementItem> PROPERTY_FILTER = VARIABLE_FILTER.negate();
    @NotNull
    private static final Predicate<ElementList.ElementItem> ANY_FILTER = e -> true;
    @NotNull
    private final ElementList myProperties = new ElementList();

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        super(parent, psiElement, name);
    }

    private void addPropertyInternal(@NotNull GradleDslElement element, @NotNull ElementState state) {
        if (this instanceof ExtDslElement && state == ElementState.TO_BE_ADDED) {
            int index = this.reorderAndMaybeGetNewIndex(element);
            this.myProperties.addElementAtIndex(element, state, index, false);
        } else {
            this.myProperties.addElement(element, state, state == ElementState.EXISTING);
        }
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    public void addParsedPropertyAsFirstElement(@NotNull GradleDslElement extElement) {
        this.myProperties.addElementAtIndex(extElement, ElementState.EXISTING, 0, true);
    }

    private void addPropertyInternal(int index, @NotNull GradleDslElement element, @NotNull ElementState state) {
        this.myProperties.addElementAtIndex(element, state, index, state == ElementState.EXISTING);
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    private void addAppliedProperty(@NotNull GradleDslElement element) {
        element.addHolder(this);
        this.addPropertyInternal(element, ElementState.APPLIED);
    }

    private void removePropertyInternal(@NotNull String property2) {
        List elements = this.myProperties.removeAll(e -> ((ElementList.ElementItem)e).myElement.getName().equals(property2));
        elements.forEach(e -> {
            e.setModified();
            this.updateDependenciesOnRemoveElement((GradleDslElement)e);
        });
        this.setModified();
    }

    private ElementState removePropertyInternal(@NotNull GradleDslElement element) {
        element.setModified();
        ElementState state = this.myProperties.remove(element);
        this.updateDependenciesOnRemoveElement(element);
        return state;
    }

    private ElementState replacePropertyInternal(@NotNull GradleDslElement element, @NotNull GradleDslElement newElement) {
        element.setModified();
        this.updateDependenciesOnReplaceElement(element, newElement);
        newElement.setModified();
        ElementState oldState = this.myProperties.replaceElement(element, newElement);
        this.reorderAndMaybeGetNewIndex(newElement);
        return oldState;
    }

    private void hidePropertyInternal(@NotNull String property2) {
        this.myProperties.hideAll(e -> ((ElementList.ElementItem)e).myElement.getName().equals(property2));
    }

    public void addAppliedModelProperties(@NotNull GradleDslFile file) {
        this.mergePropertiesFrom(file);
    }

    private void mergePropertiesFrom(@NotNull GradlePropertiesDslElement other) {
        Map<String, GradleDslElement> ourProperties = this.getPropertyElements();
        for (Map.Entry<String, GradleDslElement> entry : other.getPropertyElements().entrySet()) {
            GradlePropertiesDslElement createdElement;
            GradleDslElement newProperty = entry.getValue();
            if (newProperty instanceof ApplyDslElement) continue;
            if (ourProperties.containsKey(entry.getKey())) {
                GradleDslElement existingProperty = this.getElementWhere(entry.getKey(), PROPERTY_FILTER);
                if (newProperty instanceof GradleDslBlockElement && existingProperty instanceof GradleDslBlockElement) {
                    ((GradlePropertiesDslElement)existingProperty).mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                    continue;
                }
            } else if (PropertyUtil.isPropertiesElementOrMap(newProperty) && (createdElement = this.getDslFile().getParser().getBlockElement(Arrays.asList(entry.getKey().split("\\.")), this, null)) != null) {
                createdElement.mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                continue;
            }
            this.addAppliedProperty(entry.getValue());
        }
    }

    public void setParsedElement(@NotNull GradleDslElement element) {
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    public void addParsedElement(@NotNull GradleDslElement element) {
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    protected void addParsedResettingElement(@NotNull GradleDslElement element, @NotNull String propertyToReset) {
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
        this.hidePropertyInternal(propertyToReset);
    }

    protected void addAsParsedDslExpressionList(GradleDslSimpleExpression expression) {
        PsiElement psiElement = expression.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(expression.getName()), true);
        if (expression instanceof GradleDslMethodCall) {
            literalList.setPsiElement(((GradleDslMethodCall)expression).getArgumentListPsiElement());
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)expression).getArguments()) {
                if (!(gradleDslElement instanceof GradleDslSimpleExpression)) continue;
                literalList.addParsedExpression((GradleDslSimpleExpression)gradleDslElement);
            }
        } else {
            literalList.addParsedExpression(expression);
        }
        this.addPropertyInternal(literalList, ElementState.EXISTING);
    }

    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element) {
        if (element.getPsiElement() == null) {
            return;
        }
        ArrayList<GradleDslElement> newElements = new ArrayList<GradleDslElement>();
        PsiElement psiElement = element.getPsiElement();
        if (element instanceof GradleDslMethodCall) {
            List<GradleDslExpression> args = ((GradleDslMethodCall)element).getArguments();
            if (!args.isEmpty()) {
                if (args.size() == 1 && args.get(0) instanceof GradleDslExpressionList) {
                    newElements.addAll(((GradleDslExpressionList)args.get(0)).getExpressions());
                    PsiElement newElement = args.get(0).getPsiElement();
                    psiElement = newElement != null ? newElement : psiElement;
                } else {
                    newElements.addAll(args);
                }
            }
        } else if (element instanceof GradleDslSimpleExpression) {
            newElements.add(element);
        } else if (element instanceof GradleDslExpressionList) {
            newElements.addAll(((GradleDslExpressionList)element).getExpressions());
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    @NotNull
    public Set<String> getProperties() {
        return this.getPropertyElements().keySet();
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        return this.getElementsWhere(PROPERTY_FILTER);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull String name, @NotNull Class<T> clazz) {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass()) && e.getName().equals(name)).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getAllPropertyElements() {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getVariableElements() {
        return this.getElementsWhere(VARIABLE_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getElements() {
        return this.getElementsWhere(ANY_FILTER);
    }

    @NotNull
    public List<GradleDslElement> getAllElements() {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.ANY_FILTER);
    }

    @NotNull
    private Map<String, GradleDslElement> getElementsWhere(@NotNull Predicate<ElementList.ElementItem> predicate) {
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        List elements = this.myProperties.getElementsWhere(predicate);
        for (GradleDslElement element : elements) {
            if (element == null) continue;
            results.put(element.getName(), element);
        }
        return results;
    }

    private GradleDslElement getElementWhere(@NotNull String name, @NotNull Predicate<ElementList.ElementItem> predicate) {
        return this.getElementsWhere(predicate).get(name);
    }

    @Nullable
    public GradleDslElement getVariableElement(@NotNull String property2) {
        return this.getElementWhere(property2, VARIABLE_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property2) {
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getElement(@NotNull String property2) {
        return this.getElementWhere(property2, ANY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElementBefore(@Nullable GradleDslElement element, @NotNull String property2, boolean includeSelf) {
        if (element == null) {
            return this.getElementWhere(property2, PROPERTY_FILTER);
        }
        return this.myProperties.getElementBeforeChildWhere(e -> GradlePropertiesDslElement.PROPERTY_FILTER.test((ElementList.ElementItem)e) && ((ElementList.ElementItem)e).myElement.getName().equals(property2), element, includeSelf);
    }

    @Nullable
    GradleDslElement getElementBefore(@Nullable GradleDslElement element, @NotNull String property2, boolean includeSelf) {
        if (element == null) {
            return this.getElementWhere(property2, ANY_FILTER);
        }
        return this.myProperties.getElementBeforeChildWhere(e -> GradlePropertiesDslElement.ANY_FILTER.test((ElementList.ElementItem)e) && ((ElementList.ElementItem)e).myElement.getName().equals(property2), element, includeSelf);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.getPropertyElement(property2);
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull List<String> properties, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.myProperties.getElementWhere(e -> properties.contains(((ElementList.ElementItem)e).myElement.getName()));
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull Class<T> clazz) {
        return this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass())).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getPropertyElementsByName(@NotNull String propertyName) {
        return this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElement.getName().equals(propertyName) && GradlePropertiesDslElement.PROPERTY_FILTER.test((ElementList.ElementItem)e));
    }

    @NotNull
    public List<GradleDslElement> getOriginalElements() {
        return this.myProperties.myElements.stream().filter(e -> ((ElementList.ElementItem)e).myExistsOnFile).map(e -> ((ElementList.ElementItem)e).myElement).collect(Collectors.toList());
    }

    @Nullable
    public GradleDslElement getOriginalElementForNameAndType(@NotNull String name, @NotNull PropertyType type) {
        return this.myProperties.myElements.stream().filter(e -> ((ElementList.ElementItem)e).myElement.getName().equals(name) && ((ElementList.ElementItem)e).myExistsOnFile && ((ElementList.ElementItem)e).myElement.getElementType() == type).map(e -> ((ElementList.ElementItem)e).myElement).reduce((a, b) -> b).orElse(null);
    }

    @NotNull
    public List<GradleDslElement> getCurrentElements() {
        return this.myProperties.myElements.stream().filter(e -> ((ElementList.ElementItem)e).myElementState == ElementState.TO_BE_ADDED || ((ElementList.ElementItem)e).myElementState == ElementState.EXISTING).map(e -> ((ElementList.ElementItem)e).myElement).collect(Collectors.toList());
    }

    @NotNull
    public GradleDslElement setNewElement(@NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(newElement, ElementState.TO_BE_ADDED);
        this.setModified();
        return newElement;
    }

    public void addNewElementAt(int index, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(index, newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    public <T> void addNewElementBeforeAllOfClass(@NotNull GradleDslElement newElement, @NotNull Class<T> clazz) {
        List<GradleDslElement> elements = this.getAllElements();
        int index = elements.size() - 1;
        for (int i2 = 0; i2 < elements.size() - 1; ++i2) {
            if (!clazz.isInstance(elements.get(i2))) continue;
            index = i2;
        }
        this.addNewElementAt(index, newElement);
    }

    public void moveElementTo(int index, @NotNull GradleDslElement newElement) {
        assert (newElement.getParent() == this);
        this.myProperties.moveElementToIndex(newElement, index);
    }

    @NotNull
    public GradleDslElement replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        ArrayList<GradlePropertiesDslElement> holders = new ArrayList<GradlePropertiesDslElement>();
        holders.add(this);
        holders.addAll(oldElement.getHolders());
        for (GradlePropertiesDslElement holder : holders) {
            holder.replacePropertyInternal(oldElement, newElement);
        }
        return newElement;
    }

    @Nullable
    public <T> T getLiteral(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslSimpleExpression expression = this.getPropertyElement(property2, GradleDslSimpleExpression.class);
        if (expression == null) {
            return null;
        }
        return expression.getValue(clazz);
    }

    @NotNull
    public GradleDslElement setNewLiteral(@NotNull String property2, @NotNull Object value2) {
        return this.setNewLiteralImpl(property2, value2);
    }

    @NotNull
    private GradleDslElement setNewLiteralImpl(@NotNull String property2, @NotNull Object value2) {
        GradleDslLiteral literalElement = this.getPropertyElement(property2, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, GradleNameElement.create(property2));
            this.addPropertyInternal(literalElement, ElementState.TO_BE_ADDED);
        }
        literalElement.setValue(value2);
        return literalElement;
    }

    @NotNull
    public GradlePropertiesDslElement addToNewLiteralList(@NotNull String property2, @NotNull String value2) {
        return this.addToNewLiteralListImpl(property2, value2);
    }

    @NotNull
    private GradlePropertiesDslElement addToNewLiteralListImpl(@NotNull String property2, @NotNull Object value2) {
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, GradleNameElement.create(property2), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.TO_BE_ADDED);
        }
        gradleDslExpressionList.addNewLiteral(value2);
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionList(@NotNull String property2, @NotNull String value2) {
        return this.removeFromExpressionListImpl(property2, value2);
    }

    @NotNull
    private GradlePropertiesDslElement removeFromExpressionListImpl(@NotNull String property2, @NotNull Object value2) {
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            gradleDslExpressionList.removeExpression(value2);
        }
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement replaceInExpressionList(@NotNull String property2, @NotNull String oldValue, @NotNull String newValue) {
        return this.replaceInExpressionListImpl(property2, oldValue, newValue);
    }

    @NotNull
    private GradlePropertiesDslElement replaceInExpressionListImpl(@NotNull String property2, @NotNull Object oldValue, @NotNull Object newValue) {
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            gradleDslExpressionList.replaceExpression(oldValue, newValue);
        }
        return this;
    }

    public void removeProperty(@NotNull String property2) {
        this.removePropertyInternal(property2);
    }

    public void removeProperty(@NotNull GradleDslElement element) {
        this.removePropertyInternal(element);
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element) {
        GradleDslElement lastElement = null;
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement == element) {
                return lastElement;
            }
            if (item.myElementState == ElementState.TO_BE_REMOVED || item.myElementState == ElementState.HIDDEN || item.myElementState == ElementState.APPLIED || !item.myElement.getNameElement().qualifyingParts().equals(element.getNameElement().qualifyingParts())) continue;
            if (item.myElement instanceof ApplyDslElement) {
                lastElement = item.myElement.requestAnchor(element);
                continue;
            }
            lastElement = item.myElement;
        }
        return lastElement;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        return this.getAllElements();
    }

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        ArrayList<GradleDslElement> result2 = new ArrayList<GradleDslElement>();
        if (includeProperties) {
            result2.addAll(this.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState != ElementState.APPLIED).values());
        } else {
            result2.addAll(this.getVariableElements().values());
        }
        List<GradlePropertiesDslElement> holders = this.getPropertyElements(GradlePropertiesDslElement.class).stream().filter(e -> !(e instanceof GradleDslExpression)).collect(Collectors.toList());
        holders.forEach(e -> result2.addAll(e.getContainedElements(includeProperties)));
        return result2;
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslPropertiesElement(this);
        this.myProperties.removeElements(GradleDslElement::delete);
        this.myProperties.createElements(e -> e.create() != null);
        this.myProperties.applyElements(e -> {
            if (e.isModified()) {
                e.applyChanges();
            }
        });
        this.myProperties.forEach(item -> {
            if (((ElementList.ElementItem)item).myElementState == ElementState.MOVED) {
                ((ElementList.ElementItem)item).myElement.move();
            }
        });
    }

    @Override
    protected void reset() {
        this.myProperties.reset();
    }

    protected void clear() {
        this.myProperties.clear();
    }

    public int reorderAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        int result2 = this.sortElementsAndMaybeGetNewIndex(element);
        element.resolve();
        return result2;
    }

    private int sortElementsAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        List currentElements = this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState == ElementState.EXISTING || ((ElementList.ElementItem)e).myElementState == ElementState.TO_BE_ADDED);
        ArrayList<GradleDslElement> sortedElements = new ArrayList<GradleDslElement>();
        boolean result2 = ElementSort.create(this, element).sort(currentElements, sortedElements);
        int resultIndex = this.myProperties.myElements.size();
        if (!result2) {
            this.notification(NotificationTypeReference.PROPERTY_PLACEMENT);
            return resultIndex;
        }
        int i2 = 0;
        int j = 0;
        while (i2 < currentElements.size() && j < sortedElements.size()) {
            if (currentElements.get(i2) == sortedElements.get(i2)) {
                ++i2;
                ++j;
                continue;
            }
            if (sortedElements.get(i2) == element && !currentElements.contains(element)) {
                resultIndex = i2;
                ++j;
                continue;
            }
            this.moveElementTo(i2, (GradleDslElement)sortedElements.get(j));
            ++i2;
            ++j;
        }
        return resultIndex;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState != ElementState.APPLIED).stream().map(GradleDslElement::getDependencies).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isApplied(@NotNull GradleDslElement element) {
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement != element) continue;
            return item.myElementState == ElementState.APPLIED;
        }
        throw new IllegalStateException("Element not found in parent");
    }

    private static class ElementList {
        @NotNull
        private final List<ElementItem> myElements = new ArrayList<ElementItem>();

        private ElementList() {
        }

        private void forEach(@NotNull Consumer<ElementItem> func) {
            this.myElements.forEach(func);
        }

        @NotNull
        private List<GradleDslElement> getElementsWhere(@NotNull Predicate<ElementItem> predicate) {
            return this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.TO_BE_REMOVED && ((ElementItem)e).myElementState != ElementState.HIDDEN).filter(predicate).map(e -> ((ElementItem)e).myElement).collect(Collectors.toList());
        }

        @Nullable
        private GradleDslElement getElementWhere(@NotNull Predicate<ElementItem> predicate) {
            return this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.TO_BE_REMOVED && ((ElementItem)e).myElementState != ElementState.HIDDEN).filter(predicate).map(e -> ((ElementItem)e).myElement).reduce((first, second) -> second).orElse(null);
        }

        @Nullable
        private GradleDslElement getElementBeforeChildWhere(@NotNull Predicate<ElementItem> predicate, @NotNull GradleDslElement child, boolean includeSelf) {
            GradleDslElement lastElement = null;
            for (ElementItem i2 : this.myElements) {
                if (i2.myElementState == ElementState.TO_BE_REMOVED || i2.myElementState == ElementState.HIDDEN) continue;
                if (predicate.test(i2) && (includeSelf || child != i2.myElement)) {
                    lastElement = i2.myElement;
                }
                if (i2.myElement != child) continue;
                return lastElement;
            }
            return lastElement;
        }

        private void addElement(@NotNull GradleDslElement newElement, @NotNull ElementState state, boolean onFile) {
            this.myElements.add(new ElementItem(newElement, state, onFile));
        }

        private void addElementAtIndex(@NotNull GradleDslElement newElement, @NotNull ElementState state, int index, boolean onFile) {
            this.myElements.add(this.getRealIndex(index, newElement), new ElementItem(newElement, state, onFile));
        }

        private void moveElementToIndex(@NotNull GradleDslElement element, int index) {
            ElementItem item = this.myElements.stream().filter(e -> ((ElementItem)e).myElement == element).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            this.myElements.remove(item);
            ElementList.moveElementTree(item);
            this.myElements.add(this.getRealIndex(index, element), item);
        }

        private int getRealIndex(int index, @NotNull GradleDslElement element) {
            if (index <= 0) {
                return 0;
            }
            for (int i2 = 0; i2 < this.myElements.size(); ++i2) {
                if (index == 0) {
                    return i2;
                }
                ElementItem item = this.myElements.get(i2);
                if (item.myElementState == ElementState.TO_BE_REMOVED || item.myElementState == ElementState.APPLIED || item.myElementState == ElementState.HIDDEN) continue;
                --index;
            }
            return this.myElements.size();
        }

        @Nullable
        private ElementState remove(@NotNull GradleDslElement element) {
            ElementItem item = this.myElements.stream().filter(e -> element == ((ElementItem)e).myElement).findFirst().orElse(null);
            if (item == null) {
                return null;
            }
            ElementState oldState = item.myElementState;
            item.myElementState = ElementState.TO_BE_REMOVED;
            return oldState;
        }

        @Nullable
        private ElementState replaceElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            for (int i2 = 0; i2 < this.myElements.size(); ++i2) {
                ElementItem item = this.myElements.get(i2);
                if (oldElement != item.myElement) continue;
                ElementState oldState = item.myElementState;
                item.myElementState = ElementState.TO_BE_REMOVED;
                ElementState newState = ElementState.TO_BE_ADDED;
                if (oldState == ElementState.APPLIED || oldState == ElementState.HIDDEN) {
                    newState = oldState;
                }
                this.myElements.add(i2, new ElementItem(newElement, newState, false));
                return oldState;
            }
            return null;
        }

        @NotNull
        private List<GradleDslElement> removeAll(@NotNull Predicate<ElementItem> filter2) {
            List<ElementItem> toBeRemoved = this.myElements.stream().filter(filter2).collect(Collectors.toList());
            toBeRemoved.forEach((? super T e) -> ((ElementItem)e).myElementState = ElementState.TO_BE_REMOVED);
            return toBeRemoved.stream().map(e -> ((ElementItem)e).myElement).collect(Collectors.toList());
        }

        private void hideAll(@NotNull Predicate<ElementItem> filter2) {
            this.myElements.stream().filter(filter2).forEach((? super T e) -> ((ElementItem)e).myElementState = ElementState.HIDDEN);
        }

        private boolean isEmpty() {
            return this.myElements.isEmpty();
        }

        private void reset() {
            Iterator<ElementItem> i2 = this.myElements.iterator();
            while (i2.hasNext()) {
                ElementItem item = i2.next();
                item.myElement.resetState();
                if (item.myElementState == ElementState.TO_BE_REMOVED) {
                    item.myElementState = ElementState.EXISTING;
                }
                if (item.myElementState != ElementState.TO_BE_ADDED) continue;
                i2.remove();
            }
        }

        private void removeElements(@NotNull Consumer<GradleDslElement> removeFunc) {
            Iterator<ElementItem> i2 = this.myElements.iterator();
            while (i2.hasNext()) {
                ElementItem item = i2.next();
                if (item.myElementState != ElementState.TO_BE_REMOVED) continue;
                removeFunc.accept(item.myElement);
                i2.remove();
            }
        }

        private void createElements(@NotNull Predicate<GradleDslElement> addFunc) {
            Iterator<ElementItem> i2 = this.myElements.iterator();
            while (i2.hasNext()) {
                ElementItem item = i2.next();
                if (item.myElementState != ElementState.TO_BE_ADDED) continue;
                if (addFunc.test(item.myElement)) {
                    item.myElementState = ElementState.EXISTING;
                    continue;
                }
                i2.remove();
            }
        }

        private void applyElements(@NotNull Consumer<GradleDslElement> func) {
            this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.APPLIED).map(e -> ((ElementItem)e).myElement).forEach(func);
        }

        private void clear() {
            this.myElements.clear();
        }

        private static void moveElementTree(@NotNull ElementItem item) {
            if (item.myElementState != ElementState.TO_BE_ADDED) {
                item.myElementState = ElementState.MOVED;
            }
            item.myElement.setModified();
        }

        private static class ElementItem {
            @NotNull
            private GradleDslElement myElement;
            @NotNull
            private ElementState myElementState;
            private boolean myExistsOnFile;

            private ElementItem(@NotNull GradleDslElement element, @NotNull ElementState state, boolean existsOnFile) {
                this.myElement = element;
                this.myElementState = state;
                this.myExistsOnFile = existsOnFile;
            }
        }
    }
}

