/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslParser;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslWriter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<GradleDslFile> myChildModuleDslFiles = Sets.newHashSet();
    @NotNull
    private final GradleDslWriter myGradleDslWriter;
    @NotNull
    private final GradleDslParser myGradleDslParser;
    @Nullable
    private GradleDslFile myParentModuleDslFile;
    @Nullable
    private GradleDslFile mySiblingDslFile;
    @Nullable
    private ApplyDslElement myApplyDslElement;
    @NotNull
    private final BuildModelContext myBuildModelContext;

    protected GradleDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context) {
        super(null, null, GradleNameElement.fake(moduleName));
        this.myFile = file;
        this.myProject = project;
        this.myBuildModelContext = context;
        Application application = ApplicationManager.getApplication();
        PsiFile psiFile = (PsiFile)application.runReadAction(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
        if (!(psiFile instanceof GroovyFile)) {
            this.myGradleDslParser = new GradleDslParser.Adapter();
            this.myGradleDslWriter = new GradleDslWriter.Adapter();
            return;
        }
        GroovyFile groovyPsiFile = (GroovyFile)psiFile;
        this.myGradleDslParser = new GroovyDslParser(groovyPsiFile, this);
        this.myGradleDslWriter = new GroovyDslWriter();
        this.setPsiElement((PsiElement)groovyPsiFile);
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        this.myGradleDslParser.parse();
        this.getContext().getDependencyManager().resolveAll();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public File getDirectoryPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
    }

    @NotNull
    public List<GradleDslFile> getApplyDslElement() {
        return this.myApplyDslElement == null ? ImmutableList.of() : this.myApplyDslElement.getAppliedDslFiles();
    }

    public void setParentModuleDslFile(@NotNull GradleDslFile parentModuleDslFile) {
        this.myParentModuleDslFile = parentModuleDslFile;
        this.myParentModuleDslFile.myChildModuleDslFiles.add(this);
    }

    @Nullable
    public GradleDslFile getParentModuleDslFile() {
        return this.myParentModuleDslFile;
    }

    @NotNull
    public Collection<GradleDslFile> getChildModuleDslFiles() {
        return this.myChildModuleDslFiles;
    }

    public void setSiblingDslFile(@NotNull GradleDslFile siblingDslFile) {
        this.mySiblingDslFile = siblingDslFile;
    }

    @Nullable
    public GradleDslFile getSiblingDslFile() {
        return this.mySiblingDslFile;
    }

    @NotNull
    public GradleDslWriter getWriter() {
        return this.myGradleDslWriter;
    }

    @NotNull
    public GradleDslParser getParser() {
        return this.myGradleDslParser;
    }

    @NotNull
    public BuildModelContext getContext() {
        return this.myBuildModelContext;
    }

    @Override
    protected void apply() {
        if (this.myApplyDslElement != null) {
            for (GradleDslFile file : this.myApplyDslElement.getAppliedDslFiles()) {
                file.apply();
            }
        }
        super.apply();
    }

    public void registerApplyElement(@NotNull ApplyDslElement applyElement) {
        this.myApplyDslElement = applyElement;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications() {
        return this.myBuildModelContext.getPublicNotifications(this);
    }

    public void saveAllChanges() {
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return;
        }
        assert (element instanceof PsiFile);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = psiDocumentManager.getDocument((PsiFile)element);
        if (document == null) {
            return;
        }
        if (psiDocumentManager.isDocumentBlockedByPsi(document)) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        FileDocumentManager.getInstance().saveDocument(document);
    }

    @Nullable
    public VirtualFile tryToFindSettingsFile() {
        if (this instanceof GradleSettingsFile) {
            return this.getFile();
        }
        for (VirtualFile buildFileParent = this.getFile().getParent(); buildFileParent != null; buildFileParent = buildFileParent.getParent()) {
            VirtualFile maybeSettingsFile = GradleUtil.getGradleSettingsFile(VfsUtilCore.virtualToIoFile((VirtualFile)buildFileParent));
            if (maybeSettingsFile == null) continue;
            return maybeSettingsFile;
        }
        return null;
    }
}

