/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Charsets;
import com.intellij.internal.psiView.stubtree.StubViewerPsiBasedTree;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslFileCache {
    @NotNull
    private Project myProject;
    @NotNull
    private Map<String, GradleDslFile> myParsedBuildFiles = new HashMap<String, GradleDslFile>();

    public GradleDslFileCache(@NotNull Project project) {
        this.myProject = project;
    }

    public void clearAllFiles() {
        this.myParsedBuildFiles.clear();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name, @NotNull BuildModelContext context, boolean isApplied) {
        GradleDslFile dslFile = this.myParsedBuildFiles.get(file.getUrl());
        if (dslFile == null) {
            dslFile = GradleBuildModelImpl.parseBuildFile(file, this.myProject, name, context, isApplied);
            this.myParsedBuildFiles.put(file.getUrl(), dslFile);
        } else if (!(dslFile instanceof GradleBuildFile)) {
            throw new IllegalStateException("Found wrong type for build file in cache!");
        }
        return (GradleBuildFile)dslFile;
    }

    public void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        this.myParsedBuildFiles.put(name, buildFile);
    }

    @Nullable
    public GradleSettingsFile getSettingsFile(@NotNull Project project) {
        VirtualFile file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath((Project)project));
        if (file == null) {
            return null;
        }
        GradleDslFile dslFile = this.myParsedBuildFiles.get(file.getUrl());
        if (dslFile != null && !(dslFile instanceof GradleSettingsFile)) {
            throw new IllegalStateException("Found wrong type for settings file in cache!");
        }
        return (GradleSettingsFile)dslFile;
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile, @NotNull BuildModelContext context) {
        GradleDslFile dslFile = this.myParsedBuildFiles.get(settingsFile.getUrl());
        if (dslFile == null) {
            dslFile = new GradleSettingsFile(settingsFile, this.myProject, "settings", context);
            dslFile.parse();
            this.myParsedBuildFiles.put(settingsFile.getUrl(), dslFile);
        } else if (!(dslFile instanceof GradleSettingsFile)) {
            throw new IllegalStateException("Found wrong type for settings file in cache!");
        }
        return (GradleSettingsFile)dslFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName, @NotNull BuildModelContext context) {
        GradleDslFile dslFile = this.myParsedBuildFiles.get(file.getUrl());
        if (dslFile == null) {
            try {
                Properties properties = GradleDslFileCache.getProperties(file);
                dslFile = new GradlePropertiesFile(properties, file, this.myProject, moduleName, context);
                this.myParsedBuildFiles.put(file.getUrl(), dslFile);
            }
            catch (IOException e) {
                StubViewerPsiBasedTree.LOG.warn("Failed to process properties file " + file.getPath(), (Throwable)e);
                return null;
            }
        } else if (!(dslFile instanceof GradlePropertiesFile)) {
            throw new IllegalStateException("Found wrong type for properties file in cache!");
        }
        return (GradlePropertiesFile)dslFile;
    }

    private static Properties getProperties(@NotNull VirtualFile file) throws IOException {
        Properties properties = new Properties();
        properties.load(new InputStreamReader(file.getInputStream(), Charsets.UTF_8));
        return properties;
    }

    @NotNull
    public List<GradleDslFile> getAllFiles() {
        return new ArrayList<GradleDslFile>(this.myParsedBuildFiles.values());
    }
}

