/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.FakeArtifactElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslUnknownElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyDslParser
implements GradleDslParser {
    @NotNull
    private final GroovyFile myPsiFile;
    @NotNull
    private final GradleDslFile myDslFile;

    public GroovyDslParser(@NotNull GroovyFile file, @NotNull GradleDslFile dslFile) {
        this.myPsiFile = file;
        this.myDslFile = dslFile;
    }

    @Override
    public void parse() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myPsiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitAssignmentExpression(@NotNull GrAssignmentExpression e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitApplicationStatement(@NotNull GrApplicationStatement e) {
                this.process((GroovyPsiElement)e);
            }

            public void visitVariableDeclaration(@NotNull GrVariableDeclaration e) {
                this.process((GroovyPsiElement)e);
            }

            void process(GroovyPsiElement e) {
                GroovyDslParser.this.parse((PsiElement)e, GroovyDslParser.this.myDslFile);
            }
        }));
    }

    @Override
    @Nullable
    public PsiElement convertToPsiElement(@NotNull Object literal) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            return GroovyDslUtil.createLiteral(this.myDslFile, literal);
        }
        catch (IncorrectOperationException e) {
            this.myDslFile.getContext().getNotificationForType(this.myDslFile, NotificationTypeReference.INVALID_EXPRESSION).addError(e);
            return null;
        }
    }

    @Override
    public void setUpForNewValue(@NotNull GradleDslLiteral context, @Nullable PsiElement newValue) {
        if (newValue == null) {
            return;
        }
        boolean isReference = newValue instanceof GrReferenceExpression || newValue instanceof GrIndexProperty;
        context.setReference(isReference);
    }

    @Override
    @Nullable
    public Object extractValue(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement literal, boolean resolve2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (literal instanceof GrReferenceExpression || literal instanceof GrIndexProperty) {
            GradleDslElement e;
            if (resolve2 && (e = context.resolveReference(literal.getText(), true)) instanceof GradleDslSimpleExpression) {
                return ((GradleDslSimpleExpression)e).getValue();
            }
            return literal.getText();
        }
        if (!(literal instanceof GrLiteral)) {
            return new ReferenceTo(literal.getText());
        }
        Object value2 = ((GrLiteral)literal).getValue();
        if (value2 != null) {
            return value2;
        }
        if (!(literal instanceof GrString)) {
            return null;
        }
        if (!resolve2) {
            return GroovyDslUtil.ensureUnquotedText(literal.getText());
        }
        if (context.hasCycle()) {
            return GroovyDslUtil.ensureUnquotedText(literal.getText());
        }
        List<GradleReferenceInjection> injections = context.getResolvedVariables();
        return GroovyDslUtil.ensureUnquotedText(GradleReferenceInjection.injectAll(literal, injections));
    }

    @Override
    @Nullable
    public PsiElement convertToExcludesBlock(@NotNull List<ArtifactDependencySpec> excludes) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)this.myDslFile.getProject());
        GrClosableBlock block = factory.createClosureFromText("{\n}");
        for (ArtifactDependencySpec spec : excludes) {
            String group = FakeArtifactElement.shouldInterpolate(spec.getGroup()) ? GradlePropertyModel.iStr(spec.getGroup()) : "'" + spec.getGroup() + "'";
            String name = FakeArtifactElement.shouldInterpolate(spec.getName()) ? GradlePropertyModel.iStr(spec.getName()) : "'" + spec.getName() + "'";
            String text = String.format("exclude group: %s, module: %s", group, name);
            block.addBefore((PsiElement)factory.createStatementFromText((CharSequence)text), block.getLastChild());
            PsiElement lineTerminator = factory.createLineTerminator(1);
            block.addBefore(lineTerminator, block.getLastChild());
        }
        return block;
    }

    @Override
    public boolean shouldInterpolate(@NotNull GradleDslElement elementToCheck) {
        PsiElement element = elementToCheck instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)elementToCheck).getCurrentElement() : (elementToCheck instanceof GradleDslSimpleExpression ? ((GradleDslSimpleExpression)elementToCheck).getExpression() : elementToCheck.getPsiElement());
        return element instanceof GrString;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement) {
        return GroovyDslUtil.findInjections(context, psiElement, false);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement) {
        return GroovyDslUtil.findInjections(context, psiElement, true);
    }

    @Override
    @Nullable
    public GradlePropertiesDslElement getBlockElement(@NotNull List<String> nameParts, @NotNull GradlePropertiesDslElement parentElement, @Nullable GradleNameElement nameElement) {
        return SharedParserUtilsKt.getBlockElement(this.myDslFile, nameParts, parentElement, nameElement);
    }

    private void parse(@NotNull PsiElement psiElement, @NotNull GradleDslFile gradleDslFile) {
        boolean success = false;
        if (psiElement instanceof GrMethodCallExpression) {
            success = this.parse((GrMethodCallExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrAssignmentExpression) {
            success = this.parse((GrAssignmentExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrApplicationStatement) {
            success = this.parse((GrApplicationStatement)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrVariableDeclaration) {
            success = this.parse((GrVariableDeclaration)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrReferenceExpression) {
            success = this.parse((GrReferenceExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        }
        if (!success) {
            gradleDslFile.notification(NotificationTypeReference.INCOMPLETE_PARSING).addUnknownElement(psiElement);
        }
    }

    private boolean parse(@NotNull GrReferenceExpression element, @NotNull GradlePropertiesDslElement dslElement) {
        GradlePropertiesDslElement nestedElement;
        GradleNameElement name = GradleNameElement.from((PsiElement)element);
        if (name.isQualified() && (nestedElement = this.getBlockElement(name.qualifyingParts(), dslElement, null)) != null) {
            dslElement = nestedElement;
        }
        if (!(dslElement instanceof ConfigurationsDslElement)) {
            return false;
        }
        ConfigurationDslElement resultElement = new ConfigurationDslElement(dslElement, (PsiElement)element, name, false);
        resultElement.setElementType(PropertyType.REGULAR);
        dslElement.addParsedElement(resultElement);
        return true;
    }

    private boolean parse(@NotNull GrMethodCallExpression expression, @NotNull GradlePropertiesDslElement dslElement) {
        GradlePropertiesDslElement blockElement;
        GrReferenceExpression referenceExpression = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)expression, GrReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        if (expression.getChildren().length > 1 && referenceExpression.getChildren().length == 1 && referenceExpression.getChildren()[0] instanceof GrMethodCallExpression) {
            return this.parse((GrMethodCallExpression)referenceExpression.getChildren()[0], dslElement);
        }
        GradleNameElement name = GradleNameElement.from((PsiElement)referenceExpression);
        if (name.isEmpty()) {
            return false;
        }
        if (name.isQualified()) {
            dslElement = this.getBlockElement(name.qualifyingParts(), dslElement, null);
        }
        if (dslElement == null) {
            return false;
        }
        GrClosableBlock[] closureArguments = expression.getClosureArguments();
        GrArgumentList argumentList = expression.getArgumentList();
        if (argumentList.getAllArguments().length > 0 || closureArguments.length == 0) {
            GradleDslMethodCall methodCall = this.getMethodCall(dslElement, (PsiElement)expression, name, argumentList, name.fullName(), false);
            if (closureArguments.length > 0) {
                methodCall.setParsedClosureElement(this.getClosureElement(methodCall, closureArguments[0], name));
            }
            methodCall.setElementType(PropertyType.REGULAR);
            dslElement.addParsedElement(methodCall);
            return true;
        }
        GrClosableBlock closableBlock = closureArguments[0];
        ArrayList blockElements = Lists.newArrayList();
        if (dslElement instanceof GradleDslFile && name.name().equals("allprojects")) {
            blockElements.add(dslElement);
            name = GradleNameElement.create("subprojects");
        }
        if ((blockElement = this.getBlockElement((List<String>)ImmutableList.of((Object)name.name()), dslElement, name)) != null) {
            blockElement.setPsiElement((PsiElement)closableBlock);
            blockElements.add(blockElement);
        }
        if (blockElements.isEmpty()) {
            return false;
        }
        for (GradlePropertiesDslElement element : blockElements) {
            this.parse(closableBlock, element);
        }
        return true;
    }

    private void parse(@NotNull GrClosableBlock closure, final @NotNull GradlePropertiesDslElement blockElement) {
        closure.acceptChildren(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                GroovyDslParser.this.parse(methodCallExpression, blockElement);
            }

            public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                GroovyDslParser.this.parse(applicationStatement, blockElement);
            }

            public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                GroovyDslParser.this.parse(expression, blockElement);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                GroovyDslParser.this.parse(referenceExpression, blockElement);
            }

            public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
                GroovyDslParser.this.parse(variableDeclaration, blockElement);
            }
        });
    }

    private boolean parse(@NotNull GrApplicationStatement statement, @NotNull GradlePropertiesDslElement blockElement) {
        GrReferenceExpression referenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, GrReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        GrCommandArgumentList argumentList = (GrCommandArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)referenceExpression, GrCommandArgumentList.class);
        if (argumentList == null) {
            return false;
        }
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        if (arguments.length == 0) {
            return false;
        }
        GradleNameElement name = GradleNameElement.from((PsiElement)referenceExpression);
        if (name.isEmpty()) {
            return false;
        }
        if (name.isQualified()) {
            GradlePropertiesDslElement nestedElement = this.getBlockElement(name.qualifyingParts(), blockElement, null);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        GradleNameElement propertyName = GradleNameElement.from((PsiElement)referenceExpression);
        GradleDslElement propertyElement = null;
        if (arguments[0] instanceof GrExpression) {
            ArrayList<GrExpression> expressions = new ArrayList<GrExpression>(arguments.length);
            for (GroovyPsiElement element : arguments) {
                if (!(element instanceof GrExpression) || element instanceof GrClosableBlock) continue;
                expressions.add((GrExpression)element);
            }
            propertyElement = expressions.size() == 1 ? this.createExpressionElement(blockElement, (GroovyPsiElement)argumentList, propertyName, (GrExpression)expressions.get(0)) : this.getExpressionList(blockElement, (GroovyPsiElement)argumentList, propertyName, expressions, false);
        } else if (arguments[0] instanceof GrNamedArgument) {
            ArrayList<GrNamedArgument> namedArguments = new ArrayList<GrNamedArgument>(arguments.length);
            for (GroovyPsiElement element : arguments) {
                if (!(element instanceof GrNamedArgument) || element instanceof GrClosableBlock) continue;
                namedArguments.add((GrNamedArgument)element);
            }
            propertyElement = this.getExpressionMap(blockElement, (GroovyPsiElement)argumentList, propertyName, namedArguments, false);
        }
        if (propertyElement == null) {
            return false;
        }
        GroovyPsiElement lastArgument = arguments[arguments.length - 1];
        if (lastArgument instanceof GrClosableBlock) {
            propertyElement.setParsedClosureElement(this.getClosureElement(propertyElement, (GrClosableBlock)lastArgument, propertyName));
        }
        propertyElement.setElementType(PropertyType.REGULAR);
        blockElement.addParsedElement(propertyElement);
        return true;
    }

    @NotNull
    private GradleDslExpression createExpressionElement(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull GradleNameElement name, @NotNull GrExpression expression) {
        GrListOrMap listOrMap;
        GradleDslElement propertyElement = expression instanceof GrListOrMap ? ((listOrMap = (GrListOrMap)expression).isMap() ? this.getExpressionMap(parent, (GroovyPsiElement)listOrMap, name, Arrays.asList(listOrMap.getNamedArguments()), true) : this.getExpressionList(parent, (GroovyPsiElement)listOrMap, name, Arrays.asList(listOrMap.getInitializers()), true)) : (expression instanceof GrClosableBlock ? this.getClosureElement(parent, (GrClosableBlock)expression, name) : this.getExpressionElement(parent, psiElement, name, expression));
        return propertyElement;
    }

    private boolean parse(@NotNull GrVariableDeclaration declaration, @NotNull GradlePropertiesDslElement blockElement) {
        if (declaration.getVariables().length == 0) {
            return false;
        }
        for (GrVariable variable : declaration.getVariables()) {
            if (variable == null) {
                return false;
            }
            GrExpression init2 = variable.getInitializerGroovy();
            if (init2 == null) {
                return false;
            }
            GradleNameElement name = GradleNameElement.from((PsiElement)variable);
            GradleDslExpression variableElement = this.createExpressionElement(blockElement, (GroovyPsiElement)declaration, name, init2);
            variableElement.setElementType(PropertyType.VARIABLE);
            blockElement.setParsedElement(variableElement);
        }
        return true;
    }

    private boolean parse(@NotNull GrAssignmentExpression assignment, @NotNull GradlePropertiesDslElement blockElement) {
        GrExpression right2;
        PsiElement operationToken = assignment.getOperationToken();
        if (!operationToken.getText().equals("=")) {
            return false;
        }
        GrExpression left2 = assignment.getLValue();
        GradleNameElement name = GradleNameElement.from((PsiElement)left2);
        if (name.isEmpty()) {
            return false;
        }
        if (name.isQualified()) {
            GradlePropertiesDslElement nestedElement = this.getBlockElement(name.qualifyingParts(), blockElement, null);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        if ((right2 = assignment.getRValue()) == null) {
            return false;
        }
        GradleDslExpression propertyElement = this.createExpressionElement(blockElement, (GroovyPsiElement)assignment, name, right2);
        propertyElement.setUseAssignment(true);
        propertyElement.setElementType(PropertyType.REGULAR);
        blockElement.setParsedElement(propertyElement);
        return true;
    }

    @NotNull
    private GradleDslExpression getExpressionElement(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement psiElement, @NotNull GradleNameElement propertyName, @NotNull GrExpression propertyExpression) {
        GrArgumentList argumentList;
        String objectName;
        GrNewExpression newExpression;
        GrCodeReferenceElement referenceElement;
        String methodName;
        GrMethodCallExpression methodCall;
        GrReferenceExpression callReferenceExpression;
        if (propertyExpression instanceof GrLiteral) {
            return new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, false);
        }
        if (propertyExpression instanceof GrReferenceExpression) {
            return new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, true);
        }
        if (propertyExpression instanceof GrMethodCallExpression && (callReferenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)(methodCall = (GrMethodCallExpression)propertyExpression), GrReferenceExpression.class)) != null && !(methodName = callReferenceExpression.getText()).isEmpty()) {
            GrArgumentList argumentList2 = methodCall.getArgumentList();
            return this.getMethodCall(parentElement, (PsiElement)methodCall, propertyName, argumentList2, methodName, false);
        }
        if (propertyExpression instanceof GrIndexProperty) {
            return new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, true);
        }
        if (propertyExpression instanceof GrNewExpression && (referenceElement = (newExpression = (GrNewExpression)propertyExpression).getReferenceElement()) != null && (objectName = referenceElement.getReferenceName()) != null && !objectName.isEmpty() && (argumentList = newExpression.getArgumentList()) != null && argumentList.getAllArguments().length > 0) {
            return this.getMethodCall(parentElement, (PsiElement)newExpression, propertyName, argumentList, objectName, true);
        }
        parentElement.notification(NotificationTypeReference.INCOMPLETE_PARSING).addUnknownElement((PsiElement)propertyExpression);
        return new GradleDslUnknownElement(parentElement, (PsiElement)propertyExpression, propertyName);
    }

    @NotNull
    private GradleDslMethodCall getMethodCall(@NotNull GradleDslElement parentElement, @NotNull PsiElement psiElement, @NotNull GradleNameElement propertyName, @NotNull GrArgumentList argumentList, @NotNull String methodName, boolean isConstructor) {
        GradleDslMethodCall methodCall = new GradleDslMethodCall(parentElement, psiElement, propertyName, methodName, isConstructor);
        GradleDslExpressionList arguments = this.getExpressionList(methodCall, (GroovyPsiElement)argumentList, GradleNameElement.empty(), Arrays.asList(argumentList.getExpressionArguments()), false);
        methodCall.setParsedArgumentList(arguments);
        GrNamedArgument[] namedArguments = argumentList.getNamedArguments();
        if (namedArguments.length > 0) {
            methodCall.addParsedExpression(this.getExpressionMap(methodCall, (GroovyPsiElement)argumentList, GradleNameElement.empty(), Arrays.asList(namedArguments), false));
        }
        return methodCall;
    }

    @NotNull
    private GradleDslExpressionList getExpressionList(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement listPsiElement, @NotNull GradleNameElement propertyName, @NotNull List<GrExpression> propertyExpressions, boolean isLiteral) {
        GradleDslExpressionList expressionList = new GradleDslExpressionList(parentElement, (PsiElement)listPsiElement, isLiteral, propertyName);
        for (GrExpression expression : propertyExpressions) {
            GradleDslExpression expressionElement = this.createExpressionElement(expressionList, (GroovyPsiElement)expression, GradleNameElement.empty(), expression);
            if (expressionElement instanceof GradleDslClosure) {
                parentElement.setParsedClosureElement((GradleDslClosure)expressionElement);
                continue;
            }
            expressionList.addParsedExpression(expressionElement);
        }
        return expressionList;
    }

    @NotNull
    private GradleDslExpressionMap getExpressionMap(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement mapPsiElement, @NotNull GradleNameElement propertyName, @NotNull List<GrNamedArgument> namedArguments, boolean isLiteralMap) {
        GradleDslExpressionMap expressionMap = new GradleDslExpressionMap(parentElement, (PsiElement)mapPsiElement, propertyName, isLiteralMap);
        for (GrNamedArgument namedArgument : namedArguments) {
            GrExpression valueExpression;
            GradleNameElement argName;
            GrArgumentLabel nameLabel = namedArgument.getLabel();
            if (nameLabel == null || (argName = GradleNameElement.from(nameLabel.getNameElement())).isEmpty() || (valueExpression = namedArgument.getExpression()) == null) continue;
            GradleDslExpression valueElement = this.createExpressionElement(expressionMap, mapPsiElement, argName, valueExpression);
            if (valueElement instanceof GradleDslUnknownElement && valueExpression instanceof GrListOrMap) {
                GrListOrMap listOrMap = (GrListOrMap)valueExpression;
                valueElement = listOrMap.isMap() ? this.getExpressionMap(expressionMap, (GroovyPsiElement)listOrMap, argName, Arrays.asList(listOrMap.getNamedArguments()), true) : this.getExpressionList(expressionMap, (GroovyPsiElement)listOrMap, argName, Arrays.asList(listOrMap.getInitializers()), true);
            }
            expressionMap.setParsedElement(valueElement);
        }
        return expressionMap;
    }

    @NotNull
    private GradleDslClosure getClosureElement(@NotNull GradleDslElement parentElement, @NotNull GrClosableBlock closableBlock, @NotNull GradleNameElement propertyName) {
        GradleDslClosure closureElement = new GradleDslClosure(parentElement, (PsiElement)closableBlock, propertyName);
        this.parse(closableBlock, (GradlePropertiesDslElement)closureElement);
        return closureElement;
    }
}

