/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GroovyDslUtil {
    @Nullable
    static GroovyPsiElement ensureGroovyPsi(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof GroovyPsiElement) {
            return (GroovyPsiElement)element;
        }
        throw new IllegalArgumentException("Wrong PsiElement type for writer! Must be of type GoovyPsiElement");
    }

    static void addConfigBlock(@NotNull GradleDslSettableExpression expression) {
        PsiElement unsavedConfigBlock = expression.getUnsavedConfigBlock();
        if (unsavedConfigBlock == null) {
            return;
        }
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(expression.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(expression);
        if (factory == null) {
            return;
        }
        GrApplicationStatement methodCallStatement = (GrApplicationStatement)factory.createStatementFromText((CharSequence)"foo 1, 2");
        PsiElement comma = methodCallStatement.getArgumentList().getFirstChild().getNextSibling();
        psiElement.addAfter(comma, psiElement.getLastChild());
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        psiElement.addAfter(unsavedConfigBlock, psiElement.getLastChild());
        expression.setUnsavedConfigBlock(null);
    }

    @Nullable
    static GrClosableBlock getClosableBlock(@NotNull PsiElement element) {
        if (!(element instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element).getClosureArguments();
        if (closureArguments.length > 0) {
            return closureArguments[0];
        }
        return null;
    }

    static GroovyPsiElementFactory getPsiElementFactory(@NotNull GradleDslElement element) {
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement());
        if (psiElement == null) {
            return null;
        }
        Project project = psiElement.getProject();
        return GroovyPsiElementFactory.getInstance((Project)project);
    }

    static boolean isNewEmptyBlockElement(@NotNull GradleDslElement element) {
        if (element.getPsiElement() != null) {
            return false;
        }
        if (!element.isBlockElement() || !element.isInsignificantIfEmpty()) {
            return false;
        }
        Collection<GradleDslElement> children = element.getChildren();
        if (children.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children) {
            if (GroovyDslUtil.isNewEmptyBlockElement(child)) continue;
            return false;
        }
        return true;
    }

    static void maybeDeleteIfEmpty(@Nullable PsiElement element, @NotNull GradleDslElement dslElement) {
        GradleDslElement parentDslElement = dslElement.getParent();
        if (parentDslElement instanceof GradleDslExpressionList && !((GradleDslExpressionList)parentDslElement).shouldBeDeleted() || parentDslElement instanceof GradleDslExpressionMap && !((GradleDslExpressionMap)parentDslElement).shouldBeDeleted() && parentDslElement.getPsiElement() == element) {
            return;
        }
        GroovyDslUtil.deleteIfEmpty(element, dslElement);
    }

    private static void deleteIfEmpty(@Nullable PsiElement element, @NotNull GradleDslElement containingDslElement) {
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        GradleDslElement dslParent = GroovyDslUtil.getNextValidParent(containingDslElement);
        if (element.isValid()) {
            if (element instanceof GrAssignmentExpression) {
                if (((GrAssignmentExpression)element).getRValue() == null) {
                    element.delete();
                }
            } else if (element instanceof GrApplicationStatement) {
                if (((GrApplicationStatement)element).getArgumentList() == null) {
                    element.delete();
                }
            } else if (element instanceof GrClosableBlock) {
                if (dslParent == null || dslParent.isInsignificantIfEmpty()) {
                    final Boolean[] isEmpty = new Boolean[]{true};
                    ((GrClosableBlock)element).acceptChildren(new GroovyElementVisitor(){

                        public void visitElement(@NotNull GroovyPsiElement child) {
                            if (child instanceof GrParameterList && ((GrParameterList)child).getParameters().length == 0) {
                                return;
                            }
                            isEmpty[0] = false;
                        }
                    });
                    if (isEmpty[0].booleanValue()) {
                        element.delete();
                    }
                }
            } else if (element instanceof GrMethodCallExpression) {
                GrMethodCallExpression call = (GrMethodCallExpression)element;
                GrArgumentList argumentList = null;
                try {
                    for (PsiElement curr = call.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                        if (!(curr instanceof GrArgumentList)) continue;
                        argumentList = (GrArgumentList)curr;
                        break;
                    }
                }
                catch (AssertionError e) {
                    argumentList = null;
                }
                GrClosableBlock[] closureArguments = call.getClosureArguments();
                if ((argumentList == null || argumentList.getAllArguments().length == 0) && closureArguments.length == 0) {
                    element.delete();
                }
            } else if (element instanceof GrCommandArgumentList) {
                GrCommandArgumentList commandArgumentList = (GrCommandArgumentList)element;
                if (commandArgumentList.getAllArguments().length == 0) {
                    commandArgumentList.delete();
                }
            } else if (element instanceof GrNamedArgument) {
                GrNamedArgument namedArgument = (GrNamedArgument)element;
                if (namedArgument.getExpression() == null) {
                    namedArgument.delete();
                }
            } else if (element instanceof GrVariableDeclaration) {
                GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)element;
                for (GrVariable grVariable : variableDeclaration.getVariables()) {
                    if (grVariable.getInitializerGroovy() != null) continue;
                    grVariable.delete();
                }
                if (variableDeclaration.getVariables().length == 0) {
                    variableDeclaration.delete();
                }
            } else if (element instanceof GrVariable) {
                GrVariable variable = (GrVariable)element;
                if (variable.getInitializerGroovy() == null) {
                    variable.delete();
                }
            } else if (element instanceof GrListOrMap) {
                GrListOrMap listOrMap = (GrListOrMap)element;
                if (listOrMap.isMap() && listOrMap.getNamedArguments().length == 0) {
                    listOrMap.delete();
                } else if (!listOrMap.isMap() && listOrMap.getInitializers().length == 0) {
                    listOrMap.delete();
                }
            }
        }
        if (!element.isValid()) {
            GroovyDslUtil.handleElementRemoved(parent, element);
            if (dslParent != null && dslParent.isInsignificantIfEmpty()) {
                GroovyDslUtil.maybeDeleteIfEmpty(parent, element == dslParent.getPsiElement() ? dslParent : containingDslElement);
            }
        }
    }

    @Nullable
    static GradleDslElement getNextValidParent(@NotNull GradleDslElement element) {
        PsiElement psi = element.getPsiElement();
        while (!(element == null || psi != null && psi.isValid())) {
            if ((element = element.getParent()) == null) continue;
            psi = element.getPsiElement();
        }
        return element;
    }

    static void removePsiIfInvalid(@Nullable GradleDslElement element) {
        if (element == null) {
            return;
        }
        if (element.getPsiElement() != null && !element.getPsiElement().isValid()) {
            element.setPsiElement(null);
        }
        if (element.getParent() != null) {
            GroovyDslUtil.removePsiIfInvalid(element.getParent());
        }
    }

    static void handleElementRemoved(@Nullable PsiElement psiElement, @Nullable PsiElement removed) {
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)psiElement;
            if (removed instanceof GrNamedArgument && listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOLON, (CharSequence)":", listOrMap.getRBrack().getNode());
            }
        }
    }

    @Nullable
    static GrExpression extractUnsavedExpression(@NotNull GradleDslSettableExpression literal) {
        GroovyPsiElement newElement = GroovyDslUtil.ensureGroovyPsi(literal.getUnsavedValue());
        if (!(newElement instanceof GrExpression)) {
            return null;
        }
        return (GrExpression)newElement;
    }

    private static String escapeString(@NotNull String str, boolean forGString) {
        StringBuilder sb = new StringBuilder();
        GrStringUtil.escapeStringCharacters((int)str.length(), (CharSequence)str, (String)(forGString ? "\"" : "'"), (boolean)true, (boolean)true, (StringBuilder)sb);
        return sb.toString();
    }

    @Nullable
    static PsiElement createLiteral(@NotNull GradleDslElement context, @NotNull Object unsavedValue) throws IncorrectOperationException {
        String unsavedValueText = null;
        if (unsavedValue instanceof String) {
            String stringValue = (String)unsavedValue;
            if (StringUtil.isQuotedString((String)stringValue)) {
                String unquotedString = GrStringUtil.removeQuotes((String)stringValue);
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString(unquotedString, true), (boolean)true);
            } else {
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString((String)unsavedValue, false), (boolean)false);
            }
        } else if (unsavedValue instanceof Integer || unsavedValue instanceof Boolean || unsavedValue instanceof BigDecimal) {
            unsavedValueText = unsavedValue.toString();
        } else if (unsavedValue instanceof RawText) {
            unsavedValueText = ((RawText)unsavedValue).getText();
        }
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(context);
        if (factory == null) {
            return null;
        }
        return factory.createExpressionFromText((CharSequence)unsavedValueText);
    }

    static PsiElement createDerivedMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement parentPsiElement = GroovyDslUtil.getParentPsi(expressionMap);
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression emptyMap = factory.createExpressionFromText((CharSequence)"[:]");
        GrNamedArgument namedArgument = factory.createNamedArgument(expressionMap.getName(), emptyMap);
        PsiElement addedElement = GroovyDslUtil.addToMap((GrListOrMap)parentPsiElement, namedArgument);
        assert (addedElement instanceof GrNamedArgument);
        GrExpression added = ((GrNamedArgument)addedElement).getExpression();
        expressionMap.setPsiElement((PsiElement)added);
        return added;
    }

    private static PsiElement realAddBefore(@NotNull GrListOrMap element, @NotNull PsiElement newElement, @NotNull PsiElement anchor) {
        CheckUtil.checkWritable((PsiElement)element);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)newElement);
        ASTNode anchorNode = GroovyDslUtil.getAnchorNode((PsiElement)element, anchor.getNode(), true);
        ASTNode newNode = CodeEditUtil.addChildren((ASTNode)element.getNode(), (ASTNode)elementCopy, (ASTNode)elementCopy, (ASTNode)anchorNode);
        if (newNode == null) {
            throw new IncorrectOperationException("Element cannot be added");
        }
        if (newNode instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)((TreeElement)newNode)).getPsi();
        }
        return newNode.getPsi();
    }

    private static ASTNode getAnchorNode(@NotNull PsiElement element, ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before != null && before == false ? element.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }

    static PsiElement addToMap(@NotNull GrListOrMap map2, @NotNull GrNamedArgument newValue) {
        ASTNode astNode = map2.getNode();
        if (map2.getNamedArguments().length != 0) {
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", map2.getRBrack().getNode());
        } else {
            while (map2.getLBrack().getNextSibling() != map2.getRBrack()) {
                map2.getLBrack().getNextSibling().delete();
            }
        }
        return GroovyDslUtil.realAddBefore(map2, (PsiElement)newValue, map2.getRBrack());
    }

    @Nullable
    static PsiElement processListElement(@NotNull GradleDslSettableExpression expression) {
        GradleDslElement parent = expression.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement parentPsi = parent.create();
        if (parentPsi == null) {
            return null;
        }
        PsiElement newExpressionPsi = expression.getUnsavedValue();
        if (newExpressionPsi == null) {
            return null;
        }
        PsiElement added = GroovyDslUtil.createPsiElementInsideList(parent, expression, parentPsi, newExpressionPsi);
        expression.setPsiElement(added);
        expression.commit();
        return expression.getPsiElement();
    }

    @Nullable
    static PsiElement processMapElement(@NotNull GradleDslSettableExpression expression) {
        GrNamedArgument added;
        GradleDslElement parent = expression.getParent();
        assert (parent != null);
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        expression.setPsiElement((PsiElement)parentPsiElement);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression);
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory.createNamedArgument(expression.getName(), newLiteral);
        if (parentPsiElement instanceof GrArgumentList) {
            added = ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument);
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap grListOrMap = (GrListOrMap)parentPsiElement;
            added = GroovyDslUtil.addToMap(grListOrMap, namedArgument);
        } else {
            added = parentPsiElement.addBefore((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = added;
            GrExpression grExpression = (GrExpression)PsiTreeUtil.getChildOfType((PsiElement)addedNameArgument, GrExpression.class);
            if (grExpression != null) {
                expression.setExpression((PsiElement)grExpression);
                expression.commit();
                expression.reset();
                return expression.getPsiElement();
            }
            return null;
        }
        throw new IllegalStateException("Unexpected element type added to Mpa: " + added);
    }

    static void applyDslLiteralOrReference(@NotNull GradleDslSettableExpression expression) {
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(expression.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyDslUtil.maybeUpdateName(expression);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression);
        if (newLiteral == null) {
            return;
        }
        GroovyPsiElement psiExpression = GroovyDslUtil.ensureGroovyPsi(expression.getExpression());
        if (psiExpression != null) {
            PsiElement replace = psiExpression.replace((PsiElement)newLiteral);
            if (replace instanceof GrLiteral || replace instanceof GrReferenceExpression || replace instanceof GrIndexProperty) {
                expression.setExpression(replace);
            }
        } else {
            PsiElement added = psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            expression.setExpression(added);
            if (expression.getUnsavedConfigBlock() != null) {
                GroovyDslUtil.addConfigBlock(expression);
            }
        }
        expression.reset();
        expression.commit();
    }

    @Nullable
    static PsiElement createNamedArgumentList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement added;
        GradleDslElement parent = expressionList.getParent();
        assert (parent instanceof GradleDslExpressionMap);
        PsiElement parentPsiElement = parent.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression expressionFromText = factory.createExpressionFromText((CharSequence)"[]");
        GrNamedArgument namedArgument = factory.createNamedArgument(expressionList.getName(), expressionFromText);
        if (parentPsiElement instanceof GrArgumentList) {
            GrArgumentList argList = (GrArgumentList)parentPsiElement;
            argList.addNamedArgument(namedArgument);
            GrNamedArgument[] args = argList.getNamedArguments();
            added = args[args.length - 1];
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)parentPsiElement;
            if (!listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", listOrMap.getLBrack().getNextSibling().getNode());
            }
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        } else {
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = (GrNamedArgument)added;
            expressionList.setPsiElement((PsiElement)addedNameArgument.getExpression());
            return expressionList.getPsiElement();
        }
        return null;
    }

    @Nullable
    static String getInjectionName(@NotNull GrStringInjection injection) {
        String variableName = null;
        GrClosableBlock closableBlock = injection.getClosableBlock();
        if (closableBlock != null) {
            String blockText = closableBlock.getText();
            variableName = blockText.substring(1, blockText.length() - 1);
        } else {
            GrExpression expression = injection.getExpression();
            if (expression != null) {
                variableName = expression.getText();
            }
        }
        return variableName;
    }

    @NotNull
    static String ensureUnquotedText(@NotNull String str) {
        if (StringUtil.isQuotedString((String)str)) {
            str = StringUtil.unquoteString((String)str);
        }
        return str;
    }

    @Nullable
    static PsiElement getParentPsi(@NotNull GradleDslElement element) {
        GradleDslElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        return parentPsiElement;
    }

    static String maybeTrimForParent(@NotNull GradleNameElement name, @Nullable GradleDslElement parent) {
        if (parent == null) {
            return name.fullName();
        }
        ArrayList<String> parts = new ArrayList<String>(name.fullNameParts());
        if (parts.isEmpty()) {
            return name.fullName();
        }
        String lastNamePart = (String)parts.remove(parts.size() - 1);
        List parentParts = Splitter.on((String)".").splitToList((CharSequence)parent.getQualifiedName());
        for (int i2 = 0; i2 < parentParts.size() && !parts.isEmpty() && ((String)parentParts.get(i2)).equals(parts.get(0)); ++i2) {
            parts.remove(0);
        }
        parts.add(lastNamePart);
        return GradleNameElement.createNameFromParts(parts);
    }

    static boolean shouldAddToListInternal(@NotNull GradleDslElement element) {
        GradleDslElement parent = element.getParent();
        if (!(parent instanceof GradleDslExpressionList)) {
            return false;
        }
        PsiElement parentPsi = parent.getPsiElement();
        return parentPsi instanceof GrListOrMap && ((GrListOrMap)parentPsi).getInitializers().length > 0 || parentPsi instanceof GrArgumentList && ((GrArgumentList)parentPsi).getAllArguments().length > 0;
    }

    static void emplaceElementIntoList(@NotNull PsiElement anchorBefore, @NotNull PsiElement list, @NotNull PsiElement newElement) {
        ASTNode node = list.getNode();
        ASTNode anchor = anchorBefore.getNode().getTreeNext();
        node.addChild(newElement.getNode(), anchor);
        node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", newElement.getNode());
    }

    static PsiElement emplaceElementToFrontOfList(@NotNull PsiElement listElement, @NotNull PsiElement newElement) {
        assert (listElement instanceof GrListOrMap || listElement instanceof GrArgumentList);
        ASTNode node = listElement.getNode();
        if (listElement instanceof GrListOrMap) {
            GrListOrMap list = (GrListOrMap)listElement;
            ASTNode anchor = list.getLBrack().getNode().getTreeNext();
            if (!list.isEmpty()) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list.getLBrack().getNode().getTreeNext());
        } else if (((GrArgumentList)listElement).getLeftParen() != null) {
            GrArgumentList list = (GrArgumentList)listElement;
            PsiElement leftParen = list.getLeftParen();
            assert (leftParen != null);
            ASTNode anchor = list.getLeftParen().getNode().getTreeNext();
            if (list.getAllArguments().length != 0) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list.getLeftParen().getNode().getTreeNext());
        } else {
            ASTNode anchor = GroovyDslUtil.getFirstASTNode(listElement);
            if (anchor != null) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), GroovyDslUtil.getFirstASTNode(listElement));
        }
        return newElement;
    }

    @Nullable
    static ASTNode getFirstASTNode(@NotNull PsiElement parent) {
        PsiElement firstChild = parent.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        return firstChild.getNode();
    }

    @NotNull
    static PsiElement createPsiElementInsideList(@NotNull GradleDslElement parentDslElement, @NotNull GradleDslElement dslElement, @NotNull PsiElement parentPsiElement, @NotNull PsiElement newElement) {
        PsiElement added;
        GradleDslElement anchor = parentDslElement.requestAnchor(dslElement);
        if (GroovyDslUtil.shouldAddToListInternal(dslElement) && anchor != null) {
            PsiElement anchorPsi = anchor.getPsiElement();
            assert (anchorPsi != null);
            GroovyDslUtil.emplaceElementIntoList(anchorPsi, parentPsiElement, newElement);
            added = newElement;
        } else {
            added = GroovyDslUtil.emplaceElementToFrontOfList(parentPsiElement, newElement);
        }
        return added;
    }

    @Nullable
    static PsiElement createNameElement(@NotNull GradleDslElement context, @NotNull String name) {
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(context);
        if (factory == null) {
            return null;
        }
        String str = name + " = 1";
        GrExpression expression = factory.createExpressionFromText((CharSequence)str);
        assert (expression instanceof GrAssignmentExpression);
        return ((GrAssignmentExpression)expression).getLValue();
    }

    static void maybeUpdateName(@NotNull GradleDslElement element) {
        PsiNamedElement newElement;
        PsiElement oldName = element.getNameElement().getNamedPsiElement();
        String newName2 = element.getNameElement().getUnsavedName();
        if (newName2 == null || oldName == null) {
            return;
        }
        if (oldName instanceof PsiNamedElement) {
            PsiNamedElement namedElement = (PsiNamedElement)oldName;
            namedElement.setName(newName2);
            newElement = namedElement;
        } else {
            PsiElement psiElement = GroovyDslUtil.createNameElement(element, newName2);
            if (psiElement == null) {
                throw new IllegalStateException("Can't create new GrExpression for name element");
            }
            newElement = oldName.replace(psiElement);
        }
        element.getNameElement().commitNameChange((PsiElement)newElement);
    }

    @Nullable
    static PsiElement findLastPsiElementIn(@NotNull GradleDslElement startElement) {
        PsiElement psiElement = startElement.getPsiElement();
        if (psiElement != null) {
            return psiElement;
        }
        for (GradleDslElement element : Lists.reverse(new ArrayList<GradleDslElement>(startElement.getChildren()))) {
            PsiElement psi;
            if (element == null || (psi = GroovyDslUtil.findLastPsiElementIn(element)) == null) continue;
            return psi;
        }
        return null;
    }

    @Nullable
    static PsiElement getPsiElementForAnchor(@NotNull PsiElement parent, @Nullable GradleDslElement dslAnchor) {
        PsiElement anchorAfter;
        PsiElement psiElement = anchorAfter = dslAnchor == null ? null : GroovyDslUtil.findLastPsiElementIn(dslAnchor);
        if (anchorAfter == null && parent instanceof GrClosableBlock) {
            return GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent);
        }
        while (anchorAfter != null && !(anchorAfter instanceof PsiFile) && anchorAfter.getParent() != parent) {
            anchorAfter = anchorAfter.getParent();
        }
        return anchorAfter instanceof PsiFile ? (parent instanceof GrClosableBlock ? GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent) : null) : anchorAfter;
    }

    private static PsiElement adjustForCloseableBlock(@NotNull GrClosableBlock block) {
        PsiElement element = block.getFirstChild();
        if (element != null) {
            element = element.getNextSibling();
        }
        while (element != null && (element = element.getNextSibling()) != null && (Strings.isNullOrEmpty((String)element.getText()) || element.getText().matches("[\\t ]+"))) {
        }
        return element == null ? null : element.getPrevSibling();
    }

    static boolean needToCreateParent(@NotNull GradleDslElement element) {
        GradleDslElement parent = element.getParent();
        return parent != null && parent.getPsiElement() == null;
    }

    static boolean hasNewLineBetween(@NotNull PsiElement start, @NotNull PsiElement end) {
        assert (start.getParent() == end.getParent() && start.getStartOffsetInParent() <= end.getStartOffsetInParent());
        for (PsiElement element = start; element != end; element = element.getNextSibling()) {
            if (!element.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) continue;
            return true;
        }
        return false;
    }

    static List<GradleReferenceInjection> findInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement, boolean includeUnresolved) {
        GrStringInjection[] grStringInjections;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (psiElement instanceof GrReferenceExpression || psiElement instanceof GrIndexProperty) {
            String text = psiElement.getText();
            GradleDslElement element = context.resolveReference(text, true);
            return ImmutableList.of((Object)new GradleReferenceInjection(context, element, psiElement, text));
        }
        if (!(psiElement instanceof GrString)) {
            return Collections.emptyList();
        }
        ArrayList injections = Lists.newArrayList();
        for (GrStringInjection injection : grStringInjections = ((GrString)psiElement).getInjections()) {
            String name;
            if (injection == null || (name = GroovyDslUtil.getInjectionName(injection)) == null) continue;
            GradleDslElement referenceElement = context.resolveReference(name, true);
            if (!includeUnresolved && referenceElement == null) continue;
            injections.add(new GradleReferenceInjection(context, referenceElement, (PsiElement)injection, name));
        }
        return injections;
    }

    static void createAndAddClosure(@NotNull GradleDslClosure closure, @NotNull GradleDslElement element) {
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
        GrClosableBlock block = factory.createClosureFromText("{ }");
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        PsiElement newElement = psiElement.addAfter((PsiElement)block, psiElement.getLastChild());
        closure.setPsiElement(newElement);
        closure.applyChanges();
        element.setParsedClosureElement(closure);
        element.setNewClosureElement(null);
    }

    static void deletePsiElement(@NotNull GradleDslElement context, @Nullable PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        psiElement.delete();
        GroovyDslUtil.maybeDeleteIfEmpty(parent, context);
        GroovyDslUtil.removePsiIfInvalid(context);
    }
}

