/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GroovyDslWriter
implements GradleDslWriter {
    @Override
    public PsiElement moveDslElement(@NotNull GradleDslElement element) {
        GradleDslElement anchorAfter = element.getAnchor();
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement());
        if (psiElement == null) {
            return null;
        }
        PsiElement parentPsiElement = GroovyDslUtil.getParentPsi(element);
        if (parentPsiElement == null) {
            return null;
        }
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        PsiElement lineTerminator = factory.createLineTerminator(1);
        PsiElement toReplace = parentPsiElement.addAfter(lineTerminator, anchor);
        PsiElement e = element.getPsiElement();
        while (!(e.getParent() instanceof GroovyFile) && !(e.getParent() instanceof GrClosableBlock)) {
            if (e.getParent() == null) {
                e = element.getPsiElement();
                break;
            }
            e = e.getParent();
        }
        PsiElement treeCopy = e.copy();
        PsiElement newTree = toReplace.replace(treeCopy);
        e.delete();
        element.setPsiElement(newTree);
        return element.getPsiElement();
    }

    @Override
    public PsiElement createDslElement(@NotNull GradleDslElement element) {
        PsiElement addedElement;
        PsiElement parentPsiElement;
        GradleDslElement anchorAfter = element.getAnchor();
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement());
        if (psiElement != null) {
            return psiElement;
        }
        if (GroovyDslUtil.isNewEmptyBlockElement(element)) {
            return null;
        }
        if (GroovyDslUtil.needToCreateParent(element)) {
            anchorAfter = null;
        }
        if ((parentPsiElement = GroovyDslUtil.getParentPsi(element)) == null) {
            return null;
        }
        Project project = parentPsiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        String statementText = GroovyDslUtil.maybeTrimForParent(element.getNameElement(), element.getParent());
        assert (statementText != null && !statementText.isEmpty()) : "Element name can't be null! This will cause statement creation to error.";
        if (element.isBlockElement()) {
            statementText = statementText + " {\n}\n";
        } else if (element.shouldUseAssignment()) {
            if (element.getElementType() == PropertyType.REGULAR) {
                statementText = statementText + " = 'abc'";
            } else if (element.getElementType() == PropertyType.VARIABLE) {
                statementText = "def " + statementText + " = 'abc'";
            }
        } else {
            statementText = statementText + " \"abc\", \"xyz\"";
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)statementText);
        if (statement instanceof GrApplicationStatement) {
            ((GrApplicationStatement)statement).getArgumentList().delete();
        } else if (statement instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
            if (assignment.getRValue() != null) {
                assignment.getRValue().delete();
            }
        } else if (statement instanceof GrVariableDeclaration) {
            GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)statement;
            for (GrVariable var : variableDeclaration.getVariables()) {
                if (var.getInitializerGroovy() == null) continue;
                var.getInitializerGroovy().delete();
                ASTNode node = var.getNode();
                node.addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", var.getLastChild().getNode().getTreeNext());
            }
        }
        PsiElement lineTerminator = factory.createLineTerminator(1);
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        if (parentPsiElement instanceof GroovyFile) {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
            if (element.isBlockElement() && !PsiImplUtil.isWhiteSpaceOrNls((PsiElement)addedElement.getPrevSibling())) {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            }
            parentPsiElement.addBefore(lineTerminator, addedElement);
        } else if (parentPsiElement instanceof GrClosableBlock) {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
            if (anchorAfter != null) {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            } else {
                parentPsiElement.addAfter(lineTerminator, addedElement);
                GrClosableBlock parentBlock = (GrClosableBlock)parentPsiElement;
                if (parentBlock.getRBrace() != null && !GroovyDslUtil.hasNewLineBetween(parentBlock.getLBrace(), parentBlock.getRBrace())) {
                    parentPsiElement.addBefore(lineTerminator, addedElement);
                }
            }
        } else {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
            parentPsiElement.addBefore(lineTerminator, addedElement);
        }
        if (element.isBlockElement()) {
            GrClosableBlock closableBlock = GroovyDslUtil.getClosableBlock(addedElement);
            if (closableBlock != null) {
                element.setPsiElement((PsiElement)closableBlock);
            }
        } else if (addedElement instanceof GrApplicationStatement || addedElement instanceof GrAssignmentExpression || addedElement instanceof GrVariableDeclaration) {
            element.setPsiElement(addedElement);
        }
        return element.getPsiElement();
    }

    @Override
    public void deleteDslElement(@NotNull GradleDslElement element) {
        GroovyDslUtil.deletePsiElement(element, element.getPsiElement());
    }

    @Override
    public PsiElement createDslLiteral(@NotNull GradleDslLiteral literal) {
        return this.createDslLiteralOrReference(literal);
    }

    @Override
    public void applyDslLiteral(@NotNull GradleDslLiteral literal) {
        GroovyDslUtil.applyDslLiteralOrReference(literal);
    }

    @Override
    public void deleteDslLiteral(@NotNull GradleDslLiteral literal) {
        GroovyDslUtil.deletePsiElement(literal, literal.getExpression());
    }

    @Override
    public PsiElement createDslMethodCall(@NotNull GradleDslMethodCall methodCall) {
        GrExpression[] expressionArguments;
        String statementText;
        PsiElement parentPsiElement;
        PsiElement psiElement = methodCall.getPsiElement();
        if (psiElement != null && psiElement.isValid()) {
            return psiElement;
        }
        if (methodCall.getParent() == null) {
            return null;
        }
        GradleDslElement anchorAfter = methodCall.getAnchor();
        if (GroovyDslUtil.needToCreateParent(methodCall)) {
            anchorAfter = null;
        }
        if ((parentPsiElement = methodCall.getParent().create()) == null) {
            return null;
        }
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrStatement statement = factory.createStatementFromText((CharSequence)(statementText = (!methodCall.getFullName().isEmpty() ? GroovyDslUtil.maybeTrimForParent(methodCall.getNameElement(), methodCall.getParent()) + " " : "") + GroovyDslUtil.maybeTrimForParent(GradleNameElement.fake(methodCall.getMethodName()), methodCall.getParent()) + "()"));
        PsiElement addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
        if (addedElement instanceof GrApplicationStatement && (expressionArguments = ((GrApplicationStatement)addedElement).getArgumentList().getExpressionArguments()).length == 1 && expressionArguments[0] instanceof GrMethodCallExpression) {
            methodCall.setPsiElement((PsiElement)expressionArguments[0]);
            if (expressionArguments[0] instanceof GrMethodCallExpression) {
                GrMethodCallExpression methodCallExpression = (GrMethodCallExpression)expressionArguments[0];
                methodCall.getArgumentsElement().setPsiElement((PsiElement)methodCallExpression.getArgumentList());
            }
            return methodCall.getPsiElement();
        }
        if (addedElement instanceof GrMethodCallExpression) {
            methodCall.setPsiElement(addedElement);
            methodCall.getArgumentsElement().setPsiElement((PsiElement)((GrMethodCallExpression)addedElement).getArgumentList());
            if (methodCall.getUnsavedClosure() != null) {
                GroovyDslUtil.createAndAddClosure(methodCall.getUnsavedClosure(), methodCall);
            }
            return methodCall.getPsiElement();
        }
        return null;
    }

    @Override
    public void applyDslMethodCall(@NotNull GradleDslMethodCall element) {
        GroovyDslUtil.maybeUpdateName(element);
        element.getArgumentsElement().applyChanges();
        if (element.getUnsavedClosure() != null) {
            GroovyDslUtil.createAndAddClosure(element.getUnsavedClosure(), element);
        }
    }

    @Override
    public PsiElement createDslExpressionList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement psiElement = expressionList.getPsiElement();
        if (psiElement == null) {
            if (expressionList.getParent() instanceof GradleDslExpressionMap) {
                return GroovyDslUtil.createNamedArgumentList(expressionList);
            }
        } else {
            return psiElement;
        }
        psiElement = this.createDslElement(expressionList);
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap) {
            return psiElement;
        }
        if (psiElement instanceof GrAssignmentExpression || psiElement instanceof GrVariableDeclaration) {
            GrExpression emptyMap = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)"[]");
            PsiElement element = psiElement.addAfter((PsiElement)emptyMap, psiElement.getLastChild());
            expressionList.setPsiElement(element);
            return expressionList.getPsiElement();
        }
        if (psiElement instanceof GrArgumentList) {
            if (expressionList.getExpressions().size() == 1 && ((GrArgumentList)psiElement).getAllArguments().length == 1 && !expressionList.isAppendToArgumentListWithOneElement()) {
                expressionList.setPsiElement(null);
                psiElement = this.createDslElement(expressionList);
            } else {
                return psiElement;
            }
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                expressionList.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public void applyDslExpressionList(@NotNull GradleDslExpressionList expressionList) {
        GroovyDslUtil.maybeUpdateName(expressionList);
    }

    @Override
    public PsiElement createDslExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement psiElement;
        if (expressionMap.getPsiElement() != null) {
            return expressionMap.getPsiElement();
        }
        if (expressionMap.getElementType() == PropertyType.DERIVED && expressionMap.isLiteralMap()) {
            psiElement = GroovyDslUtil.createDerivedMap(expressionMap);
        } else {
            if (expressionMap.getElementType() == PropertyType.DERIVED && expressionMap.getParent() instanceof GradleDslExpressionList && expressionMap.getParent().getParent() instanceof GradleDslMethodCall) {
                return expressionMap.getParent() == null ? null : expressionMap.getParent().create();
            }
            psiElement = this.createDslElement(expressionMap);
        }
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap || psiElement instanceof GrArgumentList || psiElement instanceof GrNamedArgument) {
            return psiElement;
        }
        if (psiElement instanceof GrAssignmentExpression || psiElement instanceof GrVariableDeclaration) {
            GrExpression emptyMap = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)"[:]");
            PsiElement element = psiElement.addAfter((PsiElement)emptyMap, psiElement.getLastChild());
            expressionMap.setPsiElement(element);
            return element;
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                expressionMap.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public void applyDslExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        GroovyDslUtil.maybeUpdateName(expressionMap);
    }

    @Override
    public void applyDslPropertiesElement(@NotNull GradlePropertiesDslElement element) {
        GroovyDslUtil.maybeUpdateName(element);
    }

    private PsiElement createDslLiteralOrReference(@NotNull GradleDslSettableExpression expression) {
        GradleDslElement parent = expression.getParent();
        if (parent instanceof GradleDslExpressionMap) {
            return GroovyDslUtil.processMapElement(expression);
        }
        if (parent instanceof GradleDslExpressionList) {
            return GroovyDslUtil.processListElement(expression);
        }
        return this.createDslElement(expression);
    }
}

