/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.GradleEditorNotificationListener;
import com.android.tools.idea.gradle.editor.action.GradleEntityHelpAction;
import com.android.tools.idea.gradle.editor.action.GradleEntityNavigateAction;
import com.android.tools.idea.gradle.editor.action.GradleEntityRemoveAction;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDefinitionValueLocationAware;
import com.android.tools.idea.gradle.editor.metadata.StdGradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.ui.GradleEditorCellComponent;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityTable;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityTableModel;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityUi;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityUiRegistry;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorCellComponentImpl
extends JBPanel
implements GradleEditorCellComponent,
ActionListener {
    private final JLabel myLabel = new JLabel();
    private final GridBag myConstraints = new GridBag().anchor(17);
    private final JBPanel myToolBarPanel = new JBPanel(new GridBagLayout()){

        public void paint(Graphics g) {
            super.paint(g);
            GradleEditorCellComponentImpl.this.myToolBarPanelBounds = this.getBounds();
        }
    };
    private final JBPanel myPayloadWrapper = new JBPanel(new GridBagLayout()){

        public Dimension getPreferredSize() {
            return GradleEditorCellComponentImpl.this.myPreferredSize == null ? super.getPreferredSize() : GradleEditorCellComponentImpl.this.myPreferredSize;
        }

        public Dimension getMinimumSize() {
            return GradleEditorCellComponentImpl.this.myPreferredSize == null ? super.getMinimumSize() : GradleEditorCellComponentImpl.this.myPreferredSize;
        }

        public Dimension getMaximumSize() {
            return GradleEditorCellComponentImpl.this.myPreferredSize == null ? super.getMaximumSize() : GradleEditorCellComponentImpl.this.myPreferredSize;
        }
    };
    private final Timer myTimer = new Timer(300, this);
    private final ActionButton myHelpButton = GradleEditorCellComponentImpl.button(new GradleEntityHelpAction());
    private final ActionButton myNavigateButton = GradleEditorCellComponentImpl.button(new GradleEntityNavigateAction());
    private final ActionButton myRemoveButton = GradleEditorCellComponentImpl.button(new GradleEntityRemoveAction());
    @NotNull
    private final GradleEditorEntityTable myTable;
    @Nullable
    private List<GradleEditorEntityUi<?>> myUis;
    @Nullable
    private Component myLastComponentUnderMouse;
    @Nullable
    private Rectangle myToolBarPanelBounds;
    @Nullable
    private Dimension myPreferredSize;
    private int myRow;
    private boolean myEditor;

    public GradleEditorCellComponentImpl(@NotNull GradleEditorEntityTable table2) {
        super((LayoutManager)new GridBagLayout());
        this.myTable = table2;
        this.add((Component)this.myPayloadWrapper, this.myConstraints);
        this.myToolBarPanel.add((Component)this.myHelpButton, (Object)this.myConstraints);
        this.myToolBarPanel.add((Component)this.myNavigateButton, (Object)this.myConstraints);
        this.myToolBarPanel.add((Component)this.myRemoveButton, (Object)this.myConstraints);
        this.myToolBarPanel.setVisible(false);
        this.add((Component)this.myToolBarPanel, new GridBag().anchor(17).insets(0, 16, 0, 0));
        this.add(this.myLabel, new GridBag().weightx(1.0).fillCellHorizontally());
        this.myConstraints.weightx(1.0);
    }

    @NotNull
    private static ActionButton button(@NotNull AnAction action2) {
        return new ActionButton(action2, action2.getTemplatePresentation().clone(), "GRADLE_EDITOR_TABLE", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    @Override
    @NotNull
    public JComponent bind(@NotNull JTable table2, @Nullable Object value2, @NotNull Project project, int row, int column, boolean editing, boolean selected, boolean focus) {
        this.myUis = null;
        this.myRow = -1;
        this.myEditor = editing;
        if (!(value2 instanceof GradleEditorEntity)) {
            this.myLabel.setText(value2 == null ? "<null>" : value2.toString());
            return this.myLabel;
        }
        GradleEditorEntity entity = (GradleEditorEntity)value2;
        GradleEditorEntityUiRegistry registry = (GradleEditorEntityUiRegistry)ServiceManager.getService(GradleEditorEntityUiRegistry.class);
        this.myUis = registry.getEntityUis(entity);
        this.myRow = row;
        JComponent component = null;
        for (GradleEditorEntityUi<?> ui : this.myUis) {
            component = ui.getComponent(component, table2, entity, project, editing, selected, focus, false, row, column);
        }
        this.myLabel.setText(" ");
        this.myPayloadWrapper.removeAll();
        if (editing) {
            this.myToolBarPanel.setVisible(true);
        }
        assert (component != null);
        Dimension size = component.getPreferredSize();
        JComponent component2 = null;
        for (GradleEditorEntityUi<?> ui : this.myUis) {
            component2 = ui.getComponent(component2, table2, entity, project, !editing, selected, focus, true, row, column);
        }
        assert (component2 != null);
        Dimension size2 = component2.getPreferredSize();
        this.myPreferredSize = new Dimension(Math.max(size.width, size2.width), Math.max(size.height, size2.height));
        this.myHelpButton.setVisible(!Strings.isNullOrEmpty((String)entity.getHelpId()));
        this.myNavigateButton.setVisible(entity instanceof GradleEntityDefinitionValueLocationAware && ((GradleEntityDefinitionValueLocationAware)((Object)entity)).getDefinitionValueLocation() != null);
        this.myRemoveButton.setVisible(entity.getMetaData().contains(StdGradleEditorEntityMetaData.REMOVABLE));
        this.myPayloadWrapper.add((Component)component, (Object)this.myConstraints);
        Color backgroundColor = entity.getMetaData().contains(StdGradleEditorEntityMetaData.INJECTED) ? GradleEditorUiConstants.INJECTED_BACKGROUND_COLOR : (entity.getMetaData().contains(StdGradleEditorEntityMetaData.OUTGOING) ? GradleEditorUiConstants.OUTGOING_BACKGROUND_COLOR : GradleEditorUiConstants.BACKGROUND_COLOR);
        List panels = UIUtil.findComponentsOfType((JComponent)((Object)this), JPanel.class);
        for (JPanel panel2 : panels) {
            panel2.setBackground(backgroundColor);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getValue(@NotNull Project project) {
        GradleEditorEntityTableModel model2 = this.myTable.getModel();
        if (this.myUis == null || this.myRow < 0 || this.myRow >= model2.getRowCount()) {
            return null;
        }
        final GradleEditorEntity entity = (GradleEditorEntity)model2.getValueAt(this.myRow, 0);
        GradleEditorNotificationListener publisher = (GradleEditorNotificationListener)project.getMessageBus().syncPublisher(GradleEditorNotificationListener.TOPIC);
        publisher.beforeChange();
        try {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (GradleEditorEntityUi ui : GradleEditorCellComponentImpl.this.myUis) {
                        ui.flush(entity);
                    }
                }
            });
        }
        finally {
            publisher.afterChange();
        }
        return entity;
    }

    private void repaintMe() {
        int row = this.myTable.getRowByComponent(this);
        if (row >= 0) {
            this.myTable.repaintRows(row, row, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myEditor) {
            return;
        }
        this.myToolBarPanel.setVisible(true);
        this.myTimer.stop();
        this.repaintMe();
    }

    @Override
    @Nullable
    public Rectangle onMouseMove(@NotNull MouseEvent event) {
        MouseEvent e;
        Point p;
        if (this.myEditor) {
            return null;
        }
        if (!this.myToolBarPanel.isVisible() && !this.myTimer.isRunning()) {
            this.onMouseEntered(event);
            return null;
        }
        int row = this.myTable.getRowByComponent(this);
        if (row < 0) {
            return null;
        }
        int topY = 0;
        for (int i2 = 0; i2 < row; ++i2) {
            topY += this.myTable.getRowHeight(i2);
        }
        this.setBounds(0, 0, this.myTable.getWidth(), this.myTable.getRowHeight(row));
        Point pointInCurrentControl = new Point(event.getX(), event.getY() - topY);
        Component c = SwingUtilities.getDeepestComponentAt((Component)((Object)this), pointInCurrentControl.x, pointInCurrentControl.y);
        boolean dirty = false;
        if (this.myLastComponentUnderMouse != null && this.myLastComponentUnderMouse != c) {
            p = SwingUtilities.convertPoint((Component)((Object)this), pointInCurrentControl, this.myLastComponentUnderMouse);
            e = new MouseEvent(c, 505, event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
            this.myLastComponentUnderMouse.dispatchEvent(e);
            dirty = true;
            Cursor cursor = this.myLastComponentUnderMouse.getCursor();
            if (cursor != null && cursor == this.myTable.getCursor()) {
                this.myTable.setCursor(null);
            }
        }
        if (c != this.myLastComponentUnderMouse) {
            p = SwingUtilities.convertPoint((Component)((Object)this), pointInCurrentControl, c);
            e = new MouseEvent(c, 504, event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
            c.dispatchEvent(e);
            dirty = true;
            this.myTable.setCursor(c.getCursor());
        }
        this.myLastComponentUnderMouse = c;
        Point tableLocationOnScreen = this.myTable.getLocationOnScreen();
        if (!dirty) {
            return null;
        }
        if (this.myToolBarPanelBounds == null) {
            return new Rectangle(tableLocationOnScreen.x, tableLocationOnScreen.y + topY, this.myTable.getWidth(), this.myTable.getRowHeight(row));
        }
        return new Rectangle(tableLocationOnScreen.x + this.myToolBarPanelBounds.x, tableLocationOnScreen.y + topY + this.myToolBarPanelBounds.y, this.myToolBarPanelBounds.width, this.myToolBarPanelBounds.height);
    }

    @Override
    @Nullable
    public Rectangle onMouseEntered(@NotNull MouseEvent event) {
        if (!this.myEditor) {
            this.myTimer.restart();
        }
        return null;
    }

    @Override
    @Nullable
    public Rectangle onMouseExited() {
        if (!this.myEditor) {
            this.myTable.setCursor(null);
            this.myToolBarPanel.setVisible(false);
            this.myTimer.stop();
            this.repaintMe();
        }
        return null;
    }

    public String toString() {
        return String.valueOf(System.identityHashCode(this));
    }
}

