/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.AbstractSimpleGradleEditorEntity;
import com.android.tools.idea.gradle.editor.metadata.StdGradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.ui.GradleEditorComboBox;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityUi;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.android.tools.idea.gradle.editor.ui.ReferencedValuesGradleEditorComponent;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=100)
public class SimpleGradleEntityUi
implements GradleEditorEntityUi<AbstractSimpleGradleEditorEntity> {
    private final MyComponent myRenderer = new MyComponent();
    private final MyComponent myEditor = new MyComponent();
    private final MyComponent mySizeComponent = new MyComponent();

    @Override
    @NotNull
    public Class<AbstractSimpleGradleEditorEntity> getTargetEntityClass() {
        return AbstractSimpleGradleEditorEntity.class;
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable JComponent component, @NotNull JTable table2, @NotNull AbstractSimpleGradleEditorEntity entity, @NotNull Project project, boolean editing, boolean isSelected, boolean hasFocus, boolean sizeOnly, int row, int column) {
        MyComponent c;
        if (component != null) {
            return component;
        }
        if (sizeOnly) {
            c = this.mySizeComponent;
            c.editorSimpleValue.setSize(new Dimension(table2.getSize().width, table2.getRowHeight(row)));
        } else {
            c = editing ? this.myEditor : this.myRenderer;
        }
        c.bind(entity, project, table2, editing);
        c.getPreferredSize();
        return c;
    }

    @Override
    @Nullable
    public String flush(@NotNull AbstractSimpleGradleEditorEntity entity) {
        if (!this.myEditor.editorSimpleValue.isVisible()) {
            return null;
        }
        Object selected = this.myEditor.editorSimpleValue.getEditor().getItem();
        if (selected != null) {
            return entity.changeValue(selected.toString());
        }
        return null;
    }

    private static class MyComponent
    extends JBPanel {
        private final JBLabel myName = new JBLabel();
        private final JBLabel mySimpleValue = new JBLabel();
        private final ReferencedValuesGradleEditorComponent myRefValue = new ReferencedValuesGradleEditorComponent();
        private final DefaultComboBoxModel myEditorSimpleValueModel = new DefaultComboBoxModel();
        final GradleEditorComboBox editorSimpleValue = new GradleEditorComboBox(this.myEditorSimpleValueModel);
        @Nullable
        private WeakReference<JTable> myTableRef;

        MyComponent() {
            super((LayoutManager)new GridBagLayout());
            GridBag constraints = new GridBag().anchor(17);
            this.add((Component)this.myName, constraints);
            this.add((Component)((Object)this.editorSimpleValue), constraints);
            this.add((Component)this.mySimpleValue, constraints.insets(0, 8, 0, 0));
            this.add((Component)((Object)this.myRefValue), constraints);
            this.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
            this.editorSimpleValue.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
            this.editorSimpleValue.setEditable(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Component editorComponent;
                    if (myTableRef == null) {
                        return;
                    }
                    JTable table2 = (JTable)myTableRef.get();
                    if (table2 == null) {
                        return;
                    }
                    Component c = SwingUtilities.getDeepestComponentAt((Component)((Object)this), e.getX(), e.getY());
                    if ((c == null || c != myRefValue && c != editorSimpleValue) && (editorComponent = table2.getEditorComponent()) != null && UIUtil.isAncestor((Component)editorComponent, (Component)((Object)this))) {
                        table2.getCellEditor().stopCellEditing();
                    }
                }
            });
        }

        public void bind(@NotNull AbstractSimpleGradleEditorEntity entity, @NotNull Project project, @NotNull JTable table2, boolean editing) {
            this.myTableRef = new WeakReference<JTable>(table2);
            this.myName.setText(entity.getName() + ":");
            String currentValue = entity.getCurrentValue();
            this.mySimpleValue.setText(currentValue);
            this.myRefValue.bind(project, entity.getDefinitionValueSourceBindings());
            boolean simpleValue = !currentValue.isEmpty() && (entity.getDefinitionValueSourceBindings().size() == 1 || entity.getMetaData().contains(StdGradleEditorEntityMetaData.READ_ONLY));
            this.mySimpleValue.setVisible(!editing && simpleValue);
            this.editorSimpleValue.setVisible(editing && simpleValue);
            this.editorSimpleValue.setTable(table2);
            this.myRefValue.setVisible(!simpleValue);
            if (editing && simpleValue) {
                this.myEditorSimpleValueModel.removeAllElements();
                List<String> versions = entity.getValueManager().hintAvailableVersions();
                if (versions == null) {
                    this.myEditorSimpleValueModel.addElement(currentValue);
                } else {
                    boolean currentValueIsInAvailableList = versions.contains(currentValue);
                    if (!currentValueIsInAvailableList) {
                        this.myEditorSimpleValueModel.addElement(currentValue);
                    }
                    for (String version2 : versions) {
                        this.myEditorSimpleValueModel.addElement(version2);
                    }
                }
            }
            this.editorSimpleValue.setSelectedItem(currentValue);
        }
    }
}

