/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.android.tools.idea.gradle.project.sync.Modules;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.Serializable;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleDependency
implements Serializable {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myModuleId;
    @Nullable
    private final String myScope;
    private final boolean myExported;

    @Nullable
    public static JavaModuleDependency copy(IdeaProject project, IdeaModuleDependency original) {
        IdeaModule targetModule = null;
        for (IdeaModule module : project.getModules()) {
            if (!module.getName().equals(original.getTargetModuleName())) continue;
            targetModule = module;
        }
        if (targetModule != null && StringUtil.isNotEmpty((String)targetModule.getName())) {
            File projectFolder;
            String scope = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope = originalScope.getScope();
            }
            GradleProject gradleProject = targetModule.getGradleProject();
            try {
                projectFolder = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
            }
            catch (UnsupportedMethodException ex) {
                GradleProject rootGradleProject = gradleProject;
                while (rootGradleProject.getParent() != null) {
                    rootGradleProject = rootGradleProject.getParent();
                }
                projectFolder = rootGradleProject.getProjectDirectory();
            }
            String moduleId = Modules.createUniqueModuleId(projectFolder, gradleProject.getPath());
            return new JavaModuleDependency(targetModule.getName(), moduleId, scope, original.getExported());
        }
        return null;
    }

    public JavaModuleDependency(@NotNull String moduleName, @NotNull String moduleId, @Nullable String scope, boolean exported) {
        this.myModuleName = moduleName;
        this.myModuleId = moduleId;
        this.myScope = scope;
        this.myExported = exported;
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public String getModuleId() {
        return this.myModuleId;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    public boolean isExported() {
        return this.myExported;
    }
}

