/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.android.java.model.JavaLibrary;
import com.android.tools.idea.gradle.model.java.GradleModuleVersionImpl;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewJarLibraryDependencyFactory {
    @Nullable
    public JarLibraryDependency create(@NotNull JavaLibrary original, @Nullable String scope) {
        File binaryPath = original.getJarFile();
        if (binaryPath == null) {
            return null;
        }
        boolean resolved = JarLibraryDependency.isResolved(binaryPath.getName());
        String name = JarLibraryDependency.getDependencyName(binaryPath, resolved);
        GradleModuleVersionImpl version2 = null;
        if (resolved && original.getLibraryVersion() != null) {
            version2 = new GradleModuleVersionImpl(original.getLibraryVersion());
        }
        return new JarLibraryDependency(name, binaryPath, original.getSource(), original.getJavadoc(), scope, version2, resolved);
    }
}

