/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final long PROJECT_STRUCTURE_NOTIFICATION_RESHOW_TIMEOUT_MS = TimeUnit.DAYS.toMillis(30L);
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private static final ConcurrentMap<FileEditor, Disposable> ourDisposablePanels = new ConcurrentHashMap<FileEditor, Disposable>();
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final GradleSyncState mySyncState;

    public ProjectSyncStatusNotificationProvider(@NotNull GradleProjectInfo projectInfo, @NotNull GradleSyncState syncState) {
        this.myProjectInfo = projectInfo;
        this.mySyncState = syncState;
    }

    @NotNull
    public final Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @AnyThread
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor editor2, @NotNull Project project) {
        NotificationPanel.Type newPanelType = this.notificationPanelType();
        NotificationPanel panel2 = newPanelType.create(project, file, this.myProjectInfo);
        ProjectSyncStatusNotificationProvider.registerDisposablePanel(editor2, panel2);
        return panel2;
    }

    private static void registerDisposablePanel(@NotNull FileEditor editor2, @Nullable NotificationPanel panel2) {
        Disposable oldDisposablePanel;
        Disposable newDisposablePanel = panel2 instanceof Disposable ? (Disposable)panel2 : null;
        Disposable disposable = oldDisposablePanel = newDisposablePanel == null ? (Disposable)ourDisposablePanels.remove(editor2) : ourDisposablePanels.put(editor2, newDisposablePanel);
        if (oldDisposablePanel != null) {
            Disposer.dispose((Disposable)oldDisposablePanel);
        }
        if (newDisposablePanel != null) {
            try {
                Disposer.register((Disposable)newDisposablePanel, () -> ourDisposablePanels.remove(editor2, newDisposablePanel));
                Disposer.register((Disposable)editor2, (Disposable)newDisposablePanel);
            }
            catch (Throwable t) {
                Disposer.dispose((Disposable)newDisposablePanel);
                throw t;
            }
        }
    }

    @VisibleForTesting
    @NotNull
    NotificationPanel.Type notificationPanelType() {
        if (!this.myProjectInfo.isBuildWithGradle()) {
            return NotificationPanel.Type.NONE;
        }
        if (!this.mySyncState.areSyncNotificationsEnabled()) {
            return NotificationPanel.Type.NONE;
        }
        if (this.mySyncState.isSyncInProgress()) {
            return NotificationPanel.Type.IN_PROGRESS;
        }
        if (this.mySyncState.lastSyncFailed()) {
            return NotificationPanel.Type.FAILED;
        }
        ThreeState gradleSyncNeeded = this.mySyncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            return NotificationPanel.Type.SYNC_NEEDED;
        }
        return NotificationPanel.Type.NONE;
    }

    @VisibleForTesting
    static class ProjectStructureNotificationPanel
    extends NotificationPanel {
        ProjectStructureNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text, @NotNull Module module) {
            super(type, text);
            this.createActionLabel("Open Project Structure", () -> {
                ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)project);
                if (projectSettingsService instanceof AndroidProjectSettingsService) {
                    projectSettingsService.openModuleSettings(module);
                }
            });
            this.createActionLabel("Hide notification", () -> {
                PropertiesComponent.getInstance().setValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", Long.toString(System.currentTimeMillis()));
                this.setVisible(false);
            });
        }

        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            return color == null ? UIUtil.getPanelBackground() : color;
        }
    }

    private static class SyncProblemNotificationPanel
    extends IndexingSensitiveNotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            super(project, type, text);
            this.createActionLabel("Try Again", () -> GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_USER_TRY_AGAIN));
            this.createActionLabel("Open 'Build' View", () -> {
                ToolWindow tw = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.BUILD);
                if (tw != null && !tw.isActive()) {
                    tw.activate(null, false);
                }
            });
            this.createActionLabel("Show Log in " + ShowFilePathAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                ShowFilePathAction.openFile((File)logFile);
            });
        }
    }

    private static class StaleGradleModelNotificationPanel
    extends IndexingSensitiveNotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            super(project, type, text);
            if (GradleProjects.containsExternalCppProjects(project)) {
                project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, (Object)true);
            }
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_USER_STALE_CHANGES));
        }
    }

    @VisibleForTesting
    static class IndexingSensitiveNotificationPanel
    extends NotificationPanel
    implements Disposable {
        IndexingSensitiveNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            this(project, type, text, DumbService.getInstance((Project)project));
        }

        @VisibleForTesting
        IndexingSensitiveNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text, @NotNull DumbService dumbService) {
            super(type, text);
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
            connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    this.setVisible(false);
                }

                public void exitDumbMode() {
                    this.setVisible(true);
                }
            });
            this.setVisible(!dumbService.isDumb());
        }

        public void dispose() {
        }
    }

    @VisibleForTesting
    static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text) {
            this.type = type;
            this.setText(text);
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file, @NotNull GradleProjectInfo projectInfo) {
                    if (ProjectStructureConfigurable.isNewPsdEnabled() && System.currentTimeMillis() - Long.parseLong(PropertiesComponent.getInstance().getValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", "0")) > PROJECT_STRUCTURE_NOTIFICATION_RESHOW_TIMEOUT_MS) {
                        if (!projectInfo.isBuildWithGradle()) {
                            return null;
                        }
                        if (!file.getName().equals("build.gradle")) {
                            return null;
                        }
                        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                        if (module == null) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                module = ModuleManager.getInstance((Project)project).getModules()[0];
                            } else {
                                return null;
                            }
                        }
                        return new ProjectStructureNotificationPanel(project, this, "Configure project in Project Structure dialog.", module);
                    }
                    return null;
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file, @NotNull GradleProjectInfo projectInfo) {
                    return new NotificationPanel(this, "Gradle project sync in progress...");
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file, @NotNull GradleProjectInfo projectInfo) {
                    String text = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
                    return new SyncProblemNotificationPanel(project, this, text);
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file, @NotNull GradleProjectInfo projectInfo) {
                    boolean buildFilesModified = GradleFiles.getInstance(project).areExternalBuildFilesModified();
                    String text = (buildFilesModified ? "External build files" : "Gradle files") + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.";
                    return new StaleGradleModelNotificationPanel(project, this, text);
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GradleProjectInfo var3);
        }
    }
}

