/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.npw.project;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class GradleAndroidModuleTemplate
implements AndroidModuleTemplate {
    @Nullable
    private File myModuleRoot;
    @Nullable
    private File mySrcRoot;
    @Nullable
    private File myTestRoot;
    @NotNull
    private List<File> myResDirectories = Collections.emptyList();
    @Nullable
    private File myAidlRoot;
    @Nullable
    private File myManifestDirectory;

    @Override
    @Nullable
    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    @Nullable
    private static File appendPackageToRoot(@Nullable File root, @Nullable String packageName) {
        if (root == null || packageName == null) {
            return root;
        }
        String packagePath = packageName.replace('.', File.separatorChar);
        return new File(root, packagePath);
    }

    @Override
    @Nullable
    public File getSrcDirectory(@Nullable String packageName) {
        return GradleAndroidModuleTemplate.appendPackageToRoot(this.mySrcRoot, packageName);
    }

    @Override
    @Nullable
    public File getTestDirectory(@Nullable String packageName) {
        return GradleAndroidModuleTemplate.appendPackageToRoot(this.myTestRoot, packageName);
    }

    @Override
    @NotNull
    public List<File> getResDirectories() {
        return this.myResDirectories;
    }

    @Override
    @Nullable
    public File getAidlDirectory(@Nullable String packageName) {
        return GradleAndroidModuleTemplate.appendPackageToRoot(this.myAidlRoot, packageName);
    }

    @Override
    @Nullable
    public File getManifestDirectory() {
        return this.myManifestDirectory;
    }

    public static NamedModuleTemplate createDummyTemplate() {
        return GradleAndroidModuleTemplate.createDefaultTemplateAt("", "");
    }

    public static NamedModuleTemplate createDefaultTemplateAt(@NotNull String projectPath, @NotNull String moduleName) {
        File moduleRoot = NewModuleModel.getModuleRoot(projectPath, moduleName);
        File baseSrcDir = new File(moduleRoot, "src");
        File baseFlavorDir = new File(baseSrcDir, "main");
        GradleAndroidModuleTemplate paths2 = new GradleAndroidModuleTemplate();
        paths2.myModuleRoot = moduleRoot;
        paths2.mySrcRoot = new File(baseFlavorDir, "java");
        paths2.myTestRoot = new File(baseSrcDir.getPath(), "androidTest" + File.separatorChar + "java");
        paths2.myResDirectories = ImmutableList.of((Object)new File(baseFlavorDir, "res"));
        paths2.myAidlRoot = new File(baseFlavorDir, "aidl");
        paths2.myManifestDirectory = baseFlavorDir;
        return new NamedModuleTemplate("main", paths2);
    }

    @NotNull
    private static List<SourceProvider> getSourceProviders(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        if (targetDirectory != null) {
            return IdeaSourceProvider.getSourceProvidersForFile(androidFacet, targetDirectory, androidFacet.getMainSourceProvider());
        }
        return IdeaSourceProvider.getAllSourceProviders(androidFacet);
    }

    @NotNull
    public static List<NamedModuleTemplate> getModuleTemplates(@NotNull Module module, @Nullable VirtualFile targetDirectory) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return Collections.emptyList();
        }
        ArrayList templates = Lists.newArrayList();
        for (SourceProvider sourceProvider : GradleAndroidModuleTemplate.getSourceProviders(facet, targetDirectory)) {
            GradleAndroidModuleTemplate paths2 = new GradleAndroidModuleTemplate();
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots.length > 0) {
                paths2.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
            }
            paths2.mySrcRoot = (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
            List testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
            if (!testsRoot.isEmpty()) {
                paths2.myTestRoot = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
            }
            paths2.myResDirectories = ImmutableList.copyOf((Collection)sourceProvider.getResDirectories());
            paths2.myAidlRoot = (File)Iterables.getFirst((Iterable)sourceProvider.getAidlDirectories(), null);
            paths2.myManifestDirectory = sourceProvider.getManifestFile().getParentFile();
            templates.add(new NamedModuleTemplate(sourceProvider.getName(), paths2));
        }
        return templates;
    }
}

