/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public enum BuildFileKeyType {
    STRING((Class)String.class, "''"){

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value2) {
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createLiteralFromValue((Object)value2.toString()));
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value2) {
            return "'" + BuildFileKey.escapeLiteralString(value2.toString()) + "'";
        }
    }
    ,
    INTEGER(Integer.class, "0"),
    INTEGER_OR_STRING((Class)String.class, "0"){

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value2) {
            String valueString = value2.toString();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)arg.getProject());
            if (BuildFileKeyType.isInteger(valueString)) {
                arg.replace((PsiElement)factory.createExpressionFromText((CharSequence)valueString));
            } else {
                arg.replace((PsiElement)factory.createLiteralFromValue(value2));
            }
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value2) {
            String valueString = value2.toString();
            if (BuildFileKeyType.isInteger(valueString)) {
                return valueString;
            }
            return "'" + BuildFileKey.escapeLiteralString(value2.toString()) + "'";
        }

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (!(arg instanceof GrLiteral)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object value2 = ((GrLiteral)arg).getValue();
            return value2 != null ? value2.toString() : null;
        }
    }
    ,
    BOOLEAN(Boolean.class, "false"),
    CLOSURE((Class)List.class, "{}"){

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value2) {
            return "{\n}";
        }
    }
    ,
    FILE((Class)File.class, "file('')"){

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (!(arg instanceof GrMethodCall)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            GrMethodCall call = (GrMethodCall)arg;
            if (!"file".equals(GradleGroovyFile.getMethodCallName(call))) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object path = GradleGroovyFile.getFirstLiteralArgumentValue(call);
            if (path == null) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            return new File(path.toString());
        }

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value2) {
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createStatementFromText((CharSequence)("file('" + BuildFileKeyType.getFilePath(value2, true) + "')")));
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value2) {
            return "file('" + BuildFileKeyType.getFilePath(value2, true) + "')";
        }
    }
    ,
    FILE_AS_STRING((Class)File.class, "''"){

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (!(arg instanceof GrLiteral)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object value2 = ((GrLiteral)arg).getValue();
            return value2 != null ? new File(value2.toString()) : null;
        }

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value2) {
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createLiteralFromValue((Object)BuildFileKeyType.getFilePath(value2, false)));
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value2) {
            return "'" + BuildFileKeyType.getFilePath(value2, true) + "'";
        }
    }
    ,
    REFERENCE((Class)String.class, "reference"){

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            return arg.getText();
        }
    };

    private final Class<?> myNativeType;
    private final String myDefaultValue;

    private BuildFileKeyType(Class<?> nativeType, String defaultValue) {
        this.myNativeType = nativeType;
        this.myDefaultValue = defaultValue;
    }

    @NotNull
    public Class<?> getNativeType() {
        return this.myNativeType;
    }

    @NotNull
    public String convertValueToExpression(@NotNull Object value2) {
        return value2.toString();
    }

    private static String getFilePath(Object value2, boolean escape2) {
        String path = FileUtil.toSystemIndependentName((String)((File)value2).getPath());
        return escape2 ? BuildFileKey.escapeLiteralString(path) : path;
    }

    @Nullable
    public Object getValue(@NotNull GroovyPsiElement arg) {
        if (!(arg instanceof GrLiteral)) {
            return GradleBuildFile.UNRECOGNIZED_VALUE;
        }
        return ((GrLiteral)arg).getValue();
    }

    public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value2) {
        arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createExpressionFromText((CharSequence)value2.toString()));
    }

    private static boolean isInteger(@NotNull String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class Constants {
        private static final String FILE_METHOD_CALL = "file";

        private Constants() {
        }
    }
}

