/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.BuildFileStatementFactory;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;

public class Dependency
extends BuildFileStatement {
    private static final Logger LOG = Logger.getInstance(Dependency.class);
    @NonNls
    private static final String FILE_TREE_BASE_DIR_PROPERTY = "dir";
    @NonNls
    private static final String FILE_TREE_INCLUDE_PATTERN_PROPERTY = "include";
    public Scope scope;
    public Type type;
    public Object data;
    public String extraClosure;

    public Dependency(@NotNull Scope scope, @NotNull Type type, @NotNull Object data, @Nullable String extraClosure) {
        this.scope = scope;
        this.type = type;
        this.data = data;
        this.extraClosure = extraClosure;
    }

    public Dependency(@NotNull Scope scope, @NotNull Type type, @NotNull Object data) {
        this(scope, type, data, null);
    }

    @Override
    @NotNull
    public List<PsiElement> getGroovyElements(@NotNull GroovyPsiElementFactory factory) {
        String extraGroovyCode;
        switch (this.type) {
            case EXTERNAL: {
                if (this.extraClosure != null) {
                    extraGroovyCode = "(" + Dependency.escapeAndQuote(this.data) + ")";
                    break;
                }
                extraGroovyCode = " " + Dependency.escapeAndQuote(this.data);
                break;
            }
            case MODULE: {
                extraGroovyCode = this.data instanceof Map ? " project(" + GradleGroovyFile.convertMapToGroovySource((Map)this.data) + ")" : " project(" + Dependency.escapeAndQuote(this.data) + ")";
                if (this.extraClosure == null) break;
                extraGroovyCode = "(" + extraGroovyCode.substring(1) + ")";
                break;
            }
            case FILES: {
                extraGroovyCode = " files(" + Dependency.escapeAndQuote(this.data) + ")";
                break;
            }
            case FILETREE: {
                extraGroovyCode = " fileTree(" + GradleGroovyFile.convertMapToGroovySource((Map)this.data) + ")";
                break;
            }
            default: {
                extraGroovyCode = "";
            }
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)(this.scope.getGroovyMethodCall() + extraGroovyCode));
        if (statement instanceof GrMethodCall && this.extraClosure != null) {
            statement.add((PsiElement)factory.createClosureFromText(this.extraClosure));
        }
        return ImmutableList.of((Object)statement);
    }

    @NotNull
    private static String escapeAndQuote(@Nullable Object data) {
        if (data == null) {
            return "''";
        }
        String stringContent = data.toString();
        boolean gstring = false;
        int i2 = stringContent.indexOf(36);
        while (i2 >= 0 && i2 < stringContent.length()) {
            if (i2 <= 0 || stringContent.charAt(i2 - 1) != '\\') {
                gstring = true;
                break;
            }
            i2 = stringContent.indexOf(36, i2 + 1);
        }
        char quote = gstring ? (char)'\"' : '\'';
        return quote + BuildFileKey.escapeLiteralString(stringContent) + quote;
    }

    public boolean matches(@NotNull Dependency dependency) {
        List includes;
        if (this.equals(dependency)) {
            return true;
        }
        if (this.scope != dependency.scope) {
            return false;
        }
        String s1 = this.data.toString();
        String s2 = dependency.data.toString();
        switch (this.type) {
            default: {
                if (dependency.type != Type.MODULE) {
                    return false;
                }
                if (this.data instanceof Map) {
                    s1 = GradleGroovyFile.convertMapToGroovySource((Map)this.data).replaceAll("path: ':", "path: '");
                }
                if (dependency.data instanceof Map) {
                    s2 = GradleGroovyFile.convertMapToGroovySource((Map)dependency.data).replaceAll("path: ':", "path: '");
                }
                s1 = StringUtil.trimStart((String)s1, (String)":");
                s2 = StringUtil.trimStart((String)s2, (String)":");
                return s1.equals(s2);
            }
            case EXTERNAL: {
                if (dependency.type != Type.EXTERNAL) {
                    return false;
                }
                if (s1.startsWith("com.android.support:appcompat-v7") && s2.startsWith("com.android.support:support-v4")) {
                    return true;
                }
                String[] tokens1 = s1.split(":");
                String[] tokens2 = s2.split(":");
                if (tokens1.length < 2 || tokens2.length < 2) {
                    return false;
                }
                return tokens1[0].equals(tokens2[0]) && tokens1[1].equals(tokens2[1]);
            }
            case FILES: {
                if (dependency.type != Type.FILES) {
                    return false;
                }
                return FileUtil.pathsEqual((String)s1, (String)s2);
            }
            case FILETREE: 
        }
        if (dependency.type != Type.FILES) {
            return false;
        }
        Map values = (Map)this.data;
        String dir = (String)values.get(FILE_TREE_BASE_DIR_PROPERTY);
        Object value2 = values.get(FILE_TREE_INCLUDE_PATTERN_PROPERTY);
        if (value2 == null) {
            return false;
        }
        List list = includes = value2 instanceof List ? (List)value2 : ImmutableList.of((Object)value2.toString());
        if (dir == null || includes == null) {
            return false;
        }
        File baseDir = new File(dir);
        File depFile = new File(s2);
        File depDir = depFile.getParentFile();
        if (depDir == null) {
            return false;
        }
        if (FileUtil.filesEqual((File)baseDir, (File)depDir)) {
            for (String glob : includes) {
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)glob));
                if (!pattern.matcher(depFile.getName()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scope, this.type, this.data});
    }

    public String toString() {
        return "Dependency {myScope=" + (Object)((Object)this.scope) + ", myType=" + (Object)((Object)this.type) + ", myData='" + this.data + '\'' + '}';
    }

    @NotNull
    public String getValueAsString() {
        return this.data.toString();
    }

    public static ValueFactory getFactory() {
        return new DependencyFactory();
    }

    private static class DependencyFactory
    extends BuildFileStatementFactory {
        private DependencyFactory() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public List<BuildFileStatement> getValues(@NotNull PsiElement statement) {
            if (!(statement instanceof GrMethodCall)) {
                return DependencyFactory.getUnparseableStatements(statement);
            }
            GrMethodCall call = (GrMethodCall)statement;
            Scope scope = Scope.fromMethodCall(GradleGroovyFile.getMethodCallName(call));
            if (scope == null) {
                return DependencyFactory.getUnparseableStatements(statement);
            }
            String extraClosure = null;
            GrClosableBlock[] closureArguments = ((GrMethodCall)statement).getClosureArguments();
            if (closureArguments.length > 0) {
                extraClosure = closureArguments[0].getText();
            }
            GrArgumentList argumentList = call.getArgumentList();
            ArrayList dependencies = Lists.newArrayList();
            GroovyPsiElement[] allArguments = argumentList.getAllArguments();
            if (allArguments.length == 1) {
                GroovyPsiElement element = allArguments[0];
                if (element instanceof GrMethodCall) {
                    GrMethodCall method = (GrMethodCall)element;
                    String methodName = GradleGroovyFile.getMethodCallName(method);
                    if ("project".equals(methodName)) {
                        Object value2 = GradleGroovyFile.getFirstLiteralArgumentValue(method);
                        if (value2 != null) {
                            dependencies.add(new Dependency(scope, Type.MODULE, value2.toString(), extraClosure));
                            return dependencies;
                        } else {
                            Map<String, Object> values = GradleGroovyFile.getNamedArgumentValues(method);
                            if (values.isEmpty()) return dependencies;
                            dependencies.add(new Dependency(scope, Type.MODULE, values, extraClosure));
                        }
                        return dependencies;
                    } else if ("files".equals(methodName)) {
                        for (Object o : GradleGroovyFile.getLiteralArgumentValues(method)) {
                            dependencies.add(new Dependency(scope, Type.FILES, o.toString(), extraClosure));
                        }
                        return dependencies;
                    } else if ("fileTree".equals(methodName)) {
                        Map<String, Object> values = GradleGroovyFile.getNamedArgumentValues(method);
                        dependencies.add(new Dependency(scope, Type.FILETREE, values, extraClosure));
                        return dependencies;
                    } else {
                        LOG.warn("Didn't know how to parse dependency method call " + methodName);
                    }
                    return dependencies;
                } else {
                    if (!(element instanceof GrLiteral)) return DependencyFactory.getUnparseableStatements(statement);
                    Object value3 = ((GrLiteral)element).getValue();
                    if (value3 != null) {
                        dependencies.add(new Dependency(scope, Type.EXTERNAL, value3.toString(), extraClosure));
                        return dependencies;
                    } else {
                        if (!(element instanceof GrString)) return dependencies;
                        GroovyPsiElement[] contentParts = ((GrString)element).getAllContentParts();
                        StringBuilder buffer = new StringBuilder();
                        for (GroovyPsiElement part : contentParts) {
                            if (!(part instanceof GrStringContent) && !(part instanceof GrStringInjection)) continue;
                            buffer.append(part.getText());
                        }
                        if (buffer.length() <= 0) return dependencies;
                        dependencies.add(new Dependency(scope, Type.EXTERNAL, buffer.toString(), extraClosure));
                    }
                }
                return dependencies;
            } else {
                if (allArguments.length <= 1) return dependencies;
                Map<String, Object> attributes = GradleGroovyFile.getNamedArgumentValues(call);
                if (attributes.isEmpty()) {
                    return DependencyFactory.getUnparseableStatements(statement);
                }
                Object groupId = attributes.get("group");
                Object artifactId = attributes.get("name");
                Object version2 = attributes.get("version");
                Object ext = attributes.get("ext");
                if (groupId == null || artifactId == null || version2 == null) {
                    return DependencyFactory.getUnparseableStatements(statement);
                }
                String coordinate = Joiner.on((String)":").join(groupId, artifactId, new Object[]{version2});
                if (ext != null) {
                    coordinate = coordinate + "@" + ext;
                }
                dependencies.add(new Dependency(scope, Type.EXTERNAL, coordinate, extraClosure));
            }
            return dependencies;
        }
    }

    public static enum Type {
        FILES,
        FILETREE,
        EXTERNAL,
        MODULE;

    }

    public static enum Scope {
        COMPILE("Compile", "compile", true, true, true),
        PROVIDED("Provided", "provided", true, false, true),
        APK("APK", "apk", true, false, true),
        ANDROID_TEST_COMPILE("Test compile", "androidTestCompile", true, false, true),
        DEBUG_COMPILE("Debug compile", "debugCompile", true, false, true),
        RELEASE_COMPILE("Release compile", "releaseCompile", true, false, true),
        RUNTIME("Runtime", "runtime", false, true, true),
        TEST_COMPILE("Test compile", "testCompile", false, true, true),
        TEST_RUNTIME("Test runtime", "testRuntime", false, true, true),
        IMPLEMENTATION("Implementation", "implementation", true, true, false),
        API("API", "api", true, true, false),
        COMPILE_ONLY("Compile only", "compileOnly", true, false, false),
        RUNTIME_ONLY("Runtime only", "runtimeOnly", true, false, false),
        UNIT_TEST_IMPLEMENTATION("Unit Test implementation", "testImplementation", true, false, false),
        ANDROID_TEST_IMPLEMENTATION("Test implementation", "androidTestImplementation", true, false, false),
        DEBUG_IMPLEMENTATION("Debug implementation", "debugImplementation", true, false, false),
        RELEASE_IMPLEMENTATION("Release implementation", "releaseImplementation", true, false, false),
        TEST_COMPILE_ONLY("Test compile only", "testCompileOnly", false, true, false),
        TEST_RUNTIME_ONLY("Test runtime only", "testRuntimeOnly", false, true, false);

        private final String myGroovyMethodCall;
        private final String myDisplayName;
        private final boolean myAndroidScope;
        private final boolean myJavaScope;
        private final boolean myCompat;

        private Scope(String displayName, String groovyMethodCall, boolean androidScope, boolean javaScope, boolean compat) {
            this.myDisplayName = displayName;
            this.myGroovyMethodCall = groovyMethodCall;
            this.myAndroidScope = androidScope;
            this.myJavaScope = javaScope;
            this.myCompat = compat;
        }

        public String getGroovyMethodCall() {
            return this.myGroovyMethodCall;
        }

        @Nullable
        public static Scope fromMethodCall(@NotNull String methodCall) {
            for (Scope scope : Scope.values()) {
                if (!scope.myGroovyMethodCall.equals(methodCall)) continue;
                return scope;
            }
            return null;
        }

        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }

        public boolean isAndroidScope() {
            return this.myAndroidScope;
        }

        public boolean isJavaScope() {
            return this.myJavaScope;
        }

        public boolean isCompat() {
            return this.myCompat;
        }

        @NotNull
        public String toString() {
            return this.myDisplayName;
        }

        @NotNull
        public static Scope getDefaultScope(@NotNull Project project) {
            return GradleUtil.useCompatibilityConfigurationNames(project) ? COMPILE : IMPLEMENTATION;
        }
    }
}

