/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.text.Collator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class NamedObject
implements Comparable<NamedObject> {
    private String myName;
    private final boolean myAlwaysOnTop;
    private final Map<BuildFileKey, Object> myValues = Maps.newHashMap();

    public NamedObject(@NotNull String name) {
        this(name, false);
    }

    protected NamedObject(@NotNull String name, boolean alwaysOnTop) {
        this.myName = name;
        this.myAlwaysOnTop = alwaysOnTop;
    }

    public NamedObject(@NotNull NamedObject obj) {
        this.myName = obj.myName;
        this.myAlwaysOnTop = obj.myAlwaysOnTop;
        this.myValues.putAll(obj.myValues);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Map<BuildFileKey, Object> getValues() {
        return this.myValues;
    }

    @Nullable
    public Object getValue(@NotNull BuildFileKey buildFileKey) {
        return this.myValues.get((Object)buildFileKey);
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public void setValue(@NotNull BuildFileKey property2, @Nullable Object value2) {
        if (value2 == null) {
            this.myValues.remove((Object)property2);
        } else {
            this.myValues.put(property2, value2);
        }
    }

    public static ValueFactory getFactory(@NotNull List<BuildFileKey> properties) {
        return new Factory(properties);
    }

    @Override
    public int compareTo(NamedObject o) {
        if (this.myAlwaysOnTop != o.myAlwaysOnTop) {
            return this.myAlwaysOnTop ? -1 : 1;
        }
        return Collator.getInstance().compare(this.myName, o.myName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedObject)) {
            return false;
        }
        NamedObject that = (NamedObject)o;
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myValues.equals(that.myValues);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + this.myValues.hashCode();
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NamedObject ");
        sb.append(this.myName);
        sb.append(' ');
        sb.append(this.myValues.toString());
        return sb.toString();
    }

    public static class Factory
    extends ValueFactory<NamedObject> {
        private final List<BuildFileKey> myProperties;

        private Factory(@NotNull List<BuildFileKey> properties) {
            this.myProperties = properties;
        }

        @Override
        protected Iterable<NamedObject> findValuesToDelete(@NotNull GrStatementOwner closure, final @NotNull List<NamedObject> replacementValues) {
            return Iterables.filter(this.getValues(closure), (Predicate)new Predicate<NamedObject>(){

                public boolean apply(NamedObject input) {
                    for (NamedObject value2 : replacementValues) {
                        if (!value2.getName().equals(input.getName())) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        @Override
        protected void setValue(@NotNull GrStatementOwner closure, @NotNull NamedObject object, @Nullable ValueFactory.KeyFilter filter2) {
            GrClosableBlock subclosure = GradleGroovyFile.getMethodClosureArgument(closure, object.myName);
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)closure.getProject());
            if (subclosure == null) {
                closure.addBefore((PsiElement)factory.createStatementFromText((CharSequence)(object.getName() + " {\n}\n")), closure.getLastChild());
                subclosure = GradleGroovyFile.getMethodClosureArgument(closure, object.myName);
                if (subclosure == null) {
                    return;
                }
            }
            for (BuildFileKey property2 : this.myProperties) {
                if (filter2 != null && !filter2.shouldWriteKey(property2, object)) continue;
                Object value2 = object.getValue(property2);
                if (value2 != null) {
                    GradleGroovyFile.setValueStatic((GrStatementOwner)subclosure, property2, value2, false, null);
                    continue;
                }
                if (GradleGroovyFile.getValueStatic((GrStatementOwner)subclosure, property2) == GradleBuildFile.UNRECOGNIZED_VALUE) continue;
                GradleGroovyFile.removeValueStatic((GrStatementOwner)subclosure, property2);
            }
            GradleGroovyFile.reformatClosure((GrStatementOwner)subclosure);
        }

        @Override
        @Nullable
        public List<NamedObject> getValues(@NotNull PsiElement statement) {
            if (!(statement instanceof GrMethodCall)) {
                return null;
            }
            GrMethodCall method = (GrMethodCall)statement;
            NamedObject item = new NamedObject(GradleGroovyFile.getMethodCallName((GrMethodCall)statement));
            GrClosableBlock subclosure = GradleGroovyFile.getMethodClosureArgument(method);
            if (subclosure == null) {
                return null;
            }
            for (BuildFileKey property2 : this.myProperties) {
                Object value2 = GradleGroovyFile.getValueStatic((GrStatementOwner)subclosure, property2);
                if (value2 == null) continue;
                item.setValue(property2, value2);
            }
            return ImmutableList.of((Object)item);
        }

        @Override
        protected void removeValue(@NotNull GrStatementOwner closure, @NotNull NamedObject value2) {
            GrMethodCall call = GradleGroovyFile.getMethodCall(closure, value2.getName());
            if (call != null) {
                call.removeStatement();
            }
        }

        @NotNull
        public List<BuildFileKey> getProperties() {
            return this.myProperties;
        }
    }
}

