/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        return (AndroidPluginVersionUpdater)ServiceManager.getService((Project)project, AndroidPluginVersionUpdater.class);
    }

    public AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState) {
        this(project, syncState, GradleSyncInvoker.getInstance(), new TextSearch(project));
    }

    @VisibleForTesting
    AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncInvoker syncInvoker, @NotNull TextSearch textSearch) {
        this.myProject = project;
        this.mySyncState = syncState;
        this.mySyncInvoker = syncInvoker;
        this.myTextSearch = textSearch;
    }

    @Slow
    public boolean canDetectPluginVersionToUpdate(@NotNull GradleVersion pluginVersion) {
        boolean[] foundPlugin = new boolean[1];
        BuildFileProcessor.getInstance().processRecursively(this.myProject, (Processor<? super GradleBuildModel>)((Processor)buildModel -> {
            if (foundPlugin[0]) {
                return true;
            }
            DependenciesModel dependencies = buildModel.buildscript().dependencies();
            for (ArtifactDependencyModel dependency : dependencies.artifacts("classpath")) {
                ThreeState result2 = AndroidPluginVersionUpdater.isUpdatablePluginVersion(pluginVersion, dependency);
                if (result2 == ThreeState.YES) {
                    foundPlugin[0] = true;
                    break;
                }
                if (result2 != ThreeState.NO) continue;
                break;
            }
            return true;
        }));
        return foundPlugin[0];
    }

    public UpdateResult updatePluginVersionAndSync(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, boolean invalidateLastSyncOnFailure) {
        String msg;
        UpdateResult result2 = this.updatePluginVersion(pluginVersion, gradleVersion2);
        Throwable pluginVersionUpdateError = result2.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result2.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion2);
            AndroidPluginVersionUpdater.logUpdateError(msg, gradleVersionUpdateError);
        }
        this.handleUpdateResult(result2, invalidateLastSyncOnFailure);
        return result2;
    }

    @VisibleForTesting
    void handleUpdateResult(@NotNull UpdateResult result2, boolean invalidateLastSyncOnFailure) {
        Throwable pluginVersionUpdateError = result2.getPluginVersionUpdateError();
        if (pluginVersionUpdateError != null || result2.getGradleVersionUpdateError() != null) {
            if (invalidateLastSyncOnFailure) {
                this.mySyncState.invalidateLastSync("Failed to update either Android plugin version or Gradle version");
            }
            if (pluginVersionUpdateError != null) {
                this.myTextSearch.execute();
            }
        } else if (result2.isPluginVersionUpdated() || result2.isGradleVersionUpdated()) {
            if (!this.mySyncState.lastSyncFailedOrHasIssues()) {
                this.mySyncState.syncEnded();
            }
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_AGP_VERSION_UPDATED);
            request.cleanProject = true;
            this.mySyncInvoker.requestProjectSync(this.myProject, request);
        }
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        String cause = error.getMessage();
        if (StringUtil.isNotEmpty((String)cause)) {
            msg = msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn(msg);
    }

    @NotNull
    public UpdateResult updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2) {
        UpdateResult result2 = new UpdateResult();
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> this.updateAndroidPluginVersion(pluginVersion, gradleVersion2, result2));
        if (result2.isPluginVersionUpdated() && gradleVersion2 != null) {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> this.updateGradleWrapperVersion(gradleVersion2, result2));
        }
        return result2;
    }

    @NotNull
    private static ThreeState isUpdatablePluginVersion(@NotNull GradleVersion pluginVersion, @NotNull ArtifactDependencyModel model2) {
        String groupId;
        String artifactId = model2.name().forceString();
        if (!AndroidPluginInfo.isAndroidPlugin(artifactId, groupId = model2.group().toString())) {
            return ThreeState.UNSURE;
        }
        String versionValue = model2.version().toString();
        return StringUtil.isEmpty((String)versionValue) || pluginVersion.compareTo(versionValue) != 0 ? ThreeState.YES : ThreeState.NO;
    }

    private void updateAndroidPluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @NotNull UpdateResult result2) {
        boolean updateModels;
        ArrayList modelsToUpdate = new ArrayList();
        BuildFileProcessor.getInstance().processRecursively(this.myProject, (Processor<? super GradleBuildModel>)((Processor)buildModel -> {
            DependenciesModel dependencies = buildModel.buildscript().dependencies();
            for (ArtifactDependencyModel dependency : dependencies.artifacts("classpath")) {
                ThreeState shouldUpdate = AndroidPluginVersionUpdater.isUpdatablePluginVersion(pluginVersion, dependency);
                if (shouldUpdate == ThreeState.YES) {
                    dependency.version().getResultModel().setValue(pluginVersion.toString());
                    if (gradleVersion2 != null) {
                        buildModel.buildscript().repositories().addGoogleMavenRepository(gradleVersion2);
                    } else {
                        buildModel.buildscript().repositories().addGoogleMavenRepository(this.myProject);
                    }
                    modelsToUpdate.add(buildModel);
                    continue;
                }
                if (shouldUpdate != ThreeState.NO) continue;
                break;
            }
            return true;
        }));
        boolean bl = updateModels = !modelsToUpdate.isEmpty();
        if (updateModels) {
            try {
                for (GradleBuildModel buildModel2 : modelsToUpdate) {
                    buildModel2.applyChanges();
                }
                result2.pluginVersionUpdated();
            }
            catch (Throwable e) {
                result2.setPluginVersionUpdateError(e);
            }
        } else {
            result2.setPluginVersionUpdateError(new RuntimeException("Failed to find gradle build models to update."));
        }
    }

    private void updateGradleWrapperVersion(@NotNull GradleVersion gradleVersion2, @NotNull UpdateResult result2) {
        String basePath = this.myProject.getBasePath();
        if (basePath == null) {
            return;
        }
        ArrayList<File> projectRootFolders = new ArrayList<File>();
        projectRootFolders.add(new File(FileUtils.toSystemDependentPath((String)basePath)));
        projectRootFolders.addAll(BuildFileProcessor.getCompositeBuildFolderPaths(this.myProject));
        for (File rootFolder : projectRootFolders) {
            if (rootFolder == null) continue;
            try {
                File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(rootFolder);
                GradleWrapper gradleWrapper = GradleWrapper.get(wrapperPropertiesFilePath);
                String current = gradleWrapper.getGradleVersion();
                GradleVersion parsedCurrent = null;
                if (current != null) {
                    parsedCurrent = GradleVersion.tryParse((String)current);
                }
                if (parsedCurrent == null || GradleUtil.isSupportedGradleVersion(parsedCurrent)) continue;
                gradleWrapper.updateDistributionUrl(gradleVersion2.toString());
                result2.gradleVersionUpdated();
            }
            catch (Throwable e) {
                result2.setGradleVersionUpdateError(e);
            }
        }
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            ApplicationManager.getApplication().invokeLater(() -> {
                Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
                String textToFind = "com.android.tools.build:gradle";
                SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
            });
        }
    }

    public static class UpdateResult {
        @Nullable
        private Throwable myPluginVersionUpdateError;
        @Nullable
        private Throwable myGradleVersionUpdateError;
        private boolean myPluginVersionUpdated;
        private boolean myGradleVersionUpdated;

        @VisibleForTesting
        public UpdateResult() {
        }

        @Nullable
        public Throwable getPluginVersionUpdateError() {
            return this.myPluginVersionUpdateError;
        }

        void setPluginVersionUpdateError(@NotNull Throwable error) {
            this.myPluginVersionUpdateError = error;
        }

        @Nullable
        public Throwable getGradleVersionUpdateError() {
            return this.myGradleVersionUpdateError;
        }

        void setGradleVersionUpdateError(@NotNull Throwable error) {
            this.myGradleVersionUpdateError = error;
        }

        public boolean isPluginVersionUpdated() {
            return this.myPluginVersionUpdated;
        }

        void pluginVersionUpdated() {
            this.myPluginVersionUpdated = true;
        }

        public boolean isGradleVersionUpdated() {
            return this.myGradleVersionUpdated;
        }

        void gradleVersionUpdated() {
            this.myGradleVersionUpdated = true;
        }

        public boolean versionUpdateSuccess() {
            return (this.myPluginVersionUpdated || this.myGradleVersionUpdated) && this.myPluginVersionUpdateError == null && this.myGradleVersionUpdateError == null;
        }
    }
}

