/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.eclipse.AdtImportBuilder;
import com.android.tools.idea.gradle.eclipse.AdtImportProvider;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class AdtModuleImporter
extends ModuleImporter {
    @NotNull
    private final WizardContext myContext;
    @NotNull
    private final AdtImportProvider myProvider;
    private List<ModuleWizardStep> myWizardSteps;

    public AdtModuleImporter(@NotNull WizardContext context) {
        this.myContext = context;
        this.myProvider = new AdtImportProvider(false);
        this.myContext.setProjectBuilder((ProjectBuilder)this.myProvider.getBuilder());
    }

    public static boolean isAdtProjectLocation(@NotNull VirtualFile importSource) {
        VirtualFile target = ProjectImportUtil.findImportTarget(importSource);
        VirtualFile targetDir = target.isDirectory() ? target : target.getParent();
        File targetDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)targetDir);
        return GradleImport.isAdtProjectDir(targetDirFile) && targetDir.findChild("build.gradle") == null;
    }

    @Override
    @NotNull
    public List<? extends ModuleWizardStep> createWizardSteps() {
        Object[] adtImportSteps = this.myProvider.createSteps(this.myContext);
        this.myWizardSteps = Lists.newArrayList((Object[])adtImportSteps);
        return this.myWizardSteps;
    }

    @Override
    public void importProjects(Map<String, VirtualFile> projects) {
        Project project = this.myContext.getProject();
        assert (project != null);
        AdtImportBuilder builder = AdtImportBuilder.getBuilder(this.myContext);
        assert (builder != null);
        GradleImport importer = this.getGradleImport();
        ImmutableMap.Builder modules = ImmutableMap.builder();
        for (Map.Entry<String, VirtualFile> entry : projects.entrySet()) {
            modules.put((Object)VfsUtilCore.virtualToIoFile((VirtualFile)entry.getValue()), (Object)GradleUtil.getDefaultPhysicalPathFromGradlePath(entry.getKey()));
        }
        importer.setImportModuleNames((Map<File, String>)modules.build());
        if (builder.validate(null, project)) {
            builder.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER, null);
            builder.cleanup();
        }
    }

    @NotNull
    private GradleImport getGradleImport() {
        AdtImportBuilder builder = AdtImportBuilder.getBuilder(this.myContext);
        assert (builder != null);
        GradleImport importer = builder.getImporter();
        assert (importer != null);
        return importer;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canImport(@NotNull VirtualFile importSource) {
        return AdtModuleImporter.isAdtProjectLocation(importSource);
    }

    @Override
    @NotNull
    public Set<ModuleToImport> findModules(@NotNull VirtualFile importSource) throws IOException {
        AdtImportBuilder builder = (AdtImportBuilder)this.myContext.getProjectBuilder();
        assert (builder != null);
        builder.setSelectedProject(VfsUtilCore.virtualToIoFile((VirtualFile)importSource));
        final GradleImport gradleImport = this.getGradleImport();
        gradleImport.importProjects(Collections.singletonList(VfsUtilCore.virtualToIoFile((VirtualFile)importSource)));
        Map<String, File> adtProjects = gradleImport.getDetectedModuleLocations();
        HashSet modules = Sets.newHashSet();
        for (final Map.Entry<String, File> entry : adtProjects.entrySet()) {
            VirtualFile location = VfsUtil.findFileByIoFile((File)entry.getValue(), (boolean)false);
            modules.add(new ModuleToImport(entry.getKey(), location, (Supplier<? extends Iterable<String>>)new Supplier<Iterable<String>>(){

                public Iterable<String> get() {
                    return gradleImport.getProjectDependencies((String)entry.getKey());
                }
            }));
        }
        return modules;
    }

    @Override
    public boolean isStepVisible(@NotNull ModuleWizardStep step) {
        return this.myWizardSteps.contains(step);
    }
}

