/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleOrderEnumeratorHandler;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class AndroidGradleOrderEnumeratorHandlerFactory
extends GradleOrderEnumeratorHandler.FactoryImpl {
    @NotNull
    private static final String CLASSES_FOLDER_NAME = "classes";
    @NotNull
    private static final String RESOURCES_FOLDER_NAME = "resources";
    @NotNull
    private static final String MAIN_FOLDER_NAME = "main";
    @NotNull
    private static final String TEST_FOLDER_NAME = "test";
    @NotNull
    private static final String KOTLIN_FOLDER_NAME = "kotlin";

    public boolean isApplicable(@NotNull Module module) {
        return IdeInfo.getInstance().isAndroidStudio() || AndroidModuleModel.get(module) != null;
    }

    @NotNull
    public GradleOrderEnumeratorHandler createHandler(@NotNull Module module) {
        return new GradleOrderEnumeratorHandler(module){

            public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
                return false;
            }

            public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
                return true;
            }

            public boolean shouldProcessDependenciesRecursively() {
                return true;
            }

            public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result2, boolean includeProduction, boolean includeTests) {
                if (!type.equals((Object)OrderRootType.CLASSES)) {
                    return false;
                }
                AndroidModuleModel androidModel = AndroidModuleModel.get(rootModel.getModule());
                if (androidModel != null) {
                    result2.addAll(AndroidGradleOrderEnumeratorHandlerFactory.getAndroidCompilerOutputFolders(androidModel, includeProduction, includeTests));
                    super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                    return true;
                }
                JavaModuleModel javaModel = JavaModuleModel.get(rootModel.getModule());
                if (javaModel != null) {
                    result2.addAll(AndroidGradleOrderEnumeratorHandlerFactory.getJavaAndKotlinCompilerOutputFolders(javaModel, includeProduction, includeTests));
                    super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                    return true;
                }
                return super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
            }
        };
    }

    @NotNull
    private static List<String> getAndroidCompilerOutputFolders(@NotNull AndroidModuleModel androidModel, boolean includeProduction, boolean includeTests) {
        LinkedList<String> toAdd = new LinkedList<String>();
        if (includeTests) {
            if (androidModel.getSelectedVariant().getUnitTestArtifact() != null) {
                AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromArtifact((BaseArtifact)androidModel.getSelectedVariant().getUnitTestArtifact(), toAdd);
            }
            if (androidModel.getSelectedVariant().getAndroidTestArtifact() != null) {
                AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromArtifact((BaseArtifact)androidModel.getSelectedVariant().getAndroidTestArtifact(), toAdd);
            }
        }
        if (includeProduction) {
            AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromArtifact((BaseArtifact)androidModel.getSelectedVariant().getMainArtifact(), toAdd);
        }
        return toAdd;
    }

    private static void addFoldersFromArtifact(@NotNull BaseArtifact artifact, @NotNull List<String> toAdd) {
        toAdd.add(FilePaths.pathToIdeaUrl((File)artifact.getClassesFolder()));
        artifact.getAdditionalClassesFolders().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
        toAdd.add(FilePaths.pathToIdeaUrl((File)artifact.getJavaResourcesFolder()));
        if (artifact instanceof AndroidArtifact) {
            ((AndroidArtifact)artifact).getGeneratedResourceFolders().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
        }
    }

    @NotNull
    private static Collection<String> getJavaAndKotlinCompilerOutputFolders(@NotNull JavaModuleModel javaModel, boolean includeProduction, boolean includeTests) {
        LinkedList<String> toAdd = new LinkedList<String>();
        File mainClassesFolderPath = null;
        File mainResourcesFolderPath = null;
        File testClassesFolderPath = null;
        File testResourcesFolderPath = null;
        File mainKotlinClassesFolderPath = null;
        File testKotlinClassesFolderPath = null;
        ExtIdeaCompilerOutput compilerOutput = javaModel.getCompilerOutput();
        if (compilerOutput != null) {
            mainClassesFolderPath = compilerOutput.getMainClassesDir();
            mainResourcesFolderPath = compilerOutput.getMainResourcesDir();
            testClassesFolderPath = compilerOutput.getTestClassesDir();
            testResourcesFolderPath = compilerOutput.getTestResourcesDir();
        }
        File buildFolderPath = javaModel.getBuildFolderPath();
        if (javaModel.isBuildable()) {
            if (mainClassesFolderPath == null) {
                mainClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (mainResourcesFolderPath == null) {
                mainResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (testClassesFolderPath == null) {
                testClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
            if (testResourcesFolderPath == null) {
                testResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
        }
        if (buildFolderPath != null) {
            File kotlinClasses = buildFolderPath.toPath().resolve(CLASSES_FOLDER_NAME).resolve(KOTLIN_FOLDER_NAME).toFile();
            if (includeTests) {
                testKotlinClassesFolderPath = new File(kotlinClasses, TEST_FOLDER_NAME);
            }
            if (includeProduction) {
                mainKotlinClassesFolderPath = new File(kotlinClasses, MAIN_FOLDER_NAME);
            }
        }
        if (includeTests) {
            if (testClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)testClassesFolderPath));
            }
            if (testKotlinClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl(testKotlinClassesFolderPath));
            }
            if (testResourcesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)testResourcesFolderPath));
            }
        }
        if (includeProduction) {
            if (mainClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)mainClassesFolderPath));
            }
            if (mainKotlinClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl(mainKotlinClassesFolderPath));
            }
            if (mainResourcesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)mainResourcesFolderPath));
            }
        }
        return toAdd;
    }
}

