/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.LegacyAndroidProjects;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.build.GradleBuildContext;
import com.android.tools.idea.gradle.project.build.JpsBuildContext;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;

public class AndroidGradleProjectComponent
implements ProjectComponent {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleSyncInvoker myGradleSyncInvoker;
    @NotNull
    private final SupportedModuleChecker mySupportedModuleChecker;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final LegacyAndroidProjects myLegacyAndroidProjects;
    @Nullable
    private Disposable myDisposable;

    @NotNull
    public static AndroidGradleProjectComponent getInstance(@NotNull Project project) {
        AndroidGradleProjectComponent component = (AndroidGradleProjectComponent)project.getComponent(AndroidGradleProjectComponent.class);
        assert (component != null);
        return component;
    }

    public AndroidGradleProjectComponent(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull GradleBuildInvoker gradleBuildInvoker, @NotNull CompilerManager compilerManager, @NotNull SupportedModuleChecker supportedModuleChecker, @NotNull IdeInfo ideInfo) {
        this(project, gradleProjectInfo, androidProjectInfo, gradleSyncInvoker, gradleBuildInvoker, compilerManager, supportedModuleChecker, ideInfo, new LegacyAndroidProjects(project));
    }

    @VisibleForTesting
    public AndroidGradleProjectComponent(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull GradleBuildInvoker gradleBuildInvoker, @NotNull CompilerManager compilerManager, @NotNull SupportedModuleChecker supportedModuleChecker, @NotNull IdeInfo ideInfo, @NotNull LegacyAndroidProjects legacyAndroidProjects) {
        this.myProject = project;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleSyncInvoker = gradleSyncInvoker;
        this.mySupportedModuleChecker = supportedModuleChecker;
        this.myIdeInfo = ideInfo;
        this.myLegacyAndroidProjects = legacyAndroidProjects;
        compilerManager.addAfterTask(context -> {
            if (this.myGradleProjectInfo.isBuildWithGradle()) {
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                JpsBuildContext newContext = new JpsBuildContext(context);
                AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            }
            return true;
        });
        gradleBuildInvoker.add(result2 -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PostProjectBuildTasksExecutor.getInstance(this.myProject).onBuildCompletion(result2);
            GradleBuildContext newContext = new GradleBuildContext(result2);
            AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            if (AndroidGradleProjectComponent.isVfsRefreshAfterBuildRequired(this.myProject)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    FileDocumentManager.getInstance().saveAllDocuments();
                    SaveAndSyncHandler.getInstance().refreshOpenFiles();
                    VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
                });
            }
        });
    }

    private static boolean isVfsRefreshAfterBuildRequired(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null || !androidModuleModel.getFeatures().isVfsRefreshAfterBuildRequired()) continue;
            return true;
        }
        return false;
    }

    public void projectOpened() {
        GradleSyncStats.Trigger trigger;
        boolean checkSupported = true;
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (syncState.isSyncInProgress()) {
            syncState.notifyStateChanged();
        }
        if (this.myIdeInfo.isAndroidStudio() && this.myAndroidProjectInfo.isLegacyIdeaAndroidProject() && !this.myAndroidProjectInfo.isApkProject()) {
            this.myLegacyAndroidProjects.trackProject();
            if (!this.myGradleProjectInfo.isBuildWithGradle()) {
                this.myLegacyAndroidProjects.showMigrateToGradleWarning();
                return;
            }
        }
        GradleSyncStats.Trigger trigger2 = trigger = this.myGradleProjectInfo.isNewProject() ? GradleSyncStats.Trigger.TRIGGER_PROJECT_NEW : GradleSyncStats.Trigger.TRIGGER_PROJECT_REOPEN;
        if (this.myGradleProjectInfo.isBuildWithGradle()) {
            this.configureGradleProject();
            if (this.myAndroidProjectInfo.isLegacyIdeaAndroidProject() || !this.myGradleProjectInfo.hasGradleFacets()) {
                this.myGradleSyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, trigger);
                this.myGradleProjectInfo.setSkipStartupActivity(true);
                checkSupported = false;
            }
        } else if (this.myIdeInfo.isAndroidStudio() && this.myProject.getBaseDir() != null && GradleProjects.canImportAsGradleProject(this.myProject.getBaseDir())) {
            this.myGradleSyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, trigger);
            this.myGradleProjectInfo.setSkipStartupActivity(true);
            checkSupported = false;
        }
        if (checkSupported) {
            this.mySupportedModuleChecker.checkForSupportedModules(this.myProject);
        }
    }

    public void configureGradleProject() {
        if (this.myDisposable != null) {
            return;
        }
        this.myDisposable = Disposer.newDisposable();
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        }
        ArrayList<Class<TestMethodGradleConfigurationProducer>> runConfigurationProducerTypes = new ArrayList<Class<TestMethodGradleConfigurationProducer>>();
        runConfigurationProducerTypes.add(AllInPackageGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestClassGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestMethodGradleConfigurationProducer.class);
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        if (this.myIdeInfo.isAndroidStudio()) {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.add(clazz.getName());
            }
        } else {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.remove(clazz.getName());
            }
        }
    }

    public void projectClosed() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }
}

