/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProviderUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixAndroidRunConfigurationsAction
extends DumbAwareAction {
    public static final String ID = "Android.FixAndroidRunConfigurations";

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(FixAndroidRunConfigurationsAction.class);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(((Boolean)StudioFlags.FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED.get()).booleanValue());
        e.getPresentation().setVisible(false);
    }

    public static void perform(@Nullable Project project) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project == null || project.isDisposed()) {
            return;
        }
        FixAndroidRunConfigurationsAction.executeAction(ID);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        if (!((Boolean)StudioFlags.FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED.get()).booleanValue()) {
            return;
        }
        List<RunConfiguration> fixedConfigs = MakeBeforeRunTaskProviderUtil.fixConfigurationsMissingBeforeRunTask(project);
        if (fixedConfigs.isEmpty()) {
            return;
        }
        String configs = fixedConfigs.stream().map(x -> "\"" + x.getName() + "\"").collect(Collectors.joining(", "));
        String message2 = String.format("The IDE updated the following %s: %s.", StringUtil.pluralize((String)"run configuration", (int)fixedConfigs.size()), configs);
        FixAndroidRunConfigurationsAction.getLogger().warn(message2);
        AndroidNotification.getInstance(project).showBalloon("Android Run Configuration", message2, NotificationType.WARNING, AndroidNotification.BALLOON_GROUP, new OpenUrlHyperlink("https://d.android.com/r/studio-ui/gradle-aware-make-fix.html", "Learn more"));
    }

    private static void executeAction(@NotNull String actionId) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        AnAction action2 = actionManager.getAction(actionId);
        if (action2 == null) {
            return;
        }
        actionManager.tryToExecute(action2, ActionCommand.getInputEvent((String)actionId), null, "unknown", true);
    }
}

