/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myProjectInfo;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    private volatile boolean myNewProject;
    private volatile boolean myImportedProject;
    private final ProjectFacetManager myFacetManager;
    private volatile boolean mySkipStartupActivity;

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        return (GradleProjectInfo)ServiceManager.getService((Project)project, GradleProjectInfo.class);
    }

    public GradleProjectInfo(@NotNull Project project, @NotNull AndroidProjectInfo projectInfo, @NotNull ProjectFileIndex projectFileIndex) {
        this.myProject = project;
        this.myProjectInfo = projectInfo;
        this.myProjectFileIndex = projectFileIndex;
        this.myFacetManager = ProjectFacetManager.getInstance((Project)this.myProject);
    }

    public boolean isNewProject() {
        return this.myNewProject;
    }

    public void setNewProject(boolean newProject) {
        this.myNewProject = newProject;
    }

    public boolean isSkipStartupActivity() {
        return this.mySkipStartupActivity;
    }

    public void setSkipStartupActivity(boolean skipStartupActivity) {
        this.mySkipStartupActivity = skipStartupActivity;
    }

    public boolean isImportedProject() {
        return this.myImportedProject;
    }

    public void setImportedProject(boolean importedProject) {
        this.myImportedProject = importedProject;
    }

    public boolean isDirectGradleBuildEnabled() {
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public boolean isBuildWithGradle() {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            if (this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId())) {
                return true;
            }
            if (GradleSyncState.getInstance(this.myProject).getSummary().getSyncTimestamp() != -1L) {
                return true;
            }
            return this.hasTopLevelGradleBuildFile();
        });
    }

    public boolean hasGradleFacets() {
        return this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId());
    }

    public boolean hasTopLevelGradleBuildFile() {
        if (this.myProject.isDefault()) {
            return false;
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            for (String fileName : Arrays.asList("build.gradle", "build.gradle.kts")) {
                VirtualFile buildGradle = baseDir.findChild(fileName);
                if (buildGradle == null || buildGradle.isDirectory()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (AndroidFacet.getInstance(module) == null || GradleFacet.getInstance(module) == null) continue;
                modules.add((Object)module);
            }
        });
        return modules.build();
    }

    public void forEachAndroidModule(@NotNull Consumer<AndroidFacet> consumer) {
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null || GradleFacet.getInstance(module) == null) continue;
                consumer.consume((Object)androidFacet);
            }
        });
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file) {
        return this.findAndroidModelInModule(file, true);
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file, boolean honorExclusion) {
        Module module = this.findModuleForFile(file, honorExclusion);
        if (module == null) {
            VirtualFile rootFolder;
            if (this.myProjectInfo.requiresAndroidModel() && (rootFolder = this.myProject.getBaseDir()) != null) {
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(rootFolder) && (module = this.findModuleForFile(file, honorExclusion)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if (module.isDisposed()) {
            this.getLog().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return AndroidModuleModel.get(module);
    }

    @Nullable
    private Module findModuleForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        return this.myProjectFileIndex.getModuleForFile(file, honorExclusion);
    }

    @NotNull
    public Module[] getModulesToBuildFromSelection(@Nullable DataContext dataContext) {
        Module[] modules;
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && GradleProjectInfo.isProjectModule(modules[0])) {
                return ModuleManager.getInstance((Project)this.myProject).getModules();
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (GradleProjectInfo.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            return moduleArray;
        }
        return Module.EMPTY_ARRAY;
    }

    private static boolean isProjectModule(@NotNull Module module) {
        File moduleRootFolderPath = GradleProjects.findModuleRootFolderPath(module);
        if (moduleRootFolderPath == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootFolderPath, (File)new File(basePath)) && !GradleFacet.isAppliedTo(module);
    }

    @NotNull
    private Logger getLog() {
        return Logger.getInstance(this.getClass());
    }
}

