/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectImportUtil {
    @NonNls
    private static final String ANDROID_NATURE_NAME = "com.android.ide.eclipse.adt.AndroidNature";
    private static final Logger LOG = Logger.getInstance(ProjectImportUtil.class);
    private static final String[] GRADLE_SUPPORTED_FILES = new String[]{"build.gradle", "build.gradle.kts", "settings.gradle", "settings.gradle.kts"};

    private ProjectImportUtil() {
    }

    @NotNull
    public static VirtualFile findImportTarget(@NotNull VirtualFile file) {
        VirtualFile gradleTarget = ProjectImportUtil.findGradleTarget(file);
        if (gradleTarget != null) {
            return gradleTarget;
        }
        VirtualFile eclipseTarget = ProjectImportUtil.findEclipseTarget(file);
        if (eclipseTarget != null) {
            return eclipseTarget;
        }
        return file;
    }

    @Nullable
    private static VirtualFile findEclipseTarget(@NotNull VirtualFile file) {
        VirtualFile result2 = null;
        if (file.isDirectory()) {
            VirtualFile target = ProjectImportUtil.findMatch(file, ".project");
            if (target != null) {
                result2 = ProjectImportUtil.findImportTarget(target);
            }
        } else if (".project".equals(file.getName()) && ProjectImportUtil.hasAndroidNature(file)) {
            result2 = file;
        } else if (".classpath".equals(file.getName())) {
            result2 = ProjectImportUtil.findImportTarget(file.getParent());
        }
        return result2;
    }

    private static VirtualFile findGradleTarget(@NotNull VirtualFile file) {
        return ProjectImportUtil.findMatch(file, GRADLE_SUPPORTED_FILES);
    }

    @Nullable
    private static VirtualFile findMatch(@NotNull VirtualFile location, String ... validNames) {
        if (location.isDirectory()) {
            for (VirtualFile child : location.getChildren()) {
                for (String name : validNames) {
                    if (!name.equals(child.getName())) continue;
                    return child;
                }
            }
        } else {
            for (String name : validNames) {
                if (!name.equals(location.getName())) continue;
                return location;
            }
        }
        return null;
    }

    private static boolean hasAndroidNature(@NotNull VirtualFile projectFile) {
        File dotProjectFile = new File(projectFile.getPath());
        try {
            Element naturesElement = JDOMUtil.load((File)dotProjectFile).getChild("natures");
            if (naturesElement != null) {
                List naturesList = naturesElement.getChildren("nature");
                for (Element nature : naturesList) {
                    String natureName = nature.getText();
                    if (!ANDROID_NATURE_NAME.equals(natureName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.info(String.format("Unable to get natures for Eclipse project file '%1$s", projectFile.getPath()), (Throwable)e);
        }
        return false;
    }
}

