/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class ProjectStructure {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @NotNull
    private final AndroidPluginVersionsInProject myPluginVersionsInProject = new AndroidPluginVersionsInProject();
    @GuardedBy(value="myLock")
    @NotNull
    private final List<Module> myAppModules = new ArrayList<Module>();
    @GuardedBy(value="myLock")
    @NotNull
    private final List<Module> myLeafModules = new ArrayList<Module>();
    @GuardedBy(value="myLock")
    @NotNull
    private final Ref<ModuleFinder> myModuleFinderRef = new Ref((Object)ModuleFinder.EMPTY);

    @NotNull
    public static ProjectStructure getInstance(@NotNull Project project) {
        return (ProjectStructure)ServiceManager.getService((Project)project, ProjectStructure.class);
    }

    public ProjectStructure(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeProjectStructure(@NotNull ProgressIndicator progressIndicator) {
        AndroidPluginVersionsInProject pluginVersionsInProject = new AndroidPluginVersionsInProject();
        ConcurrentLinkedQueue<Module> appModules = new ConcurrentLinkedQueue<Module>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = moduleManager.getModules();
        ConcurrentLinkedQueue<Module> leafModules = new ConcurrentLinkedQueue<Module>(Arrays.asList(modules));
        ModuleFinder moduleFinder = new ModuleFinder(this.myProject);
        for (Module module : modules) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet != null) {
                String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                moduleFinder.addModule(module, gradlePath);
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel != null) {
                    pluginVersionsInProject.add(gradlePath, androidModel);
                    if (ProjectStructure.isApp(androidModel)) {
                        appModules.add(module);
                    }
                } else {
                    JavaFacet javaFacet = JavaFacet.getInstance(module);
                    if (javaFacet != null && !((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                        leafModules.remove(module);
                    }
                }
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                leafModules.removeAll(Arrays.stream(rootManager.getDependencies()).filter(m -> !ProjectStructure.isAppOrFeature(m)).collect(Collectors.toList()));
                continue;
            }
            leafModules.remove(module);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPluginVersionsInProject.copy(pluginVersionsInProject);
            this.myLeafModules.clear();
            this.myLeafModules.addAll(leafModules);
            this.myAppModules.clear();
            this.myAppModules.addAll(appModules);
            this.myModuleFinderRef.set((Object)moduleFinder);
        }
    }

    private static boolean isAppOrFeature(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).isAppOrFeature();
    }

    private static boolean isApp(@NotNull AndroidModuleModel androidModel) {
        int projectType = androidModel.getAndroidProject().getProjectType();
        return projectType == 0 || projectType == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AndroidPluginVersionsInProject getAndroidPluginVersions() {
        AndroidPluginVersionsInProject pluginVersionsInProject = new AndroidPluginVersionsInProject();
        Object object = this.myLock;
        synchronized (object) {
            pluginVersionsInProject.copy(this.myPluginVersionsInProject);
        }
        return pluginVersionsInProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<Module> getAppModules() {
        Object object = this.myLock;
        synchronized (object) {
            return ImmutableList.copyOf(this.myAppModules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<Module> getLeafModules() {
        Object object = this.myLock;
        synchronized (object) {
            return ImmutableList.copyOf(this.myLeafModules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ModuleFinder getModuleFinder() {
        Object object = this.myLock;
        synchronized (object) {
            return (ModuleFinder)this.myModuleFinderRef.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.myLock;
        synchronized (object) {
            this.myPluginVersionsInProject.clear();
            this.myAppModules.clear();
            this.myLeafModules.clear();
            this.myModuleFinderRef.set((Object)ModuleFinder.EMPTY);
        }
    }

    public static class AndroidPluginVersionsInProject {
        @NotNull
        private final Map<String, GradleVersion> myAgpVersionsPerModule = new HashMap<String, GradleVersion>();

        void copy(@NotNull AndroidPluginVersionsInProject other) {
            this.myAgpVersionsPerModule.putAll(other.myAgpVersionsPerModule);
        }

        void add(@NotNull String gradlePath, @NotNull AndroidModuleModel androidModel) {
            GradleVersion modelVersion = androidModel.getModelVersion();
            if (modelVersion != null) {
                this.add(gradlePath, modelVersion);
            }
        }

        @VisibleForTesting
        void add(@NotNull String gradlePath, @NotNull GradleVersion modelVersion) {
            this.myAgpVersionsPerModule.put(gradlePath, modelVersion);
        }

        void clear() {
            this.myAgpVersionsPerModule.clear();
        }

        public boolean haveVersionsChanged(@NotNull AndroidPluginVersionsInProject other) {
            if (!other.isEmpty()) {
                if (this.myAgpVersionsPerModule.size() != other.myAgpVersionsPerModule.size()) {
                    return true;
                }
                for (Map.Entry<String, GradleVersion> entry : this.myAgpVersionsPerModule.entrySet()) {
                    String modulePath = entry.getKey();
                    GradleVersion otherAgpVersion = other.myAgpVersionsPerModule.get(modulePath);
                    if (otherAgpVersion != null && entry.getValue().compareTo(otherAgpVersion) == 0) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isEmpty() {
            return this.myAgpVersionsPerModule.isEmpty();
        }

        @VisibleForTesting
        @NotNull
        ImmutableMap<String, GradleVersion> getInternalMap() {
            return ImmutableMap.copyOf(this.myAgpVersionsPerModule);
        }
    }
}

