/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SupportedModuleChecker {
    @NotNull
    public static SupportedModuleChecker getInstance() {
        return (SupportedModuleChecker)ServiceManager.getService(SupportedModuleChecker.class);
    }

    public void checkForSupportedModules(@NotNull Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length == 0 || !GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return;
        }
        ArrayList<Module> unsupportedModules = new ArrayList<Module>();
        boolean androidGradleSeen = false;
        for (Module module : modules) {
            ModuleType moduleType = ModuleType.get((Module)module);
            if (!(moduleType instanceof JavaModuleType)) continue;
            String externalSystemId = module.getOptionValue("external.system.id");
            if (!GradleUtil.GRADLE_SYSTEM_ID.getId().equals(externalSystemId)) {
                unsupportedModules.add(module);
                continue;
            }
            androidGradleSeen = true;
        }
        if (!androidGradleSeen || unsupportedModules.isEmpty()) {
            return;
        }
        String moduleNames = StringUtil.join(unsupportedModules, Module::getName, (String)", ");
        String text = "Compilation is not supported for following modules: " + moduleNames + ". Unfortunately you can't have non-Gradle Java modules and Android-Gradle modules in one project.";
        AndroidNotification.getInstance(project).showBalloon("Unsupported Modules Detected", text, NotificationType.ERROR);
    }
}

