/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.project.IndexingSuspender;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildState {
    @VisibleForTesting
    static final Topic<GradleBuildListener> GRADLE_BUILD_TOPIC = new Topic("Gradle build", GradleBuildListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @Nullable
    private BuildContext myCurrentContext;
    @GuardedBy(value="myLock")
    @Nullable
    private BuildSummary mySummary;

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener2) {
        return GradleBuildState.subscribe(project, listener2, (Disposable)project);
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener2, @NotNull Disposable parentDisposable) {
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(GRADLE_BUILD_TOPIC, (Object)listener2);
        return connection;
    }

    @NotNull
    public static GradleBuildState getInstance(@NotNull Project project) {
        return (GradleBuildState)ServiceManager.getService((Project)project, GradleBuildState.class);
    }

    public GradleBuildState(@NotNull Project project, @NotNull MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
        IndexingSuspender.ensureInitialised(this.myProject);
    }

    public void buildExecutorCreated(@NotNull GradleBuildInvoker.Request request) {
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildExecutorCreated(request)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStarted(@NotNull BuildContext context) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = context;
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildStarted(context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(@NotNull BuildStatus status) {
        BuildContext context;
        Object object = this.myLock;
        synchronized (object) {
            context = this.myCurrentContext;
            this.myCurrentContext = null;
            this.mySummary = new BuildSummary(status, context);
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildFinished(status, context)));
    }

    private void syncPublisher(@NotNull Consumer<GradleBuildListener> consumer) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> consumer.consume(this.myMessageBus.syncPublisher(GRADLE_BUILD_TOPIC)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuildInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildContext getCurrentContext() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildSummary getSummary() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySummary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = null;
            this.mySummary = null;
        }
    }
}

