/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.ide.common.blame.Message;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class PostProjectBuildTasksExecutor {
    private static final Key<Long> PROJECT_LAST_BUILD_TIMESTAMP_KEY = Key.create((String)"android.gradle.project.last.build.timestamp");
    @NotNull
    private final Project myProject;

    @NotNull
    public static PostProjectBuildTasksExecutor getInstance(@NotNull Project project) {
        return (PostProjectBuildTasksExecutor)ServiceManager.getService((Project)project, PostProjectBuildTasksExecutor.class);
    }

    public PostProjectBuildTasksExecutor(@NotNull Project project) {
        this.myProject = project;
    }

    public void onBuildCompletion(@NotNull CompileContext context) {
        Object errors = Collections.emptyIterator();
        CompilerMessage[] errorMessages = context.getMessages(CompilerMessageCategory.ERROR);
        if (errorMessages.length > 0) {
            errors = new CompilerMessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors, errorMessages.length);
    }

    @Nullable
    public Long getLastBuildTimestamp() {
        return (Long)this.myProject.getUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY);
    }

    public void onBuildCompletion(@NotNull GradleInvocationResult result2) {
        Object errors = Collections.emptyIterator();
        List<Message> errorMessages = result2.getCompilerMessages(Message.Kind.ERROR);
        if (!errorMessages.isEmpty()) {
            errors = new MessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors, errorMessages.size());
    }

    @VisibleForTesting
    void onBuildCompletion(Iterator<String> errorMessages, int errorCount) {
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            if (GradleProjects.isOfflineBuildModeEnabled(this.myProject)) {
                while (errorMessages.hasNext()) {
                    String error = errorMessages.next();
                    if (error == null || !PostProjectBuildTasksExecutor.unresolvedDependenciesFound(error)) continue;
                    this.notifyUnresolvedDependenciesInOfflineMode();
                    break;
                }
            }
            this.refreshProject();
            BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
            BuildMode buildMode = buildSettings.getBuildMode();
            String runConfigurationTypeId = buildSettings.getRunConfigurationTypeId();
            buildSettings.clear();
            this.myProject.putUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            if (runConfigurationTypeId != null) {
                return;
            }
            if (this.isSyncNeeded(buildMode, errorCount)) {
                GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_BUILD_SYNC_NEEDED_AFTER_BUILD);
                request.generateSourcesOnSuccess = false;
                PostProjectBuildTasksExecutor.runWhenEventsFinished(() -> GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request));
            }
            if (GradleProjects.isSyncRequestedDuringBuild(this.myProject)) {
                GradleProjects.setSyncRequestedDuringBuild(this.myProject, null);
                PostProjectBuildTasksExecutor.runWhenEventsFinished(() -> GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_USER_REQUEST_WHILE_BUILDING));
            }
        }
    }

    private boolean isSyncNeeded(@Nullable BuildMode buildMode, int errorCount) {
        if (BuildMode.DEFAULT_BUILD_MODE.equals((Object)buildMode) && GradleSyncState.getInstance(this.myProject).lastSyncFailed() && errorCount == 0) {
            return true;
        }
        return !BuildMode.SOURCE_GEN.equals((Object)buildMode) && GradleSyncState.getInstance(this.myProject).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private static void runWhenEventsFinished(@NotNull Runnable task) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(task);
        } else {
            application.invokeLater(task);
        }
    }

    private static boolean unresolvedDependenciesFound(@NotNull String errorMessage) {
        return errorMessage.contains("Could not resolve all dependencies");
    }

    private void notifyUnresolvedDependenciesInOfflineMode() {
        NotificationHyperlink disableOfflineModeHyperlink = new NotificationHyperlink("disable.gradle.offline.mode", "Disable offline mode"){

            @Override
            protected void execute(@NotNull Project project) {
                GradleSettings.getInstance((Project)PostProjectBuildTasksExecutor.this.myProject).setOfflineWork(false);
            }
        };
        String title = "Unresolved Dependencies";
        String text = "Unresolved dependencies detected while building project in offline mode. Please disable offline mode and try again.";
        AndroidNotification.getInstance(this.myProject).showBalloon(title, text, NotificationType.ERROR, disableOfflineModeHyperlink);
    }

    private void refreshProject() {
        VirtualFile rootDir;
        String projectPath = this.myProject.getBasePath();
        if (projectPath != null && (rootDir = LocalFileSystem.getInstance().findFileByPath(projectPath)) != null && rootDir.isDirectory()) {
            rootDir.refresh(true, true);
        }
    }

    private static class MessageIterator
    extends AbstractIterator<String> {
        private final Iterator<Message> myIterator;

        MessageIterator(@NotNull Collection<Message> compilerMessages) {
            this.myIterator = compilerMessages.iterator();
        }

        @Nullable
        protected String computeNext() {
            if (!this.myIterator.hasNext()) {
                return (String)this.endOfData();
            }
            Message msg = this.myIterator.next();
            return msg != null ? msg.getText() : null;
        }
    }

    private static class CompilerMessageIterator
    extends AbstractIterator<String> {
        @NotNull
        private final CompilerMessage[] myErrors;
        private int counter;

        CompilerMessageIterator(@NotNull CompilerMessage[] errors) {
            this.myErrors = errors;
        }

        @Nullable
        protected String computeNext() {
            if (this.counter >= this.myErrors.length) {
                return (String)this.endOfData();
            }
            return this.myErrors[this.counter++].getMessage();
        }
    }
}

