/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.events;

import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueEventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.AbstractBuildEvent;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSyncIssueEvent
extends AbstractBuildEvent
implements MessageEvent {
    @NotNull
    private final MessageEvent.Kind myKind;
    @NotNull
    private final String myGroup;
    @NotNull
    private final AndroidSyncIssueEventResult myResult;
    @Nullable
    private final Navigatable myNavigatable;

    public AndroidSyncIssueEvent(@NotNull Object parentId, @NotNull NotificationData notificationData, @NotNull String title) {
        super(new Object(), parentId, System.currentTimeMillis(), title);
        this.myKind = AndroidSyncIssueEvent.convertCategory(notificationData.getNotificationCategory());
        this.myNavigatable = notificationData.getNavigatable();
        this.myResult = new AndroidSyncIssueEventResult(notificationData);
        this.myGroup = notificationData.getTitle();
    }

    @Contract(pure=true)
    @NotNull
    public static MessageEvent.Kind convertCategory(@NotNull NotificationCategory category) {
        switch (category) {
            case SIMPLE: {
                return MessageEvent.Kind.SIMPLE;
            }
            case INFO: {
                return MessageEvent.Kind.INFO;
            }
            case ERROR: {
                return MessageEvent.Kind.ERROR;
            }
            case WARNING: {
                return MessageEvent.Kind.WARNING;
            }
        }
        return MessageEvent.Kind.ERROR;
    }

    @NotNull
    public MessageEvent.Kind getKind() {
        return this.myKind;
    }

    @NotNull
    public String getGroup() {
        return this.myGroup;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        return this.myNavigatable;
    }

    @NotNull
    public MessageEventResult getResult() {
        return this.myResult;
    }
}

