/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.filters.AndroidReRunBuildFilter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutorFactory;
import com.android.tools.idea.gradle.project.build.invoker.NativeDebugSessionFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.build.output.AndroidGradlePluginOutputParser;
import com.android.tools.idea.gradle.project.build.output.BuildOutputParserWrapper;
import com.android.tools.idea.gradle.project.build.output.BuildOutputParserWrapperKt;
import com.android.tools.idea.gradle.project.build.output.ClangOutputParser;
import com.android.tools.idea.gradle.project.build.output.CmakeOutputParser;
import com.android.tools.idea.gradle.project.build.output.DataBindingOutputParser;
import com.android.tools.idea.gradle.project.build.output.GradleBuildOutputParser;
import com.android.tools.idea.gradle.project.build.output.XmlErrorOutputParser;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.tracer.Trace;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.output.JavacOutputParser;
import com.intellij.build.output.KotlincOutputParser;
import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.XDebugSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.BuildAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileDocumentManager myDocumentManager;
    @NotNull
    private final GradleTasksExecutorFactory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
    @NotNull
    private final List<String> myOneTimeGradleOptions = new ArrayList<String>();
    @NotNull
    private final Multimap<String, String> myLastBuildTasks = ArrayListMultimap.create();
    @NotNull
    private final BuildStopper myBuildStopper = new BuildStopper();
    @NotNull
    private final NativeDebugSessionFinder myNativeDebugSessionFinder;

    @NotNull
    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        return (GradleBuildInvoker)ServiceManager.getService((Project)project, GradleBuildInvoker.class);
    }

    public GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        this(project, documentManager, new GradleTasksExecutorFactory(), new NativeDebugSessionFinder(project));
    }

    @VisibleForTesting
    protected GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager, @NotNull GradleTasksExecutorFactory tasksExecutorFactory, @NotNull NativeDebugSessionFinder nativeDebugSessionFinder) {
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myTaskExecutorFactory = tasksExecutorFactory;
        this.myNativeDebugSessionFinder = nativeDebugSessionFinder;
    }

    public void cleanProject() {
        if (this.stopNativeDebugSessionOrStopBuild()) {
            return;
        }
        this.setProjectBuildMode(BuildMode.CLEAN);
        ArrayListMultimap tasks = ArrayListMultimap.create();
        File projectPath = Projects.getBaseDirPath((Project)this.myProject);
        ArrayList<String> commandLineArgs = new ArrayList<String>();
        if (GradleProjectBuilder.getInstance(this.myProject).isSourceGenerationEnabled()) {
            Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
            tasks.putAll(GradleTaskFinder.getInstance().findTasksToExecute(modules, BuildMode.SOURCE_GEN, TestCompileType.NONE));
            tasks.keys().elementSet().forEach(arg_0 -> GradleBuildInvoker.lambda$cleanProject$0((ListMultimap)tasks, arg_0));
            commandLineArgs.add(GradleBuildInvoker.createGenerateSourcesOnlyProperty());
        } else {
            tasks.put((Object)projectPath.toPath(), (Object)"clean");
        }
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), commandLineArgs);
        }
    }

    public void cleanAndGenerateSources() {
        this.generateSources(true);
    }

    public void generateSources() {
        this.generateSources(false);
    }

    private void generateSources(boolean cleanProject) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        GradleTaskFinder gradleTaskFinder = GradleTaskFinder.getInstance();
        ListMultimap<Path, String> tasks = gradleTaskFinder.findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        if (cleanProject) {
            if (this.stopNativeDebugSessionOrStopBuild()) {
                return;
            }
            tasks.keys().elementSet().forEach(key -> tasks.get(key).add(0, "clean"));
        }
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
        }
    }

    private boolean stopNativeDebugSessionOrStopBuild() {
        XDebugSession nativeDebugSession = this.myNativeDebugSessionFinder.findNativeDebugSession();
        if (nativeDebugSession != null) {
            Ref yesNoCancelRef = new Ref();
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(() -> yesNoCancelRef.set((Object)this.promptUserToStopNativeDebugSession()), ModalityState.NON_MODAL);
            int yesNoCancel = (Integer)yesNoCancelRef.get();
            switch (yesNoCancel) {
                case 0: {
                    nativeDebugSession.stop();
                    break;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    @Messages.YesNoCancelResult
    private int promptUserToStopNativeDebugSession() {
        final String propKey = "gradle.project.build.invoker.clean-terminates-debugger";
        String value2 = PropertiesComponent.getInstance().getValue(propKey);
        if (value2 == null) {
            Ref yesNoCancelRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                String message2 = "Cleaning or rebuilding your project while debugging can lead to unexpected behavior.\nYou can choose to either terminate the debugger before cleaning your project or keep debugging while cleaning.\nClicking \"Cancel\" stops Gradle from cleaning or rebuilding your project, and preserves your debug process.";
                MessageDialogBuilder.YesNoCancel dialogBuilder = MessageDialogBuilder.yesNoCancel((String)"Terminate debugging", (String)message2);
                int answer = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)dialogBuilder.project(this.myProject)).yesText("Terminate")).noText("Do not terminate")).cancelText("Cancel").doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                    public void rememberChoice(boolean isSelected, int exitCode) {
                        if (isSelected) {
                            PropertiesComponent.getInstance().setValue(propKey, Boolean.toString(exitCode == 0));
                        }
                    }
                })).show();
                yesNoCancelRef.set((Object)answer);
            }, ModalityState.NON_MODAL);
            int answer = (Integer)yesNoCancelRef.get();
            return answer;
        }
        GradleBuildInvoker.getLogger().debug(propKey + ": " + value2);
        return value2.equals("true") ? 0 : 1;
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        return AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        this.assemble(modules, testCompileType, Collections.emptyList(), null);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments, @Nullable BuildAction<?> buildAction) {
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), arguments, buildAction);
        }
    }

    public void bundle(@NotNull Module[] modules, @NotNull List<String> arguments, @Nullable BuildAction<?> buildAction) {
        BuildMode buildMode = BuildMode.BUNDLE;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), arguments, buildAction);
        }
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildWithTempOptions(@NotNull File buildFilePath, @NotNull List<String> options) {
        this.myOneTimeGradleOptions.addAll(options);
        try {
            Collection tasks = this.myLastBuildTasks.get((Object)buildFilePath.getPath());
            if (tasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>(tasks);
                this.executeTasks(buildFilePath, tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    @Deprecated
    public void executeTasks(@NotNull List<String> gradleTasks) {
        File path = Projects.getBaseDirPath((Project)this.myProject);
        this.executeTasks(path, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
        this.executeTasks(buildFilePath, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull ListMultimap<Path, String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        tasks.keys().elementSet().forEach(path -> this.executeTasks(path.toFile(), tasks.get(path), commandLineArguments, buildAction));
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        this.executeTasks(buildFilePath, gradleTasks, commandLineArguments, null);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Trace.addVmArgs(jvmArguments);
        Request request = new Request(this.myProject, buildFilePath, gradleTasks);
        ExternalSystemTaskNotificationListener buildTaskListener = this.createBuildTaskListener(request, "Build");
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments).setBuildAction(buildAction).setTaskListener(buildTaskListener);
        this.executeTasks(request);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener createBuildTaskListener(final @NotNull Request request, final String executionName) {
        final BuildViewManager buildViewManager = (BuildViewManager)ServiceManager.getService((Project)this.myProject, BuildViewManager.class);
        final List buildOutputParsersWrappers = Stream.of(new GradleBuildOutputParser(), new ClangOutputParser(), new CmakeOutputParser(), new XmlErrorOutputParser(), new AndroidGradlePluginOutputParser(), new DataBindingOutputParser(), new JavacOutputParser(), new KotlincOutputParser()).map(BuildOutputParserWrapper::new).collect(Collectors.toList());
        final BuildOutputInstantReaderImpl buildOutputInstantReader = new BuildOutputInstantReaderImpl((Object)request.myTaskId, (BuildProgressListener)buildViewManager, Collections.unmodifiableList(buildOutputParsersWrappers));
        try {
            return new ExternalSystemTaskNotificationListenerAdapter(){
                @NotNull
                private BuildOutputInstantReaderImpl myReader;
                private boolean myBuildFailed;
                {
                    this.myReader = buildOutputInstantReader;
                    this.myBuildFailed = false;
                }

                public void onStart(final @NotNull ExternalSystemTaskId id, String workingDir) {
                    AnAction restartAction = new AnAction(){

                        public void update(@NotNull AnActionEvent e) {
                            super.update(e);
                            e.getPresentation().setEnabled(!GradleBuildInvoker.this.myBuildStopper.contains(id));
                        }

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            myReader.close();
                            myBuildFailed = false;
                            buildOutputParsersWrappers.forEach(BuildOutputParserWrapper::reset);
                            myReader = new BuildOutputInstantReaderImpl((Object)request.myTaskId, (BuildProgressListener)buildViewManager, Collections.unmodifiableList(buildOutputParsersWrappers));
                            GradleBuildInvoker.this.executeTasks(request);
                        }
                    };
                    this.myBuildFailed = false;
                    buildOutputParsersWrappers.forEach(BuildOutputParserWrapper::reset);
                    Presentation presentation = restartAction.getTemplatePresentation();
                    presentation.setText("Restart");
                    presentation.setDescription("Restart");
                    presentation.setIcon(AllIcons.Actions.Compile);
                    long eventTime = System.currentTimeMillis();
                    StartBuildEventImpl event = new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id, executionName, workingDir, eventTime), "running...");
                    event.withRestartAction(restartAction).withExecutionFilter((Filter)new AndroidReRunBuildFilter(workingDir));
                    buildViewManager.onEvent((BuildEvent)event);
                }

                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                    if (event instanceof ExternalSystemTaskExecutionEvent) {
                        BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
                        buildViewManager.onEvent(buildEvent);
                    }
                }

                public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
                    buildViewManager.onEvent((BuildEvent)new OutputBuildEventImpl((Object)id, text, stdOut));
                    this.myReader.append((CharSequence)text);
                }

                public void onEnd(@NotNull ExternalSystemTaskId id) {
                    this.myReader.close();
                    if (this.myBuildFailed) {
                        BuildOutputParserWrapperKt.sendBuildFailureMetrics(buildOutputParsersWrappers, GradleBuildInvoker.this.myProject);
                    }
                }

                public void onSuccess(@NotNull ExternalSystemTaskId id) {
                    FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "completed successfully", (EventResult)new SuccessResultImpl());
                    buildViewManager.onEvent((BuildEvent)event);
                }

                public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                    this.myBuildFailed = true;
                    String title = executionName + " failed";
                    FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult((String)title, (Exception)e, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Project)GradleBuildInvoker.this.myProject);
                    buildViewManager.onEvent((BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "build failed", (EventResult)failureResult));
                }

                public void onCancel(@NotNull ExternalSystemTaskId id) {
                    super.onCancel(id);
                    FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "cancelled", (EventResult)new SkippedResultImpl());
                    buildViewManager.onEvent((BuildEvent)event);
                    this.myReader.close();
                }
            };
        }
        catch (Exception exception) {
            buildOutputInstantReader.close();
            throw exception;
        }
    }

    public void executeTasks(@NotNull Request request) {
        String buildFilePath = request.myBuildFilePath.getPath();
        this.myLastBuildTasks.removeAll((Object)buildFilePath);
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.putAll((Object)buildFilePath, gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        Runnable executeTasksTask = () -> {
            this.myDocumentManager.saveAllDocuments();
            executor.queue();
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executeTasksTask.run();
        } else if (request.isWaitForCompletion()) {
            executor.queueAndWaitForCompletion();
        } else {
            TransactionGuard.getInstance().submitTransactionAndWait(executeTasksTask);
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleBuildInvoker.class);
    }

    public boolean stopBuild(@NotNull ExternalSystemTaskId id) {
        if (this.myBuildStopper.contains(id)) {
            this.myBuildStopper.attemptToStopBuild(id, null);
            return true;
        }
        return false;
    }

    public void add(@NotNull AfterGradleInvocationTask task) {
        this.myAfterTasks.add(task);
    }

    @VisibleForTesting
    @NotNull
    protected AfterGradleInvocationTask[] getAfterInvocationTasks() {
        return this.myAfterTasks.toArray(new AfterGradleInvocationTask[0]);
    }

    public void remove(@NotNull AfterGradleInvocationTask task) {
        this.myAfterTasks.remove(task);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void lambda$cleanProject$0(ListMultimap tasks, Path key) {
        tasks.get((Object)key).add(0, "clean");
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final File myBuildFilePath;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final Map<String, String> myEnv;
        private boolean myPassParentEnvs = true;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        @Nullable
        private BuildAction myBuildAction;
        private boolean myWaitForCompletion;

        public Request(@NotNull Project project, @NotNull File buildFilePath, String ... gradleTasks) {
            this(project, buildFilePath, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
            this(project, buildFilePath, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            this.myProject = project;
            this.myBuildFilePath = buildFilePath;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
            this.myEnv = new LinkedHashMap<String, String>();
        }

        @NotNull
        Project getProject() {
            return this.myProject;
        }

        @NotNull
        List<String> getGradleTasks() {
            return this.myGradleTasks;
        }

        @NotNull
        List<String> getJvmArguments() {
            return this.myJvmArguments;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            return this;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            return this.myCommandLineArguments;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            return this;
        }

        public Request withEnvironmentVariables(Map<String, String> envs) {
            this.myEnv.putAll(envs);
            return this;
        }

        public Map<String, String> getEnv() {
            return Collections.unmodifiableMap(this.myEnv);
        }

        public Request passParentEnvs(boolean passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
            return this;
        }

        public boolean isPassParentEnvs() {
            return this.myPassParentEnvs;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            return this;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            return this.myTaskId;
        }

        @NotNull
        File getBuildFilePath() {
            return this.myBuildFilePath;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request waitForCompletion() {
            this.myWaitForCompletion = true;
            return this;
        }

        @Nullable
        public BuildAction getBuildAction() {
            return this.myBuildAction;
        }

        @NotNull
        public Request setBuildAction(@Nullable BuildAction buildAction) {
            this.myBuildAction = buildAction;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.myBuildFilePath, that.myBuildFilePath) && Objects.equals(this.myGradleTasks, that.myGradleTasks) && Objects.equals(this.myJvmArguments, that.myJvmArguments) && Objects.equals(this.myCommandLineArguments, that.myCommandLineArguments);
        }

        public int hashCode() {
            return Objects.hash(this.myBuildFilePath, this.myGradleTasks, this.myJvmArguments, this.myCommandLineArguments);
        }

        public String toString() {
            return "RequestSettings{myBuildFilePath=" + this.myBuildFilePath + ", myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + ", myBuildAction=" + this.myBuildAction + '}';
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }
}

