/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TasksPerProject {
    @NotNull
    private final ListMultimap<Path, String> myTasksPerProjectMap = ArrayListMultimap.create();

    public void addTasks(@NotNull String projectPath, @NotNull List<String> tasks) {
        Path path = Paths.get(projectPath, new String[0]);
        this.myTasksPerProjectMap.putAll((Object)path, tasks);
    }

    public boolean isEmpty() {
        return this.myTasksPerProjectMap.isEmpty();
    }

    public void add(@NotNull TasksPerProject tasks) {
        for (Map.Entry task : tasks.myTasksPerProjectMap.entries()) {
            if (this.myTasksPerProjectMap.values().contains(task.getValue())) continue;
            this.myTasksPerProjectMap.put(task.getKey(), task.getValue());
        }
    }

    @NotNull
    public Set<Path> getProjectPaths() {
        return this.myTasksPerProjectMap.keys().elementSet();
    }

    @NotNull
    public List<String> getTasks(@NotNull Path projectPath) {
        return this.myTasksPerProjectMap.get((Object)projectPath);
    }
}

