/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker.messages;

import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MessageTreeRenderer
extends MultilineTreeCellRenderer {
    MessageTreeRenderer() {
    }

    protected void initComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element = MessageTreeRenderer.getElement(value2);
        if (element != null) {
            String[] text = element.getText();
            if (text == null) {
                text = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (text.length > 0 && text[0] == null) {
                text[0] = "";
            }
            this.setText(text, "");
        }
        Icon icon2 = null;
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            icon2 = groupingElement.getFile() != null ? groupingElement.getFile().getFileType().getIcon() : AllIcons.FileTypes.Java;
        } else if (element instanceof SimpleMessageElement || element instanceof NavigatableMessageElement) {
            ErrorTreeElementKind kind = element.getKind();
            icon2 = MessageTreeRenderer.getIconFor(kind);
        }
        if (icon2 == null) {
            icon2 = EmptyIcon.ICON_16;
        }
        this.setIcon(icon2);
    }

    @NotNull
    private static Icon getIconFor(@NotNull ErrorTreeElementKind kind) {
        switch (kind) {
            case ERROR: {
                return AllIcons.General.BalloonError;
            }
            case WARNING: {
                return AllIcons.General.BalloonWarning;
            }
            case INFO: {
                return AllIcons.General.BalloonInformation;
            }
        }
        return EmptyIcon.ICON_16;
    }

    @Nullable
    private static ErrorTreeElement getElement(@Nullable Object value2) {
        Object userObject;
        if (value2 instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof ErrorTreeNodeDescriptor) {
            return ((ErrorTreeNodeDescriptor)userObject).getElement();
        }
        return null;
    }
}

