/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AndroidGradlePluginOutputParser
implements BuildOutputParser {
    @NotNull
    static final String ANDROID_GRADLE_PLUGIN_MESSAGES_GROUP = "Android Gradle Plugin";
    @NotNull
    private static final String WARNING_PREFIX = "warning:";
    @NotNull
    private static final String ERROR_PREFIX = "error:";

    public boolean parse(String line, BuildOutputInstantReader reader, Consumer<? super BuildEvent> messageConsumer) {
        if (WARNING_PREFIX.regionMatches(true, 0, line, 0, WARNING_PREFIX.length())) {
            String message2 = line.substring(WARNING_PREFIX.length()).trim();
            messageConsumer.accept((BuildEvent)new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.WARNING, ANDROID_GRADLE_PLUGIN_MESSAGES_GROUP, message2, message2));
            return true;
        }
        if (ERROR_PREFIX.regionMatches(true, 0, line, 0, ERROR_PREFIX.length())) {
            String message3 = line.substring(ERROR_PREFIX.length()).trim();
            messageConsumer.accept((BuildEvent)new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, ANDROID_GRADLE_PLUGIN_MESSAGES_GROUP, message3, message3));
            return true;
        }
        return false;
    }
}

