/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000f\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "jsonFormatter", "Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser;", "legacyFormatter", "Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser;", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "JsonDataBindingOutputParser", "LegacyDataBindingOutputParser", "intellij.android.core"})
public final class DataBindingOutputParser
implements BuildOutputParser {
    private final JsonDataBindingOutputParser jsonFormatter = new JsonDataBindingOutputParser();
    private final LegacyDataBindingOutputParser legacyFormatter = new LegacyDataBindingOutputParser();

    public boolean parse(@Nullable String line, @Nullable BuildOutputInstantReader reader, @Nullable Consumer<? super BuildEvent> messageConsumer) {
        return this.jsonFormatter.parse(line, reader, messageConsumer) || this.legacyFormatter.parse(line, reader, messageConsumer);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0000\u0012\u00020\r\u0018\u00010\fH\u0016J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "gson", "Lcom/google/gson/Gson;", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseErrorIn", "output", "Lcom/intellij/build/events/MessageEvent;", "Companion", "EncodedMessage", "FileLocation", "intellij.android.core"})
    private static final class JsonDataBindingOutputParser
    implements BuildOutputParser {
        private final Gson gson = new Gson();
        private static final String ERROR_LOG_HEADER = "Found data binding error(s):";
        private static final String ERROR_LOG_PREFIX = "[databinding] ";
        public static final Companion Companion = new Companion(null);

        public boolean parse(@Nullable String line, @Nullable BuildOutputInstantReader reader, @Nullable Consumer<? super BuildEvent> messageConsumer) {
            if (line == null || reader == null || messageConsumer == null) {
                return false;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)ERROR_LOG_HEADER, (boolean)false, (int)2, null)) {
                return true;
            }
            int errorPrefix = StringsKt.indexOf$default((CharSequence)line, (String)ERROR_LOG_PREFIX, (int)0, (boolean)false, (int)6, null);
            if (errorPrefix >= 0) {
                int errorStart = errorPrefix + ERROR_LOG_PREFIX.length();
                String string = line;
                JsonDataBindingOutputParser jsonDataBindingOutputParser = this;
                String string2 = string.substring(errorStart);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                String string3 = string2;
                return jsonDataBindingOutputParser.parseErrorIn(string3, reader, messageConsumer);
            }
            return false;
        }

        private final boolean parseErrorIn(String output, BuildOutputInstantReader reader, Consumer<? super MessageEvent> messageConsumer) {
            try {
                EncodedMessage msg = (EncodedMessage)this.gson.fromJson(output, EncodedMessage.class);
                String summary = StringsKt.substringBefore$default((String)msg.getMessage(), (char)'\n', null, (int)2, null);
                if (msg.getLocations().isEmpty()) {
                    messageConsumer.accept((MessageEvent)new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, "Data Binding compiler", summary, msg.getMessage()));
                } else {
                    File sourceFile = new File(msg.getFilePath()).getAbsoluteFile();
                    FileLocation location = (FileLocation)CollectionsKt.first(msg.getLocations());
                    FilePosition filePosition = new FilePosition(sourceFile, location.getStartLine(), location.getStartCol(), location.getEndLine(), location.getEndCol());
                    messageConsumer.accept((MessageEvent)new FileMessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, "Data Binding compiler", summary, msg.getMessage(), filePosition));
                }
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser$EncodedMessage;", "", "message", "", "filePath", "locations", "", "Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser$FileLocation;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getFilePath", "()Ljava/lang/String;", "getLocations", "()Ljava/util/List;", "getMessage", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
        private static final class EncodedMessage {
            @SerializedName(value="msg")
            @NotNull
            private final String message;
            @SerializedName(value="file")
            @NotNull
            private final String filePath;
            @SerializedName(value="pos")
            @NotNull
            private final List<FileLocation> locations;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String getFilePath() {
                return this.filePath;
            }

            @NotNull
            public final List<FileLocation> getLocations() {
                return this.locations;
            }

            public EncodedMessage(@NotNull String message2, @NotNull String filePath, @NotNull List<FileLocation> locations) {
                this.message = message2;
                this.filePath = filePath;
                this.locations = locations;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final String component2() {
                return this.filePath;
            }

            @NotNull
            public final List<FileLocation> component3() {
                return this.locations;
            }

            @NotNull
            public final EncodedMessage copy(@NotNull String message2, @NotNull String filePath, @NotNull List<FileLocation> locations) {
                return new EncodedMessage(message2, filePath, locations);
            }

            @NotNull
            public static /* synthetic */ EncodedMessage copy$default(EncodedMessage encodedMessage, String string, String string2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = encodedMessage.message;
                }
                if ((n & 2) != 0) {
                    string2 = encodedMessage.filePath;
                }
                if ((n & 4) != 0) {
                    list = encodedMessage.locations;
                }
                return encodedMessage.copy(string, string2, list);
            }

            @NotNull
            public String toString() {
                return "EncodedMessage(message=" + this.message + ", filePath=" + this.filePath + ", locations=" + this.locations + ")";
            }

            public int hashCode() {
                String string = this.message;
                String string2 = this.filePath;
                List<FileLocation> list = this.locations;
                return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof EncodedMessage)) break block3;
                        EncodedMessage encodedMessage = (EncodedMessage)object;
                        if (!Intrinsics.areEqual((Object)this.message, (Object)encodedMessage.message) || !Intrinsics.areEqual((Object)this.filePath, (Object)encodedMessage.filePath) || !Intrinsics.areEqual(this.locations, encodedMessage.locations)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser$FileLocation;", "", "startLine", "", "startCol", "endLine", "endCol", "(IIII)V", "getEndCol", "()I", "getEndLine", "getStartCol", "getStartLine", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.core"})
        private static final class FileLocation {
            @SerializedName(value="line0")
            private final int startLine;
            @SerializedName(value="col0")
            private final int startCol;
            @SerializedName(value="line1")
            private final int endLine;
            @SerializedName(value="col1")
            private final int endCol;

            public final int getStartLine() {
                return this.startLine;
            }

            public final int getStartCol() {
                return this.startCol;
            }

            public final int getEndLine() {
                return this.endLine;
            }

            public final int getEndCol() {
                return this.endCol;
            }

            public FileLocation(int startLine, int startCol, int endLine, int endCol) {
                this.startLine = startLine;
                this.startCol = startCol;
                this.endLine = endLine;
                this.endCol = endCol;
            }

            public final int component1() {
                return this.startLine;
            }

            public final int component2() {
                return this.startCol;
            }

            public final int component3() {
                return this.endLine;
            }

            public final int component4() {
                return this.endCol;
            }

            @NotNull
            public final FileLocation copy(int startLine, int startCol, int endLine, int endCol) {
                return new FileLocation(startLine, startCol, endLine, endCol);
            }

            @NotNull
            public static /* synthetic */ FileLocation copy$default(FileLocation fileLocation, int n, int n2, int n3, int n4, int n5, Object object) {
                if ((n5 & 1) != 0) {
                    n = fileLocation.startLine;
                }
                if ((n5 & 2) != 0) {
                    n2 = fileLocation.startCol;
                }
                if ((n5 & 4) != 0) {
                    n3 = fileLocation.endLine;
                }
                if ((n5 & 8) != 0) {
                    n4 = fileLocation.endCol;
                }
                return fileLocation.copy(n, n2, n3, n4);
            }

            @NotNull
            public String toString() {
                return "FileLocation(startLine=" + this.startLine + ", startCol=" + this.startCol + ", endLine=" + this.endLine + ", endCol=" + this.endCol + ")";
            }

            public int hashCode() {
                return ((Integer.hashCode(this.startLine) * 31 + Integer.hashCode(this.startCol)) * 31 + Integer.hashCode(this.endLine)) * 31 + Integer.hashCode(this.endCol);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof FileLocation)) break block3;
                        FileLocation fileLocation = (FileLocation)object;
                        if (!(this.startLine == fileLocation.startLine) || !(this.startCol == fileLocation.startCol) || !(this.endLine == fileLocation.endLine) || !(this.endCol == fileLocation.endCol)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser$Companion;", "", "()V", "ERROR_LOG_HEADER", "", "ERROR_LOG_PREFIX", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000b\u0018\u00010\nH\u0016J(\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseErrorIn", "output", "Lcom/intellij/build/events/MessageEvent;", "Companion", "intellij.android.core"})
    private static final class LegacyDataBindingOutputParser
    implements BuildOutputParser {
        private static final String ERROR_LOG_HEADER = "Found data binding errors.";
        private static final Regex ERROR_LOG_REGEX;
        private static final Regex ERROR_MESSAGE_REGEX;
        private static final Regex LOCATION_REGEX;
        public static final Companion Companion;

        public boolean parse(@Nullable String line, @Nullable BuildOutputInstantReader reader, @Nullable Consumer<? super BuildEvent> messageConsumer) {
            if (line == null || reader == null || messageConsumer == null) {
                return false;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)ERROR_LOG_HEADER, (boolean)false, (int)2, null)) {
                return true;
            }
            String string = line;
            Regex regex = ERROR_LOG_REGEX;
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            MatchResult matchResult = regex.matchEntire((CharSequence)string2);
            if (matchResult == null) {
                return false;
            }
            MatchResult match2 = matchResult;
            String message2 = (String)match2.getGroupValues().get(1);
            return this.parseErrorIn(message2, reader, messageConsumer);
        }

        private final boolean parseErrorIn(String output, BuildOutputInstantReader reader, Consumer<? super MessageEvent> messageConsumer) {
            try {
                MatchResult matchResult = ERROR_MESSAGE_REGEX.matchEntire((CharSequence)output);
                if (matchResult == null) {
                    return false;
                }
                MatchResult messageMatch = matchResult;
                String msg = (String)messageMatch.getGroupValues().get(1);
                String file = (String)messageMatch.getGroupValues().get(2);
                String loc = (String)messageMatch.getGroupValues().get(3);
                MatchResult matchResult2 = LOCATION_REGEX.matchEntire((CharSequence)loc);
                if (matchResult2 == null) {
                    return false;
                }
                MatchResult locMatch = matchResult2;
                String string = (String)locMatch.getGroupValues().get(1);
                int startLine = Integer.parseInt(string);
                String string2 = (String)locMatch.getGroupValues().get(2);
                int startCol = Integer.parseInt(string2);
                String string3 = (String)locMatch.getGroupValues().get(3);
                int endLine = Integer.parseInt(string3);
                String string4 = (String)locMatch.getGroupValues().get(4);
                int endCol = Integer.parseInt(string4);
                File sourceFile = new File(file);
                FilePosition filePosition = new FilePosition(sourceFile, startLine, startCol, endLine, endCol);
                messageConsumer.accept((MessageEvent)new FileMessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, "Data Binding compiler", msg, null, filePosition));
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        static {
            Companion = new Companion(null);
            ERROR_LOG_REGEX = new Regex("\\*\\*\\*\\*/ data binding error \\*\\*\\*\\*(.+)\\*\\*\\*\\*\\\\ data binding error \\*\\*\\*\\*");
            ERROR_MESSAGE_REGEX = new Regex("msg:(.+) file:(.+) loc:(.+) ");
            LOCATION_REGEX = new Regex("(\\d+):(\\d+) - (\\d+):(\\d+)");
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser$Companion;", "", "()V", "ERROR_LOG_HEADER", "", "ERROR_LOG_REGEX", "Lkotlin/text/Regex;", "ERROR_MESSAGE_REGEX", "LOCATION_REGEX", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

