/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/XmlErrorOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseNumber", "", "numberAsString", "Companion", "intellij.android.core"})
public final class XmlErrorOutputParser
implements BuildOutputParser {
    @NotNull
    public static final String XML_PARSING_GROUP = "Xml parsing";
    private static final Pattern pattern;
    public static final Companion Companion;

    public boolean parse(@Nullable String line, @Nullable BuildOutputInstantReader reader, @Nullable Consumer<? super BuildEvent> messageConsumer) {
        if (line == null || reader == null || messageConsumer == null) {
            return false;
        }
        int matchIndex = StringsKt.indexOf$default((CharSequence)line, (String)SAXParseException.class.getName(), (int)0, (boolean)false, (int)6, null);
        if (matchIndex == -1) {
            return false;
        }
        String string = line;
        int n = matchIndex + SAXParseException.class.getName().length();
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String messageLine = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        Matcher matcher = pattern.matcher(messageLine);
        if (matcher.matches()) {
            String systemId = matcher.group(1);
            int lineNumber = this.parseNumber(matcher.group(2));
            int columnNumber = this.parseNumber(matcher.group(3));
            String string4 = matcher.group(4);
            if (string4 == null) {
                string4 = "";
            }
            String message2 = string4;
            File file = null;
            if (systemId != null) {
                File file2;
                if (StringsKt.startsWith$default((String)systemId, (String)"file:", (boolean)false, (int)2, null)) {
                    String string5;
                    String string6 = systemId;
                    int n2 = 5;
                    String string7 = string6.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    String string8 = string5 = string7;
                    file2 = new File(string8);
                } else {
                    file2 = file = new File(systemId);
                }
            }
            if (file != null && file.isFile()) {
                messageConsumer.accept((BuildEvent)new FileMessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, "Xml parsing errors", message2, message2, new FilePosition(file, lineNumber, columnNumber)));
            } else {
                messageConsumer.accept((BuildEvent)new MessageEventImpl(reader.getBuildId(), MessageEvent.Kind.ERROR, "Xml parsing errors", message2, message2));
            }
            return true;
        }
        return false;
    }

    private final int parseNumber(String numberAsString) {
        int n;
        if (numberAsString == null) {
            return -1;
        }
        try {
            n = Integer.valueOf(numberAsString) - 1;
        }
        catch (Exception e) {
            n = -1;
        }
        return n;
    }

    static {
        Companion = new Companion(null);
        pattern = Pattern.compile("^(?:publicId: .*?)?(?:; systemId: (.*?))?(?:; lineNumber: (.*?))?(?:; columnNumber: (.*?))?(?:; (.*))?$");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/XmlErrorOutputParser$Companion;", "", "()V", "XML_PARSING_GROUP", "", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

