/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.java.model.JavaProject;
import com.android.java.model.builder.JavaLibraryPlugin;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.reflect.KType;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.AbstractKotlinGradleModelBuilder;
import org.jetbrains.kotlin.kapt.idea.KaptModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.builder.ModelBuildScriptClasspathBuilderImpl;

public class GradleInitScripts {
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final ContentCreator myContentCreator;

    @NotNull
    public static GradleInitScripts getInstance() {
        return (GradleInitScripts)ServiceManager.getService(GradleInitScripts.class);
    }

    public GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths) {
        this(embeddedDistributionPaths, new ContentCreator());
    }

    @VisibleForTesting
    GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull ContentCreator contentCreator) {
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        File initScriptFile = this.createLocalMavenRepoInitScriptFile();
        if (initScriptFile != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private File createLocalMavenRepoInitScriptFile() {
        String content;
        List repoPaths = this.myEmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPaths().stream().map(File::getPath).collect(Collectors.toCollection(ArrayList::new));
        if (!"https://maven.google.com/".equals(GoogleMavenRepositoryKt.GMAVEN_BASE_URL)) {
            repoPaths.add(GoogleMavenRepositoryKt.GMAVEN_BASE_URL);
        }
        if ((content = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths)) != null) {
            String fileName = "sync.local.repo";
            try {
                return GradleInitScripts.createInitScriptFile(fileName, content);
            }
            catch (Throwable e) {
                String message2 = String.format("Failed to set up Gradle init script: '%1$s'", fileName);
                GradleInitScripts.getLogger().warn(message2, e);
            }
        }
        return null;
    }

    public void addApplyJavaLibraryPluginInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        try {
            File initScriptFile = this.createApplyJavaLibraryPluginInitScriptFile();
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
        catch (IOException e) {
            GradleInitScripts.getLogger().warn("Failed to create init script that applies the Java library plugin, Java modules won't be configured properly.", (Throwable)e);
        }
    }

    public void addApplyKaptModelBuilderInitScript(@NotNull List<String> allArgs) {
        try {
            File initScriptFile = this.createKaptModelBuilderInitScriptFile();
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
        catch (IOException e) {
            GradleInitScripts.getLogger().warn("Failed to create init script that applies the Kapt model builder plugin, Kapt modules won't be configured properly.", (Throwable)e);
        }
    }

    public void addApplyBuildScriptClasspathModelBuilderInitScript(@NotNull List<String> allArgs) {
        try {
            Class<ModelBuildScriptClasspathBuilderImpl> buildScriptModelBuilderClass = ModelBuildScriptClasspathBuilderImpl.class;
            ArrayList<String> paths2 = new ArrayList<String>();
            paths2.add(PathManager.getJarPathForClass(buildScriptModelBuilderClass));
            paths2.add(PathManager.getJarPathForClass(ModelBuilderService.class));
            paths2.add(PathManager.getJarPathForClass(Multimap.class));
            String content = this.myContentCreator.createInitScriptContent(paths2, buildScriptModelBuilderClass.getName(), "BuildScriptClasspath");
            File buildScriptInitScriptFile = GradleInitScripts.createInitScriptFile("sync.ng.build.script.classpath", content);
            GradleInitScripts.addInitScriptCommandLineArg(buildScriptInitScriptFile, allArgs);
        }
        catch (IOException e) {
            GradleInitScripts.getLogger().warn("Failed to create init script that applies the BuildScriptClasspath model builder plugin, auto completion in build scripts won't work.", (Throwable)e);
        }
    }

    @NotNull
    private File createApplyJavaLibraryPluginInitScriptFile() throws IOException {
        String content = this.myContentCreator.createApplyJavaLibraryPluginInitScriptContent();
        return GradleInitScripts.createInitScriptFile("sync.java.lib", content);
    }

    @NotNull
    private File createKaptModelBuilderInitScriptFile() throws IOException {
        Class<KaptModelBuilderService> kaptModelBuilderClass = KaptModelBuilderService.class;
        ArrayList<String> paths2 = new ArrayList<String>();
        paths2.add(PathManager.getJarPathForClass(kaptModelBuilderClass));
        paths2.add(PathManager.getJarPathForClass(Unit.class));
        paths2.add(PathManager.getJarPathForClass(AbstractKotlinGradleModelBuilder.class));
        paths2.add(PathManager.getJarPathForClass(ModelBuilderService.class));
        String content = this.myContentCreator.createInitScriptContent(paths2, kaptModelBuilderClass.getName(), "Kapt");
        return GradleInitScripts.createInitScriptFile("sync.ng.kapt", content);
    }

    @NotNull
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content) throws IOException {
        File file = FileUtil.createTempFile((String)fileName, (String)".gradle");
        file.deleteOnExit();
        FileUtil.writeToFile((File)file, (String)content);
        GradleInitScripts.getLogger().info(String.format("init script file %s contents %s", fileName, GradleInitScripts.escapeAsStringLiteral(content)));
        return file;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleInitScripts.class);
    }

    @NotNull
    private static String escapeAsStringLiteral(@NotNull String s) {
        Escaper escaper = Escapers.builder().addEscape('\b', "\\b").addEscape('\t', "\\t").addEscape('\n', "\\n").addEscape('\f', "\\f").addEscape('\r', "\\r").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
        return "\"" + escaper.escape(s) + "\"";
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    @VisibleForTesting
    static class JavaLibraryPluginJars {
        JavaLibraryPluginJars() {
        }

        @NotNull
        List<String> getJarPaths() {
            return Arrays.asList(PathManager.getJarPathForClass(JavaProject.class), PathManager.getJarPathForClass(JavaLibraryPlugin.class), PathManager.getJarPathForClass(KType.class));
        }
    }

    @VisibleForTesting
    static class ContentCreator {
        @NotNull
        private final JavaLibraryPluginJars myJavaLibraryPluginJars;

        ContentCreator() {
            this(new JavaLibraryPluginJars());
        }

        ContentCreator(@NotNull JavaLibraryPluginJars javaLibraryPluginJars) {
            this.myJavaLibraryPluginJars = javaLibraryPluginJars;
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<String> repoPaths) {
            if (repoPaths.isEmpty()) {
                return null;
            }
            StringBuilder paths2 = new StringBuilder();
            for (String path : repoPaths) {
                path = GradleImport.escapeGroovyStringLiteral(path);
                paths2.append("      maven { url '").append(path).append("'}\n");
            }
            return "allprojects {\n  buildscript {\n    repositories {\n" + paths2 + "    }\n  }\n  repositories {\n" + paths2 + "  }\n}\n";
        }

        @NotNull
        String createApplyJavaLibraryPluginInitScriptContent() {
            List<String> paths2 = this.myJavaLibraryPluginJars.getJarPaths();
            return "initscript {\n    dependencies {\n        " + this.createClassPathString(paths2) + "\n    }\n}\nallprojects {\n    apply plugin: " + JavaLibraryPlugin.class.getName() + "\n}\n";
        }

        @NotNull
        String createInitScriptContent(@NotNull List<String> paths2, @NotNull String modelBuilderClassName, @NotNull String modelName) {
            return "import javax.inject.Inject\nimport org.gradle.tooling.provider.model.ToolingModelBuilderRegistry\nimport org.gradle.tooling.provider.model.ToolingModelBuilder\ninitscript {\n  dependencies {\n      " + this.createClassPathString(paths2) + "\n  }\n}\nallprojects {\n  apply plugin: " + modelName + "ModelBuilderPlugin\n}\nclass " + modelName + "ModelBuilder implements ToolingModelBuilder {\n  public " + modelBuilderClassName + " builder;\n  public " + modelName + "ModelBuilder() {\n    builder = new " + modelBuilderClassName + "();\n  }\n  public boolean canBuild(String modelName) {\n    return builder.canBuild(modelName);\n  }\n  public Object buildAll(String modelName, Project project) {\n    return builder.buildAll(modelName, project);\n  }\n}\nclass " + modelName + "ModelBuilderPlugin implements Plugin<Project>{ \n  ToolingModelBuilderRegistry registry\n  @Inject " + modelName + "ModelBuilderPlugin(ToolingModelBuilderRegistry registry) {\n    this.registry = registry  }\n\n\n  void apply(Project project) {\n    registry.register(new " + modelName + "ModelBuilder())\n  }\n}";
        }

        @NotNull
        String createClassPathString(@NotNull List<String> paths2) {
            StringBuilder classpath = new StringBuilder();
            classpath.append("classpath files([");
            int pathCount = paths2.size();
            for (int i2 = 0; i2 < pathCount; ++i2) {
                String jarPath = GradleImport.escapeGroovyStringLiteral(paths2.get(i2));
                classpath.append("'").append(jarPath).append("'");
                if (i2 >= pathCount - 1) continue;
                classpath.append(", ");
            }
            classpath.append("])");
            return classpath.toString();
        }
    }
}

