/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.NewProjectSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleProjectImporter {
    @NotNull
    private final SdkSync mySdkSync;
    @NotNull
    private final GradleSyncInvoker myGradleSyncInvoker;
    @NotNull
    private final NewProjectSetup myNewProjectSetup;
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    public static boolean ourSkipSetupFromTest;

    @NotNull
    public static GradleProjectImporter getInstance() {
        return (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
    }

    public GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker) {
        this(sdkSync, gradleSyncInvoker, new NewProjectSetup(), new ProjectFolder.Factory());
    }

    @VisibleForTesting
    GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull NewProjectSetup newProjectSetup, @NotNull ProjectFolder.Factory projectFolderFactory) {
        this.mySdkSync = sdkSync;
        this.myGradleSyncInvoker = gradleSyncInvoker;
        this.myNewProjectSetup = newProjectSetup;
        this.myProjectFolderFactory = projectFolderFactory;
    }

    @Nullable
    public Project importProject(@NotNull VirtualFile selectedFile) {
        VirtualFile projectFolder = GradleProjectImporter.findProjectFolder(selectedFile);
        Project newProject = this.importProjectCore(projectFolder);
        if (newProject != null) {
            GradleProjectInfo.getInstance(newProject).setSkipStartupActivity(true);
            this.myGradleSyncInvoker.requestProjectSyncAndSourceGeneration(newProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_NEW, GradleProjectImporter.createNewProjectListener(projectFolder));
        }
        return newProject;
    }

    @Nullable
    public Project importProjectCore(@NotNull VirtualFile projectFolder) {
        Project newProject;
        File projectFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectFolder);
        try {
            this.setUpLocalProperties(projectFolderPath);
            String projectName = projectFolder.getName();
            newProject = this.importProjectNoSync(projectName, projectFolderPath, new Request());
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            this.getLogger().error(e);
            newProject = null;
        }
        return newProject;
    }

    @NotNull
    private static VirtualFile findProjectFolder(@NotNull VirtualFile selectedFile) {
        return selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
    }

    private void setUpLocalProperties(@NotNull File projectFolderPath) throws IOException {
        try {
            LocalProperties localProperties = new LocalProperties(projectFolderPath);
            if (IdeInfo.getInstance().isAndroidStudio()) {
                this.mySdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            this.getLogger().info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            throw e;
        }
    }

    @NotNull
    private Logger getLogger() {
        return Logger.getInstance(this.getClass());
    }

    @NotNull
    private static GradleSyncListener createNewProjectListener(final @NotNull VirtualFile projectFolder) {
        return new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
                    FileChooserUtil.setLastOpenedFile((Project)project, (VirtualFile)projectFolder);
                    ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                    ToolWindows.activateProjectView(project);
                });
            }
        };
    }

    @NotNull
    public Project importProjectNoSync(@NotNull String projectName, @NotNull File projectFolderPath, @NotNull Request request) throws IOException {
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectFolderPath);
        projectFolder.createTopLevelBuildFile();
        projectFolder.createIdeaProjectFolder();
        Project newProject = request.project;
        if (newProject == null) {
            newProject = this.myNewProjectSetup.createProject(projectName, projectFolderPath.getPath());
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject);
            gradleSettings.setGradleVmOptions("");
            String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)projectFolderPath.getPath());
            GradleProjectSettings projectSettings = (GradleProjectSettings)gradleSettings.getLinkedProjectSettings(externalProjectPath);
            if (projectSettings == null) {
                HashSet projects = ContainerUtilRt.newHashSet((Iterable)gradleSettings.getLinkedProjectsSettings());
                projectSettings = new GradleProjectSettings();
                projectSettings.setExternalProjectPath(externalProjectPath);
                projects.add(projectSettings);
                gradleSettings.setLinkedProjectsSettings((Collection)projects);
            }
        }
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(newProject);
        projectInfo.setNewProject(request.isNewProject);
        projectInfo.setImportedProject(true);
        this.myNewProjectSetup.prepareProjectForImport(newProject, request.javaLanguageLevel);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            newProject.save();
        }
        return newProject;
    }

    public static class Request {
        @Nullable
        public final Project project;
        @Nullable
        public LanguageLevel javaLanguageLevel;
        public boolean isNewProject;

        public Request() {
            this.project = null;
        }

        public Request(@Nullable Project project) {
            this.project = project;
        }
    }
}

